/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.content;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.statics.FormattedContentToken;
import org.jfree.layouting.layouter.i18n.LocalizationContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.content.ContentFunction;

public class DateValueFunction
implements ContentFunction {
    @Override
    public ContentToken evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        Date date = DocumentContextUtility.getDate(layoutProcess.getDocumentContext());
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        LocalizationContext localizationContext = DocumentContextUtility.getLocalizationContext(layoutProcess.getDocumentContext());
        DateFormat dateFormat = this.getDateFormat(cSSValueArray, localizationContext, layoutElement.getLayoutContext().getLanguage());
        return new FormattedContentToken(date, dateFormat, dateFormat.format(date));
    }

    private DateFormat getDateFormat(CSSValue[] cSSValueArray, LocalizationContext localizationContext, Locale locale) {
        if (cSSValueArray.length < 1) {
            return localizationContext.getDateFormat(locale);
        }
        CSSValue cSSValue = cSSValueArray[0];
        if (!(cSSValue instanceof CSSStringValue)) {
            return localizationContext.getDateFormat(locale);
        }
        CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
        DateFormat dateFormat = localizationContext.getDateFormat(cSSStringValue.getValue(), locale);
        if (dateFormat != null) {
            return dateFormat;
        }
        return localizationContext.getDateFormat(locale);
    }
}

