/*
 * Decompiled with CFR 0.152.
 */
package bsh.collection;

import bsh.BshIterator;
import bsh.CollectionManager;
import bsh.InterpreterError;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

public class CollectionIterator
implements BshIterator {
    private Iterator iterator;

    public CollectionIterator(Object iterateOverMe) {
        this.iterator = this.createIterator(iterateOverMe);
    }

    protected Iterator createIterator(Object iterateOverMe) throws IllegalArgumentException {
        if (iterateOverMe == null) {
            throw new NullPointerException("Object arguments passed to the CollectionIterator constructor cannot be null.");
        }
        if (iterateOverMe instanceof Iterator) {
            return (Iterator)iterateOverMe;
        }
        if (iterateOverMe instanceof Collection) {
            return ((Collection)iterateOverMe).iterator();
        }
        Iterator it = this.getIteratorForIterable(iterateOverMe);
        if (it != null) {
            return it;
        }
        final CollectionManager.BasicBshIterator bbi = new CollectionManager.BasicBshIterator(iterateOverMe);
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return bbi.hasNext();
            }

            public Object next() {
                return bbi.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() is not supported");
            }
        };
    }

    Iterator getIteratorForIterable(Object iterateOverMe) {
        Iterator it;
        block4: {
            it = null;
            try {
                Class<?> c = Class.forName("java.lang.Iterable");
                if (!c.isInstance(iterateOverMe)) break block4;
                try {
                    Method m = c.getMethod("iterator", new Class[0]);
                    it = (Iterator)m.invoke(iterateOverMe, new Object[0]);
                }
                catch (Exception e) {
                    throw new InterpreterError("Unexpected problem calling \"iterator()\" on instance of java.lang.Iterable." + e);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return it;
    }

    @Override
    public Object next() {
        return this.iterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }
}

