/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.dummy;

import java.io.Serializable;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.dummy.DummyContentItem;

public class DummyContentLocation
implements ContentLocation,
Serializable {
    private String name;
    private ContentLocation parent;
    private Repository repository;
    private static final ContentEntity[] EMPTY_CONTENT_ENTITY = new ContentEntity[0];

    public DummyContentLocation(ContentLocation parent, String name) {
        if (parent == null) {
            throw new NullPointerException("Parent must not be null");
        }
        this.repository = parent.getRepository();
        this.parent = parent;
        this.name = name;
    }

    public DummyContentLocation(Repository repository, String name) {
        this.repository = repository;
        this.name = name;
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return EMPTY_CONTENT_ENTITY;
    }

    @Override
    public ContentEntity getEntry(String name) throws ContentIOException {
        throw new ContentIOException();
    }

    @Override
    public ContentItem createItem(String name) throws ContentCreationException {
        return new DummyContentItem(this, name);
    }

    @Override
    public ContentLocation createLocation(String name) throws ContentCreationException {
        return new DummyContentLocation(this, name);
    }

    @Override
    public boolean exists(String name) {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContentId() {
        return RepositoryUtilities.buildName(this, "/");
    }

    @Override
    public Object getAttribute(String domain, String key) {
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

