/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.io;

import java.io.File;
import java.io.IOException;
import org.pentaho.reporting.libraries.fonts.io.FontDataInputSource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ResourceFontDataInputSource
implements FontDataInputSource {
    private transient ResourceData rawData;
    private ResourceManager loader;
    private ResourceKey source;

    public ResourceFontDataInputSource(ResourceManager loader, ResourceKey source) {
        if (loader == null) {
            throw new NullPointerException();
        }
        if (source == null) {
            throw new NullPointerException();
        }
        this.loader = loader;
        this.source = source;
    }

    @Override
    public long getLength() {
        return this.rawData.getLength();
    }

    @Override
    public void readFullyAt(long position, byte[] buffer, int length) throws IOException {
        if (this.rawData == null) {
            try {
                this.rawData = this.loader.load(this.source);
            }
            catch (ResourceLoadingException e) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        int iPos = (int)(position & Integer.MAX_VALUE);
        try {
            this.rawData.getResource(this.loader, buffer, (long)iPos, length);
        }
        catch (ResourceLoadingException e) {
            throw new IOException("Unable to load data: " + e.getMessage());
        }
    }

    @Override
    public int readAt(long position) throws IOException {
        if (this.rawData == null) {
            try {
                this.rawData = this.loader.load(this.source);
            }
            catch (ResourceLoadingException e) {
                throw new IOException("Failed to load the raw data.");
            }
        }
        int iPos = (int)(position & Integer.MAX_VALUE);
        byte[] buffer = new byte[1];
        long length = this.rawData.getLength();
        if (length > -1L && (long)iPos >= length) {
            return -1;
        }
        try {
            this.rawData.getResource(this.loader, buffer, (long)iPos, 1);
            return buffer[0];
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
        catch (ResourceLoadingException e) {
            throw new IOException("Failed to read stream.");
        }
    }

    @Override
    public void dispose() {
        this.rawData = null;
    }

    @Override
    public String getFileName() {
        Object identifier = this.source.getIdentifier();
        if (identifier instanceof File) {
            File f = (File)identifier;
            return f.getPath();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceFontDataInputSource that = (ResourceFontDataInputSource)o;
        if (!this.loader.equals(that.loader)) {
            return false;
        }
        return this.source.equals((Object)that.source);
    }

    @Override
    public int hashCode() {
        int result = this.loader.hashCode();
        result = 29 * result + this.source.hashCode();
        return result;
    }
}

