/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif.models;

import be.teletask.onvif.models.DeviceType;
import java.util.Locale;

public abstract class Device
implements Comparable<Device> {
    public static final String TAG = Device.class.getSimpleName();
    private static final String FORMAT_HTTP = "http://%s";
    private String host;
    private String username;
    private String password;
    private boolean connected;

    public Device(String host) {
        this(host, "", "");
    }

    public Device(String host, String username, String password) {
        this.host = this.buildUrl(host);
        this.username = username;
        this.password = password;
    }

    public String getHostName() {
        return this.host;
    }

    public void setHostName(String url) {
        this.host = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public int compareTo(Device device) {
        return this.getHostName().compareTo(device.getHostName());
    }

    private String buildUrl(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            return url;
        }
        return String.format(Locale.getDefault(), FORMAT_HTTP, url);
    }

    public abstract DeviceType getType();
}

