/*
 * Decompiled with CFR 0.152.
 */
package cpdetector.io;

import cpdetector.util.collections.ITreeNode;
import cpdetector.util.collections.TreeNodeUniqueChildren;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarArchive
extends File {
    protected JarFile jar;
    protected Set childs = new TreeSet();

    public JarArchive(String pathname) throws IOException {
        super(pathname);
        this.jar = new JarFile(pathname);
        ITreeNode root = this.parseTree();
        System.out.println("tree:");
        System.out.println(root.toString() + '\n');
        this.buildTree(root, this);
    }

    private JarArchive(File f) {
        super(f.getAbsolutePath());
    }

    private ITreeNode parseTree() {
        TreeNodeUniqueChildren root = new TreeNodeUniqueChildren();
        Enumeration<JarEntry> entries = this.jar.entries();
        while (entries.hasMoreElements()) {
            TreeNodeUniqueChildren newnode = root;
            TreeNodeUniqueChildren oldnode = root;
            String entry = entries.nextElement().getName();
            System.out.println("Entry: " + entry);
            StringTokenizer tokenizer = new StringTokenizer(entry, "/");
            while (tokenizer.hasMoreElements()) {
                String path = tokenizer.nextToken();
                newnode = new TreeNodeUniqueChildren(path);
                oldnode.addChildNode(newnode);
                oldnode = newnode;
            }
        }
        return root;
    }

    protected void buildTree(ITreeNode node, JarArchive element) throws IOException {
        List childNodes = node.getAllChildren();
        Iterator childNodesIt = childNodes.iterator();
        while (childNodesIt.hasNext()) {
            ITreeNode childNode = (ITreeNode)childNodesIt.next();
            String search = this.getSearchPath(childNode);
            System.out.println("Searching for: " + search);
            JarEntry entry = this.jar.getJarEntry(search);
            if (entry == null) {
                System.err.println("Entry for " + search + " (" + this.jar.getName() + ")is null!!!");
                continue;
            }
            System.out.println("Entry: " + entry.toString());
            JarElement child = new JarElement(entry, this);
            child.buildTree(childNode, this);
            this.childs.add(child);
        }
        System.out.println(this + " has finished building...");
    }

    private String getSearchPath(ITreeNode node) {
        LinkedList l = new LinkedList();
        node.getUserObjectPathFromRoot(l);
        Iterator it = l.iterator();
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (it.hasNext()) {
            String token = it.next().toString();
            if (i != 0) {
                ret.append(token);
                if (it.hasNext()) {
                    ret.append('/');
                }
            }
            ++i;
        }
        return ret.toString();
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public int compareTo(File pathname) {
        return super.compareTo(pathname);
    }

    public boolean createNewFile() throws IOException {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean exists() {
        return true;
    }

    public File getAbsoluteFile() {
        return super.getAbsoluteFile();
    }

    public String getAbsolutePath() {
        String ret = super.getAbsolutePath();
        return ret;
    }

    public File getCanonicalFile() throws IOException {
        return super.getCanonicalFile();
    }

    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath();
    }

    public String getName() {
        return super.getName();
    }

    public String getParent() {
        return super.getParent();
    }

    public File getParentFile() {
        return super.getParentFile();
    }

    public String getPath() {
        return super.getPath();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAbsolute() {
        return super.isAbsolute();
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return super.lastModified();
    }

    public long length() {
        return super.length();
    }

    public String[] list() {
        String[] ret = new String[this.childs.size()];
        Iterator it = this.childs.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = it.next().toString();
            ++i;
        }
        return ret;
    }

    public String[] list(FilenameFilter filter) {
        LinkedList<String> ret = new LinkedList<String>();
        Iterator it = this.childs.iterator();
        while (it.hasNext()) {
            File next = (File)it.next();
            if (!filter.accept(next.getParentFile(), next.getName())) continue;
            ret.add(next.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public File[] listFiles() {
        File[] ret = new File[this.childs.size()];
        Iterator it = this.childs.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = (File)it.next();
            ++i;
        }
        return ret;
    }

    public File[] listFiles(FileFilter filter) {
        LinkedList<File> ret = new LinkedList<File>();
        Iterator it = this.childs.iterator();
        while (it.hasNext()) {
            File next = (File)it.next();
            if (!filter.accept(next)) continue;
            ret.add(next);
        }
        return ret.toArray(new File[ret.size()]);
    }

    public File[] listFiles(FilenameFilter filter) {
        LinkedList<File> ret = new LinkedList<File>();
        Iterator it = this.childs.iterator();
        while (it.hasNext()) {
            File next = (File)it.next();
            if (!filter.accept(next.getParentFile(), next.getName())) continue;
            ret.add(next);
        }
        return ret.toArray(new File[ret.size()]);
    }

    public boolean mkdir() {
        return false;
    }

    public boolean mkdirs() {
        return false;
    }

    public boolean renameTo(File dest) {
        return false;
    }

    public boolean setLastModified(long time) {
        return super.setLastModified(time);
    }

    public boolean setReadOnly() {
        return super.setReadOnly();
    }

    public String toString() {
        return super.toString();
    }

    public URI toURI() {
        return super.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return super.toURL();
    }

    class JarElement
    extends JarArchive {
        private File parent;
        private JarEntry entry;

        JarElement(JarEntry entry, File parent) throws IOException {
            super(new File(JarArchive.this.jar.getName()));
            this.parent = parent;
            if (entry == null) {
                System.err.println("Entry is null.");
            }
            this.entry = entry;
            this.jar = JarArchive.this.jar;
        }

        public File getAbsoluteFile() {
            return this;
        }

        public String getAbsolutePath() {
            String prefix = JarArchive.this.jar.getName();
            String postfix = this.entry.getName();
            return prefix + "/" + postfix;
        }

        public String getName() {
            return this.entry.getName();
        }

        public String getParent() {
            return this.parent.getAbsolutePath();
        }

        public File getParentFile() {
            return this.parent;
        }

        public boolean isDirectory() {
            return this.childs.size() != 0;
        }

        public boolean isFile() {
            return !this.isDirectory();
        }

        public long lastModified() {
            return this.entry.getTime();
        }

        public long length() {
            return this.entry.getSize();
        }

        public String toString() {
            return this.entry.toString();
        }

        public String getPath() {
            return this.entry.getName();
        }
    }
}

