/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.StreamBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;

public class OFBBlockCipher
extends StreamBlockCipher {
    private int a;
    private byte[] b;
    private byte[] c;
    private byte[] d;
    private final int e;
    private final BlockCipher f;

    public OFBBlockCipher(BlockCipher blockCipher, int n2) {
        super(blockCipher);
        this.f = blockCipher;
        this.e = n2 / 8;
        this.b = new byte[blockCipher.getBlockSize()];
        this.c = new byte[blockCipher.getBlockSize()];
        this.d = new byte[blockCipher.getBlockSize()];
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            if (byArray.length < this.b.length) {
                System.arraycopy(byArray, 0, this.b, this.b.length - byArray.length, byArray.length);
                for (int i2 = 0; i2 < this.b.length - byArray.length; ++i2) {
                    this.b[i2] = 0;
                }
            } else {
                System.arraycopy(byArray, 0, this.b, 0, this.b.length);
            }
            this.reset();
            if (parametersWithIV.getParameters() != null) {
                this.f.init(true, parametersWithIV.getParameters());
            }
        } else {
            this.reset();
            if (cipherParameters != null) {
                this.f.init(true, cipherParameters);
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.f.getAlgorithmName() + "/OFB" + this.e * 8;
    }

    @Override
    public int getBlockSize() {
        return this.e;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        this.processBytes(byArray, n2, this.e, byArray2, n3);
        return this.e;
    }

    @Override
    public void reset() {
        System.arraycopy(this.b, 0, this.c, 0, this.b.length);
        this.a = 0;
        this.f.reset();
    }

    @Override
    protected byte calculateByte(byte by2) throws DataLengthException, IllegalStateException {
        if (this.a == 0) {
            this.f.processBlock(this.c, 0, this.d, 0);
        }
        byte by3 = (byte)(this.d[this.a++] ^ by2);
        if (this.a == this.e) {
            this.a = 0;
            System.arraycopy(this.c, this.e, this.c, 0, this.c.length - this.e);
            System.arraycopy(this.d, 0, this.c, this.c.length - this.e, this.e);
        }
        return by3;
    }
}

