/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.generators;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.CramerShoupKeyGenerationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.CramerShoupParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.CramerShoupPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.CramerShoupPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CramerShoupKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private CramerShoupKeyGenerationParameters b;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.b = (CramerShoupKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        CramerShoupParameters cramerShoupParameters = this.b.getParameters();
        CramerShoupPrivateKeyParameters cramerShoupPrivateKeyParameters = this.a(this.b.getRandom(), cramerShoupParameters);
        CramerShoupPublicKeyParameters cramerShoupPublicKeyParameters = this.a(cramerShoupParameters, cramerShoupPrivateKeyParameters);
        cramerShoupPrivateKeyParameters.setPk(cramerShoupPublicKeyParameters);
        return new AsymmetricCipherKeyPair(cramerShoupPublicKeyParameters, cramerShoupPrivateKeyParameters);
    }

    private BigInteger a(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomInRange(a, bigInteger.subtract(a), secureRandom);
    }

    private CramerShoupPrivateKeyParameters a(SecureRandom secureRandom, CramerShoupParameters cramerShoupParameters) {
        BigInteger bigInteger = cramerShoupParameters.getP();
        CramerShoupPrivateKeyParameters cramerShoupPrivateKeyParameters = new CramerShoupPrivateKeyParameters(cramerShoupParameters, this.a(bigInteger, secureRandom), this.a(bigInteger, secureRandom), this.a(bigInteger, secureRandom), this.a(bigInteger, secureRandom), this.a(bigInteger, secureRandom));
        return cramerShoupPrivateKeyParameters;
    }

    private CramerShoupPublicKeyParameters a(CramerShoupParameters cramerShoupParameters, CramerShoupPrivateKeyParameters cramerShoupPrivateKeyParameters) {
        BigInteger bigInteger = cramerShoupParameters.getG1();
        BigInteger bigInteger2 = cramerShoupParameters.getG2();
        BigInteger bigInteger3 = cramerShoupParameters.getP();
        BigInteger bigInteger4 = bigInteger.modPow(cramerShoupPrivateKeyParameters.getX1(), bigInteger3).multiply(bigInteger2.modPow(cramerShoupPrivateKeyParameters.getX2(), bigInteger3));
        BigInteger bigInteger5 = bigInteger.modPow(cramerShoupPrivateKeyParameters.getY1(), bigInteger3).multiply(bigInteger2.modPow(cramerShoupPrivateKeyParameters.getY2(), bigInteger3));
        BigInteger bigInteger6 = bigInteger.modPow(cramerShoupPrivateKeyParameters.getZ(), bigInteger3);
        return new CramerShoupPublicKeyParameters(cramerShoupParameters, bigInteger4, bigInteger5, bigInteger6);
    }
}

