/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.page;

import java.util.Arrays;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.EmptyBoxDefinition;
import org.jfree.layouting.renderer.model.NodeLayoutProperties;
import org.jfree.layouting.renderer.model.NormalFlowRenderBox;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.page.PhysicalPageBox;

public class LogicalPageBox
extends BlockRenderBox {
    private PageGrid pageGrid;
    private long[] pageWidths;
    private long[] pageHeights;
    private long[] horizontalBreaks;
    private long[] verticalBreaks;
    private long pageWidth;
    private long pageHeight;
    private Object contentAreaId;
    private PageAreaRenderBox footerArea;
    private PageAreaRenderBox headerArea;
    private long pageOffset;
    private boolean normalFlowActive;

    public LogicalPageBox(PageGrid pageGrid) {
        super(EmptyBoxDefinition.getInstance());
        if (pageGrid == null) {
            throw new NullPointerException("PageGrid must not be null");
        }
        NormalFlowRenderBox normalFlowRenderBox = new NormalFlowRenderBox(EmptyBoxDefinition.getInstance());
        this.contentAreaId = normalFlowRenderBox.getInstanceId();
        this.headerArea = new PageAreaRenderBox(EmptyBoxDefinition.getInstance());
        this.headerArea.setParent(this);
        this.footerArea = new PageAreaRenderBox(EmptyBoxDefinition.getInstance());
        this.footerArea.setParent(this);
        this.updatePageArea(pageGrid);
        this.addChild(normalFlowRenderBox);
        this.setMajorAxis(1);
        this.setMinorAxis(0);
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("logical-page");
    }

    @Override
    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        NodeLayoutProperties nodeLayoutProperties = this.getNodeLayoutProperties();
        nodeLayoutProperties.setNamespace("http://jfreereport.sourceforge.net/namespaces/layout");
        nodeLayoutProperties.setTagName("logical-page");
    }

    public void updatePageArea(PageGrid pageGrid) {
        int n;
        if (pageGrid == null) {
            throw new NullPointerException();
        }
        this.pageGrid = pageGrid;
        this.pageHeights = new long[pageGrid.getColumnCount()];
        this.pageWidths = new long[pageGrid.getRowCount()];
        this.horizontalBreaks = new long[pageGrid.getColumnCount()];
        this.verticalBreaks = new long[pageGrid.getRowCount()];
        Arrays.fill(this.pageHeights, Long.MAX_VALUE);
        Arrays.fill(this.pageWidths, Long.MAX_VALUE);
        for (n = 0; n < pageGrid.getRowCount(); ++n) {
            for (int i = 0; i < pageGrid.getColumnCount(); ++i) {
                PhysicalPageBox physicalPageBox = pageGrid.getPage(n, i);
                this.pageHeights[n] = Math.min(this.pageHeights[n], physicalPageBox.getImageableHeight());
                this.pageWidths[i] = Math.min(this.pageWidths[i], physicalPageBox.getImageableWidth());
            }
        }
        this.pageHeight = 0L;
        for (n = 0; n < this.pageHeights.length; ++n) {
            this.pageHeight += this.pageHeights[n];
            this.verticalBreaks[n] = this.pageHeight;
        }
        this.pageWidth = 0L;
        for (n = 0; n < this.pageWidths.length; ++n) {
            this.pageWidth += this.pageWidths[n];
            this.horizontalBreaks[n] = this.pageWidth;
        }
    }

    public NormalFlowRenderBox getContentArea() {
        return (NormalFlowRenderBox)this.findNodeById(this.contentAreaId);
    }

    public PageAreaRenderBox getFooterArea() {
        return this.footerArea;
    }

    public PageAreaRenderBox getHeaderArea() {
        return this.headerArea;
    }

    @Override
    public LogicalPageBox getLogicalPage() {
        return this;
    }

    @Override
    public NormalFlowRenderBox getNormalFlow() {
        return this.getContentArea();
    }

    public PageGrid getPageGrid() {
        return this.pageGrid;
    }

    @Override
    public RenderBox getInsertationPoint() {
        return this.getContentArea().getInsertationPoint();
    }

    public long[] getPhysicalBreaks(int n) {
        if (n == 0) {
            return (long[])this.horizontalBreaks.clone();
        }
        return (long[])this.verticalBreaks.clone();
    }

    public boolean isOverflow() {
        return false;
    }

    @Override
    public RenderNode deriveFrozen(boolean bl) {
        LogicalPageBox logicalPageBox = (LogicalPageBox)super.deriveFrozen(bl);
        logicalPageBox.headerArea = (PageAreaRenderBox)this.headerArea.deriveFrozen(bl);
        logicalPageBox.footerArea = (PageAreaRenderBox)this.footerArea.deriveFrozen(bl);
        return logicalPageBox;
    }

    @Override
    public RenderNode derive(boolean bl) {
        LogicalPageBox logicalPageBox = (LogicalPageBox)super.derive(bl);
        logicalPageBox.headerArea = (PageAreaRenderBox)this.headerArea.derive(bl);
        logicalPageBox.footerArea = (PageAreaRenderBox)this.footerArea.derive(bl);
        return logicalPageBox;
    }

    @Override
    public RenderNode hibernate() {
        LogicalPageBox logicalPageBox = (LogicalPageBox)super.hibernate();
        logicalPageBox.headerArea = (PageAreaRenderBox)this.headerArea.hibernate();
        logicalPageBox.footerArea = (PageAreaRenderBox)this.footerArea.hibernate();
        return logicalPageBox;
    }

    @Override
    public Object clone() {
        try {
            LogicalPageBox logicalPageBox = (LogicalPageBox)super.clone();
            logicalPageBox.pageHeights = (long[])this.pageHeights.clone();
            logicalPageBox.pageWidths = (long[])this.pageWidths.clone();
            logicalPageBox.pageGrid = (PageGrid)this.pageGrid.clone();
            return logicalPageBox;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Cloning *must* be supported.");
        }
    }

    public boolean isNormalFlowActive() {
        return this.normalFlowActive;
    }

    public long getPageHeight() {
        return this.pageHeight;
    }

    public long getPageWidth() {
        return this.pageWidth;
    }

    public long getPageOffset() {
        return this.pageOffset;
    }

    public void setPageOffset(long l) {
        this.pageOffset = l;
    }

    public void setNormalFlowActive(boolean bl) {
        this.normalFlowActive = bl;
    }

    public void insertFirst(RenderNode renderNode) {
        this.insertBefore(this.getFirstChild(), renderNode);
    }

    public void insertLast(RenderNode renderNode) {
        this.insertAfter(this.getLastChild(), renderNode);
    }

    @Override
    public RenderNode findNodeById(Object object) {
        RenderNode renderNode = this.footerArea.findNodeById(object);
        if (renderNode != null) {
            return renderNode;
        }
        RenderNode renderNode2 = this.headerArea.findNodeById(object);
        if (renderNode2 != null) {
            return renderNode2;
        }
        return super.findNodeById(object);
    }
}

