/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.java;

import com.sun.star.document.XScriptInvocationContext;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.java.Resolver;
import com.sun.star.script.framework.provider.java.ScriptDescriptor;
import com.sun.star.script.framework.provider.java.ScriptProxy;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;

class ScriptImpl
implements XScript {
    private final ScriptMetaData metaData;
    private final XComponentContext m_xContext;
    private final XModel m_xModel;
    private final XScriptInvocationContext m_xInvocContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private final Resolver m_resolutionPolicy;

    ScriptImpl(XComponentContext ctx, Resolver resolver, ScriptMetaData metaData, XModel xModel, XScriptInvocationContext xInvocContext) throws RuntimeException {
        this.metaData = metaData;
        this.m_xContext = ctx;
        this.m_xModel = xModel;
        this.m_xInvocContext = xInvocContext;
        this.m_resolutionPolicy = resolver;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception e) {
            LogUtils.DEBUG((String)LogUtils.getTrace((Exception)e));
            throw new RuntimeException((Throwable)e, "Error constructing ScriptProvider: " + e);
        }
        LogUtils.DEBUG((String)("ScriptImpl [java] script data = " + metaData));
    }

    public Object invoke(Object[] params, short[][] aOutParamIndex, Object[][] aOutParam) throws ScriptFrameworkErrorException, com.sun.star.reflection.InvocationTargetException {
        ScriptFrameworkErrorException e2;
        LogUtils.DEBUG((String)"** ScriptProviderForJava::invoke: Starting...");
        aOutParamIndex[0] = new short[0];
        aOutParam[0] = new Object[0];
        ScriptDescriptor scriptDesc = new ScriptDescriptor(this.metaData.getLanguageName());
        Object[] invocationArgs = null;
        ScriptProxy script = null;
        LogUtils.DEBUG((String)"Classloader starting...");
        try (URLClassLoader scriptLoader = ClassLoaderFactory.getURLClassLoader((ScriptMetaData)this.metaData);){
            LogUtils.DEBUG((String)"Classloader finished...");
            ArrayList<Object> invocationArgList = new ArrayList<Object>();
            LogUtils.DEBUG((String)"Parameter Mapping...");
            XScriptContext xSc = ScriptContext.createContext((XModel)this.m_xModel, (XScriptInvocationContext)this.m_xInvocContext, (XComponentContext)this.m_xContext, (XMultiComponentFactory)this.m_xMultiComponentFactory);
            scriptDesc.addArgumentType(XScriptContext.class);
            invocationArgList.add(xSc);
            for (int i = 0; i < params.length; ++i) {
                scriptDesc.addArgumentType(params[i].getClass());
                invocationArgList.add(params[i]);
            }
            if (!invocationArgList.isEmpty()) {
                invocationArgs = invocationArgList.toArray();
            }
            LogUtils.DEBUG((String)"ScriptProxy starting... ");
            try {
                String className = this.metaData.getLanguageName().substring(0, this.metaData.getLanguageName().lastIndexOf(46));
                LogUtils.DEBUG((String)("About to load Class " + className + " starting... "));
                long start = new Date().getTime();
                Class<?> c = scriptLoader.loadClass(className);
                long end = new Date().getTime();
                LogUtils.DEBUG((String)("loadClass took: " + (end - start) + "milliseconds"));
                try {
                    LogUtils.DEBUG((String)"class loaded ... ");
                    script = this.m_resolutionPolicy.getProxy(scriptDesc, c);
                    LogUtils.DEBUG((String)"script resolved ... ");
                }
                catch (NoSuchMethodException e) {
                    ScriptFrameworkErrorException e22 = new ScriptFrameworkErrorException(e.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
                    e22.initCause((Throwable)e);
                    throw e22;
                }
            }
            catch (ClassNotFoundException e) {
                ScriptFrameworkErrorException e23 = new ScriptFrameworkErrorException(e.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
                e23.initCause((Throwable)e);
                throw e23;
            }
        }
        catch (IOException e) {
            ScriptFrameworkErrorException e24 = new ScriptFrameworkErrorException(e.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 2);
            e24.initCause((Throwable)e);
            throw e24;
        }
        LogUtils.DEBUG((String)"Starting Invoke on Proxy ...");
        Object result = null;
        try {
            long start = new Date().getTime();
            result = script.invoke(invocationArgs);
            long end = new Date().getTime();
            LogUtils.DEBUG((String)("invoke took: " + (end - start) + "milliseconds"));
        }
        catch (IllegalArgumentException iae) {
            e2 = new ScriptFrameworkErrorException(iae.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            e2.initCause((Throwable)iae);
            throw e2;
        }
        catch (IllegalAccessException ia) {
            e2 = new ScriptFrameworkErrorException(ia.toString(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            e2.initCause((Throwable)ia);
            throw e2;
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            ScriptExceptionRaisedException se = new ScriptExceptionRaisedException(targetException.toString());
            se.lineNum = -1;
            se.scriptName = this.metaData.getLanguageName();
            se.language = "Java";
            se.exceptionType = targetException.getClass().getName();
            throw new com.sun.star.reflection.InvocationTargetException("Scripting Framework error executing script ", null, (Object)se);
        }
        catch (Exception unknown) {
            ScriptExceptionRaisedException se = new ScriptExceptionRaisedException(unknown.toString());
            se.lineNum = -1;
            se.scriptName = this.metaData.getLanguageName();
            se.language = "Java";
            se.exceptionType = unknown.getClass().getName();
            throw new com.sun.star.reflection.InvocationTargetException("Scripting Framework error executing script ", null, (Object)se);
        }
        if (result == null) {
            LogUtils.DEBUG((String)"Got Nothing Back");
            Any voidAny = new Any(new Type(), null);
            result = voidAny;
        } else {
            LogUtils.DEBUG((String)("Got object " + result));
        }
        return result;
    }
}

