/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTKeyGenerationParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTKeyPairGenerator;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSMTSigner;
import com.aspose.cad.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;
import java.text.ParseException;

public final class XMSSMT {
    private XMSSMTParameters a;
    private XMSSParameters b;
    private SecureRandom c;
    private XMSSMTPrivateKeyParameters d;
    private XMSSMTPublicKeyParameters e;

    public XMSSMT(XMSSMTParameters xMSSMTParameters, SecureRandom secureRandom) {
        if (xMSSMTParameters == null) {
            throw new NullPointerException("params == null");
        }
        this.a = xMSSMTParameters;
        this.b = xMSSMTParameters.getXMSSParameters();
        this.c = secureRandom;
        this.d = new XMSSMTPrivateKeyParameters.Builder(xMSSMTParameters).build();
        this.e = new XMSSMTPublicKeyParameters.Builder(xMSSMTParameters).build();
    }

    public void generateKeys() {
        XMSSMTKeyPairGenerator xMSSMTKeyPairGenerator = new XMSSMTKeyPairGenerator();
        xMSSMTKeyPairGenerator.init(new XMSSMTKeyGenerationParameters(this.getParams(), this.c));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = xMSSMTKeyPairGenerator.generateKeyPair();
        this.d = (XMSSMTPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.e = (XMSSMTPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        this.a(this.d, this.e);
    }

    private void a(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters, XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters) {
        this.b.getWOTSPlus().a(new byte[this.a.getDigestSize()], this.d.getPublicSeed());
        this.d = xMSSMTPrivateKeyParameters;
        this.e = xMSSMTPublicKeyParameters;
    }

    public void importState(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("privateKey == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = new XMSSMTPrivateKeyParameters.Builder(this.a).withPrivateKey(byArray, this.b).build();
        XMSSMTPublicKeyParameters xMSSMTPublicKeyParameters = new XMSSMTPublicKeyParameters.Builder(this.a).withPublicKey(byArray2).build();
        if (!Arrays.areEqual(xMSSMTPrivateKeyParameters.getRoot(), xMSSMTPublicKeyParameters.getRoot())) {
            throw new IllegalStateException("root of private key and public key do not match");
        }
        if (!Arrays.areEqual(xMSSMTPrivateKeyParameters.getPublicSeed(), xMSSMTPublicKeyParameters.getPublicSeed())) {
            throw new IllegalStateException("public seed of private key and public key do not match");
        }
        this.b.getWOTSPlus().a(new byte[this.a.getDigestSize()], xMSSMTPrivateKeyParameters.getPublicSeed());
        this.d = xMSSMTPrivateKeyParameters;
        this.e = xMSSMTPublicKeyParameters;
    }

    public byte[] sign(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        XMSSMTSigner xMSSMTSigner = new XMSSMTSigner();
        xMSSMTSigner.init(true, this.d);
        byte[] byArray2 = xMSSMTSigner.generateSignature(byArray);
        this.d = (XMSSMTPrivateKeyParameters)xMSSMTSigner.getUpdatedPrivateKey();
        this.a(this.d, this.e);
        return byArray2;
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, byte[] byArray3) throws ParseException {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("signature == null");
        }
        if (byArray3 == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSigner xMSSMTSigner = new XMSSMTSigner();
        xMSSMTSigner.init(false, new XMSSMTPublicKeyParameters.Builder(this.getParams()).withPublicKey(byArray3).build());
        return xMSSMTSigner.verifySignature(byArray, byArray2);
    }

    public byte[] exportPrivateKey() {
        return this.d.toByteArray();
    }

    public byte[] exportPublicKey() {
        return this.e.toByteArray();
    }

    public XMSSMTParameters getParams() {
        return this.a;
    }

    public byte[] getPublicSeed() {
        return this.d.getPublicSeed();
    }

    protected XMSSParameters getXMSS() {
        return this.b;
    }
}

