/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.cad.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.cad.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.cad.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.cad.internal.bouncycastle.math.ec.WTauNafMultiplier;
import com.aspose.cad.internal.bouncycastle.math.ec.custom.sec.SecT239FieldElement;
import com.aspose.cad.internal.bouncycastle.math.ec.custom.sec.SecT239K1Point;
import com.aspose.cad.internal.bouncycastle.math.ec.custom.sec.x;
import com.aspose.cad.internal.bouncycastle.math.raw.Nat256;
import com.aspose.cad.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT239K1Curve
extends ECCurve.AbstractF2m {
    private static final int c = 6;
    protected SecT239K1Point infinity = new SecT239K1Point(this, null, null);

    public SecT239K1Curve() {
        super(239, 158, 0, 0);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decode("2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT239K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    @Override
    public int getFieldSize() {
        return 239;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT239FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecT239K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecT239K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 239;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 158;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        long[] lArray = new long[n3 * 4 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat256.copy64(((SecT239FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat256.copy64(((SecT239FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 4);
            n4 += 4;
        }
        return new x(this, n3, lArray);
    }
}

