/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.StreamCipher;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.jcajce.PKCS12Key;
import com.aspose.cad.internal.bouncycastle.jcajce.PKCS12KeyWithParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.PBE;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class BaseStreamCipher
extends BaseWrapCipher
implements PBE {
    private Class[] a = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class};
    private StreamCipher b;
    private int c;
    private int d;
    private ParametersWithIV e;
    private int f = 0;
    private PBEParameterSpec g = null;
    private String h = null;

    protected BaseStreamCipher(StreamCipher streamCipher, int n2) {
        this(streamCipher, n2, -1, -1);
    }

    protected BaseStreamCipher(StreamCipher streamCipher, int n2, int n3, int n4) {
        this.b = streamCipher;
        this.f = n2;
        this.c = n3;
        this.d = n4;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.e != null ? this.e.getIV() : null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n2) {
        return n2;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.g != null) {
            try {
                AlgorithmParameters algorithmParameters = this.createParametersInstance(this.h);
                algorithmParameters.init(this.g);
                return algorithmParameters;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.engineParams;
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("can't support mode " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!string.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding " + string + " unknown.");
        }
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters cipherParameters;
        Serializable serializable;
        this.g = null;
        this.h = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (key instanceof PKCS12Key) {
            serializable = (PKCS12Key)key;
            this.g = (PBEParameterSpec)algorithmParameterSpec;
            if (serializable instanceof PKCS12KeyWithParameters && this.g == null) {
                this.g = new PBEParameterSpec(((PKCS12KeyWithParameters)serializable).getSalt(), ((PKCS12KeyWithParameters)serializable).getIterationCount());
            }
            cipherParameters = PBE.Util.makePBEParameters(((PKCS12Key)serializable).getEncoded(), 2, this.d, this.c, this.f * 8, this.g, this.b.getAlgorithmName());
        } else if (key instanceof BCPBEKey) {
            serializable = (BCPBEKey)key;
            this.h = ((BCPBEKey)serializable).getOID() != null ? ((BCPBEKey)serializable).getOID().getId() : ((BCPBEKey)serializable).getAlgorithm();
            if (((BCPBEKey)serializable).getParam() != null) {
                cipherParameters = ((BCPBEKey)serializable).getParam();
                this.g = new PBEParameterSpec(((BCPBEKey)serializable).getSalt(), ((BCPBEKey)serializable).getIterationCount());
            } else if (algorithmParameterSpec instanceof PBEParameterSpec) {
                cipherParameters = PBE.Util.makePBEParameters((BCPBEKey)serializable, algorithmParameterSpec, this.b.getAlgorithmName());
                this.g = (PBEParameterSpec)algorithmParameterSpec;
            } else {
                throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
            }
            if (((BCPBEKey)serializable).getIvSize() != 0) {
                this.e = (ParametersWithIV)cipherParameters;
            }
        } else if (algorithmParameterSpec == null) {
            if (this.d > 0) {
                throw new InvalidKeyException("Algorithm requires a PBE key");
            }
            cipherParameters = new KeyParameter(key.getEncoded());
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            cipherParameters = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)algorithmParameterSpec).getIV());
            this.e = (ParametersWithIV)cipherParameters;
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.f != 0 && !(cipherParameters instanceof ParametersWithIV)) {
            serializable = secureRandom;
            if (serializable == null) {
                serializable = new SecureRandom();
            }
            if (n2 == 1 || n2 == 3) {
                byte[] byArray = new byte[this.f];
                ((SecureRandom)serializable).nextBytes(byArray);
                cipherParameters = new ParametersWithIV(cipherParameters, byArray);
                this.e = (ParametersWithIV)cipherParameters;
            } else {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        try {
            switch (n2) {
                case 1: 
                case 3: {
                    this.b.init(true, cipherParameters);
                    break;
                }
                case 2: 
                case 4: {
                    this.b.init(false, cipherParameters);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + n2 + " passed");
                }
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    @Override
    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmParameters != null) {
            for (int i2 = 0; i2 != this.a.length; ++i2) {
                try {
                    algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(this.a[i2]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.engineParams = algorithmParameters;
    }

    @Override
    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        this.b.processBytes(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (n4 + n3 > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        try {
            this.b.processBytes(byArray, n2, n3, byArray2, n4);
            return n3;
        }
        catch (DataLengthException dataLengthException) {
            throw new IllegalStateException(dataLengthException.getMessage());
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) {
        if (n3 != 0) {
            byte[] byArray2 = this.engineUpdate(byArray, n2, n3);
            this.b.reset();
            return byArray2;
        }
        this.b.reset();
        return new byte[0];
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        if (n4 + n3 > byArray2.length) {
            throw new ShortBufferException("output buffer too short for input.");
        }
        if (n3 != 0) {
            this.b.processBytes(byArray, n2, n3, byArray2, n4);
        }
        this.b.reset();
        return n3;
    }
}

