/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.prng.drbg;

import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.prng.EntropySource;
import com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.a;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Integers;
import java.util.Hashtable;

public class HashSP800DRBG
implements SP80090DRBG {
    private static final byte[] a = new byte[]{1};
    private static final long b = 0x800000000000L;
    private static final int c = 262144;
    private static final Hashtable d = new Hashtable();
    private Digest e;
    private byte[] f;
    private byte[] g;
    private long h;
    private EntropySource i;
    private int j;
    private int k;

    public HashSP800DRBG(Digest digest, int n2, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        if (n2 > com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.a.a(digest)) {
            throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
        }
        if (entropySource.entropySize() < n2) {
            throw new IllegalArgumentException("Not enough entropy for security strength required");
        }
        this.e = digest;
        this.i = entropySource;
        this.j = n2;
        this.k = (Integer)d.get(digest.getAlgorithmName());
        byte[] byArray3 = this.a();
        byte[] byArray4 = Arrays.concatenate(byArray3, byArray2, byArray);
        byte[] byArray5 = com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.a.a(this.e, byArray4, this.k);
        this.f = byArray5;
        byte[] byArray6 = new byte[this.f.length + 1];
        System.arraycopy(this.f, 0, byArray6, 1, this.f.length);
        this.g = com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.a.a(this.e, byArray6, this.k);
        this.h = 1L;
    }

    @Override
    public int getBlockSize() {
        return this.e.getDigestSize() * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl2) {
        byte[] byArray3;
        byte[] byArray4;
        int n2 = byArray.length * 8;
        if (n2 > 262144) {
            throw new IllegalArgumentException("Number of bits per request limited to 262144");
        }
        if (this.h > 0x800000000000L) {
            return -1;
        }
        if (bl2) {
            this.reseed(byArray2);
            byArray2 = null;
        }
        if (byArray2 != null) {
            byArray4 = new byte[1 + this.f.length + byArray2.length];
            byArray4[0] = 2;
            System.arraycopy(this.f, 0, byArray4, 1, this.f.length);
            System.arraycopy(byArray2, 0, byArray4, 1 + this.f.length, byArray2.length);
            byArray3 = this.a(byArray4);
            this.a(this.f, byArray3);
        }
        byArray4 = this.a(this.f, n2);
        byArray3 = new byte[this.f.length + 1];
        System.arraycopy(this.f, 0, byArray3, 1, this.f.length);
        byArray3[0] = 3;
        byte[] byArray5 = this.a(byArray3);
        this.a(this.f, byArray5);
        this.a(this.f, this.g);
        byte[] byArray6 = new byte[]{(byte)(this.h >> 24), (byte)(this.h >> 16), (byte)(this.h >> 8), (byte)this.h};
        this.a(this.f, byArray6);
        ++this.h;
        System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
        return n2;
    }

    private byte[] a() {
        byte[] byArray = this.i.getEntropy();
        if (byArray.length < (this.j + 7) / 8) {
            throw new IllegalStateException("Insufficient entropy provided by entropy source");
        }
        return byArray;
    }

    private void a(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 1; n3 <= byArray2.length; ++n3) {
            n2 = (byArray[byArray.length - n3] & 0xFF) + (byArray2[byArray2.length - n3] & 0xFF) + n4;
            n4 = n2 > 255 ? 1 : 0;
            byArray[byArray.length - n3] = (byte)n2;
        }
        for (n3 = byArray2.length + 1; n3 <= byArray.length; ++n3) {
            n2 = (byArray[byArray.length - n3] & 0xFF) + n4;
            n4 = n2 > 255 ? 1 : 0;
            byArray[byArray.length - n3] = (byte)n2;
        }
    }

    @Override
    public void reseed(byte[] byArray) {
        byte[] byArray2 = this.a();
        byte[] byArray3 = Arrays.concatenate(a, this.f, byArray2, byArray);
        byte[] byArray4 = com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.a.a(this.e, byArray3, this.k);
        this.f = byArray4;
        byte[] byArray5 = new byte[this.f.length + 1];
        byArray5[0] = 0;
        System.arraycopy(this.f, 0, byArray5, 1, this.f.length);
        this.g = com.aspose.cad.internal.bouncycastle.crypto.prng.drbg.a.a(this.e, byArray5, this.k);
        this.h = 1L;
    }

    private byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[this.e.getDigestSize()];
        this.b(byArray, byArray2);
        return byArray2;
    }

    private void b(byte[] byArray, byte[] byArray2) {
        this.e.update(byArray, 0, byArray.length);
        this.e.doFinal(byArray2, 0);
    }

    private byte[] a(byte[] byArray, int n2) {
        int n3 = this.e.getDigestSize();
        int n4 = n2 / 8 / n3;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byte[] byArray3 = new byte[n2 / 8];
        byte[] byArray4 = new byte[this.e.getDigestSize()];
        for (int i2 = 0; i2 <= n4; ++i2) {
            this.b(byArray2, byArray4);
            int n5 = byArray3.length - i2 * byArray4.length > byArray4.length ? byArray4.length : byArray3.length - i2 * byArray4.length;
            System.arraycopy(byArray4, 0, byArray3, i2 * byArray4.length, n5);
            this.a(byArray2, a);
        }
        return byArray3;
    }

    static {
        d.put("SHA-1", Integers.valueOf(440));
        d.put("SHA-224", Integers.valueOf(440));
        d.put("SHA-256", Integers.valueOf(440));
        d.put("SHA-512/256", Integers.valueOf(440));
        d.put("SHA-512/224", Integers.valueOf(440));
        d.put("SHA-384", Integers.valueOf(888));
        d.put("SHA-512", Integers.valueOf(888));
    }
}

