/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.engines;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;

public class XTEAEngine
implements BlockCipher {
    private static final int a = 32;
    private static final int b = 8;
    private static final int c = -1640531527;
    private int[] d = new int[4];
    private int[] e = new int[32];
    private int[] f = new int[32];
    private boolean g = false;
    private boolean h;

    @Override
    public String getAlgorithmName() {
        return "XTEA";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to TEA init - " + cipherParameters.getClass().getName());
        }
        this.h = bl2;
        this.g = true;
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        this.a(keyParameter.getKey());
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (!this.g) {
            throw new IllegalStateException(this.getAlgorithmName() + " not initialised");
        }
        if (n2 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this.h ? this.a(byArray, n2, byArray2, n3) : this.b(byArray, n2, byArray2, n3);
    }

    @Override
    public void reset() {
    }

    private void a(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Key size must be 128 bits.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            this.d[n3] = this.a(byArray, n2);
            ++n3;
            n2 += 4;
        }
        n2 = 0;
        for (n3 = 0; n3 < 32; ++n3) {
            this.e[n3] = n2 + this.d[n2 & 3];
            this.f[n3] = (n2 -= 1640531527) + this.d[n2 >>> 11 & 3];
        }
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        for (int i2 = 0; i2 < 32; ++i2) {
            n5 += ((n4 += (n5 << 4 ^ n5 >>> 5) + n5 ^ this.e[i2]) << 4 ^ n4 >>> 5) + n4 ^ this.f[i2];
        }
        this.a(n4, byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        return 8;
    }

    private int b(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4 = this.a(byArray, n2);
        int n5 = this.a(byArray, n2 + 4);
        for (int i2 = 31; i2 >= 0; --i2) {
            n4 -= ((n5 -= (n4 << 4 ^ n4 >>> 5) + n4 ^ this.f[i2]) << 4 ^ n5 >>> 5) + n5 ^ this.e[i2];
        }
        this.a(n4, byArray2, n3);
        this.a(n5, byArray2, n3 + 4);
        return 8;
    }

    private int a(byte[] byArray, int n2) {
        return byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    private void a(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3] = (byte)n2;
    }
}

