/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import com.aspose.cad.internal.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.X509CRLHolder;
import com.aspose.cad.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.SignerInfoGenerator;
import com.aspose.cad.internal.bouncycastle.cms.SignerInformation;
import com.aspose.cad.internal.bouncycastle.cms.SignerInformationStore;
import com.aspose.cad.internal.bouncycastle.cms.o;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Store;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CMSSignedGenerator {
    public static final String DATA = CMSObjectIdentifiers.data.getId();
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    public static final String ENCRYPTION_ECGOST3410_2012_256 = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256.getId();
    public static final String ENCRYPTION_ECGOST3410_2012_512 = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512.getId();
    private static final String a = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    private static final String b = X9ObjectIdentifiers.ecdsa_with_SHA224.getId();
    private static final String c = X9ObjectIdentifiers.ecdsa_with_SHA256.getId();
    private static final String d = X9ObjectIdentifiers.ecdsa_with_SHA384.getId();
    private static final String e = X9ObjectIdentifiers.ecdsa_with_SHA512.getId();
    private static final Set f = new HashSet();
    private static final Map g = new HashMap();
    protected List certs = new ArrayList();
    protected List crls = new ArrayList();
    protected List _signers = new ArrayList();
    protected List signerGens = new ArrayList();
    protected Map digests = new HashMap();

    protected CMSSignedGenerator() {
    }

    protected Map getBaseParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("contentType", aSN1ObjectIdentifier);
        hashMap.put("digestAlgID", algorithmIdentifier);
        hashMap.put("digest", Arrays.clone(byArray));
        return hashMap;
    }

    public void addCertificate(X509CertificateHolder x509CertificateHolder) throws CMSException {
        this.certs.add(x509CertificateHolder.toASN1Structure());
    }

    public void addCertificates(Store store) throws CMSException {
        this.certs.addAll(o.a(store));
    }

    public void addCRL(X509CRLHolder x509CRLHolder) {
        this.crls.add(x509CRLHolder.toASN1Structure());
    }

    public void addCRLs(Store store) throws CMSException {
        this.crls.addAll(o.c(store));
    }

    public void addAttributeCertificate(X509AttributeCertificateHolder x509AttributeCertificateHolder) throws CMSException {
        this.certs.add(new DERTaggedObject(false, 2, x509AttributeCertificateHolder.toASN1Structure()));
    }

    public void addAttributeCertificates(Store store) throws CMSException {
        this.certs.addAll(o.b(store));
    }

    public void addOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.crls.add(new DERTaggedObject(false, 1, new OtherRevocationInfoFormat(aSN1ObjectIdentifier, aSN1Encodable)));
    }

    public void addOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier, Store store) {
        this.crls.addAll(o.a(aSN1ObjectIdentifier, store));
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator<SignerInformation> iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._signers.add(iterator.next());
        }
    }

    public void addSignerInfoGenerator(SignerInfoGenerator signerInfoGenerator) {
        this.signerGens.add(signerInfoGenerator);
    }

    public Map getGeneratedDigests() {
        return new HashMap(this.digests);
    }

    static {
        f.add(ENCRYPTION_DSA);
        f.add(ENCRYPTION_ECDSA);
        f.add(a);
        f.add(b);
        f.add(c);
        f.add(d);
        f.add(e);
        g.put(DIGEST_SHA1, a);
        g.put(DIGEST_SHA224, b);
        g.put(DIGEST_SHA256, c);
        g.put(DIGEST_SHA384, d);
        g.put(DIGEST_SHA512, e);
    }
}

