/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.DEROutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASN1OutputStream {
    private OutputStream a;

    public ASN1OutputStream(OutputStream outputStream) {
        this.a = outputStream;
    }

    void writeLength(int n2) throws IOException {
        if (n2 > 127) {
            int n3 = 1;
            int n4 = n2;
            while ((n4 >>>= 8) != 0) {
                ++n3;
            }
            this.write((byte)(n3 | 0x80));
            for (int i2 = (n3 - 1) * 8; i2 >= 0; i2 -= 8) {
                this.write((byte)(n2 >> i2));
            }
        } else {
            this.write((byte)n2);
        }
    }

    void write(int n2) throws IOException {
        this.a.write(n2);
    }

    void write(byte[] byArray) throws IOException {
        this.a.write(byArray);
    }

    void write(byte[] byArray, int n2, int n3) throws IOException {
        this.a.write(byArray, n2, n3);
    }

    void writeEncoded(int n2, byte[] byArray) throws IOException {
        this.write(n2);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    void writeTag(int n2, int n3) throws IOException {
        if (n3 < 31) {
            this.write(n2 | n3);
        } else {
            this.write(n2 | 0x1F);
            if (n3 < 128) {
                this.write(n3);
            } else {
                byte[] byArray = new byte[5];
                int n4 = byArray.length;
                byArray[--n4] = (byte)(n3 & 0x7F);
                do {
                    byArray[--n4] = (byte)((n3 >>= 7) & 0x7F | 0x80);
                } while (n3 > 127);
                this.write(byArray, n4, byArray.length - n4);
            }
        }
    }

    void writeEncoded(int n2, int n3, byte[] byArray) throws IOException {
        this.writeTag(n2, n3);
        this.writeLength(byArray.length);
        this.write(byArray);
    }

    protected void writeNull() throws IOException {
        this.a.write(5);
        this.a.write(0);
    }

    public void writeObject(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable == null) {
            throw new IOException("null object detected");
        }
        aSN1Encodable.toASN1Primitive().encode(this);
    }

    void writeImplicitObject(ASN1Primitive aSN1Primitive) throws IOException {
        if (aSN1Primitive == null) {
            throw new IOException("null object detected");
        }
        aSN1Primitive.encode(new a(this.a));
    }

    public void close() throws IOException {
        this.a.close();
    }

    public void flush() throws IOException {
        this.a.flush();
    }

    ASN1OutputStream getDERSubStream() {
        return new DEROutputStream(this.a);
    }

    ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.a);
    }

    private class a
    extends ASN1OutputStream {
        private boolean b;

        public a(OutputStream outputStream) {
            super(outputStream);
            this.b = true;
        }

        @Override
        public void write(int n2) throws IOException {
            if (this.b) {
                this.b = false;
            } else {
                super.write(n2);
            }
        }
    }
}

