/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import com.aspose.cad.internal.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.cad.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.ECPointEncoder;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.ECPrivateKey;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.aspose.cad.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.aspose.cad.internal.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.aspose.cad.internal.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class BCDSTU4145PrivateKey
implements ECPointEncoder,
ECPrivateKey,
PKCS12BagAttributeCarrier,
java.security.interfaces.ECPrivateKey {
    static final long serialVersionUID = 7245981689601667138L;
    private String a = "DSTU4145";
    private boolean b;
    private transient BigInteger c;
    private transient ECParameterSpec d;
    private transient DERBitString e;
    private transient PKCS12BagAttributeCarrierImpl f = new PKCS12BagAttributeCarrierImpl();

    protected BCDSTU4145PrivateKey() {
    }

    public BCDSTU4145PrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.c = eCPrivateKey.getS();
        this.a = eCPrivateKey.getAlgorithm();
        this.d = eCPrivateKey.getParams();
    }

    public BCDSTU4145PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.c = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCCurve, eCPrivateKeySpec.getParams().getSeed());
            this.d = EC5Util.convertSpec(ellipticCurve, eCPrivateKeySpec.getParams());
        } else {
            this.d = null;
        }
    }

    public BCDSTU4145PrivateKey(java.security.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.c = eCPrivateKeySpec.getS();
        this.d = eCPrivateKeySpec.getParams();
    }

    public BCDSTU4145PrivateKey(BCDSTU4145PrivateKey bCDSTU4145PrivateKey) {
        this.c = bCDSTU4145PrivateKey.c;
        this.d = bCDSTU4145PrivateKey.d;
        this.b = bCDSTU4145PrivateKey.b;
        this.f = bCDSTU4145PrivateKey.f;
        this.e = bCDSTU4145PrivateKey.e;
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCDSTU4145PublicKey bCDSTU4145PublicKey, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.a = string;
        this.c = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.d = eCParameterSpec;
        }
        this.e = this.a(bCDSTU4145PublicKey);
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCDSTU4145PublicKey bCDSTU4145PublicKey, com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.a = string;
        this.c = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
            this.d = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            this.d = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        }
        this.e = this.a(bCDSTU4145PublicKey);
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        this.a = string;
        this.c = eCPrivateKeyParameters.getD();
        this.d = null;
    }

    BCDSTU4145PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.a(privateKeyInfo);
    }

    private void a(PrivateKeyInfo privateKeyInfo) throws IOException {
        Object object;
        ASN1Encodable aSN1Encodable;
        X962Parameters x962Parameters = new X962Parameters((ASN1Primitive)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1Encodable = ASN1ObjectIdentifier.getInstance(x962Parameters.getParameters());
            object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1Encodable);
            if (object == null) {
                ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1Encodable);
                EllipticCurve ellipticCurve = EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed());
                this.d = new ECNamedCurveSpec(((ASN1ObjectIdentifier)aSN1Encodable).getId(), ellipticCurve, EC5Util.convertPoint(eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH());
            } else {
                EllipticCurve ellipticCurve = EC5Util.convertCurve(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getSeed());
                this.d = new ECNamedCurveSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1Encodable), ellipticCurve, EC5Util.convertPoint(((X9ECParameters)object).getG()), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH());
            }
        } else if (x962Parameters.isImplicitlyCA()) {
            this.d = null;
        } else {
            aSN1Encodable = X9ECParameters.getInstance(x962Parameters.getParameters());
            object = EC5Util.convertCurve(((X9ECParameters)aSN1Encodable).getCurve(), ((X9ECParameters)aSN1Encodable).getSeed());
            this.d = new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint(((X9ECParameters)aSN1Encodable).getG()), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH().intValue());
        }
        aSN1Encodable = privateKeyInfo.parsePrivateKey();
        if (aSN1Encodable instanceof ASN1Integer) {
            object = ASN1Integer.getInstance(aSN1Encodable);
            this.c = ((ASN1Integer)object).getValue();
        } else {
            object = com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey.getInstance(aSN1Encodable);
            this.c = ((com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey)object).getKey();
            this.e = ((com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey)object).getPublicKey();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.a;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ASN1Object aSN1Object;
        int n2;
        X962Parameters x962Parameters;
        Object object;
        if (this.d instanceof ECNamedCurveSpec) {
            object = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.d).getName());
            if (object == null) {
                object = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.d).getName());
            }
            x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object);
            n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, this.d.getOrder(), this.getS());
        } else if (this.d == null) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
            n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, null, this.getS());
        } else {
            object = EC5Util.convertCurve(this.d.getCurve());
            aSN1Object = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, this.d.getGenerator(), this.b), this.d.getOrder(), BigInteger.valueOf(this.d.getCofactor()), this.d.getCurve().getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)aSN1Object);
            n2 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, this.d.getOrder(), this.getS());
        }
        aSN1Object = this.e != null ? new com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey(n2, this.getS(), this.e, x962Parameters) : new com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey(n2, this.getS(), (ASN1Encodable)x962Parameters);
        try {
            object = this.a.equals("DSTU4145") ? new PrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, x962Parameters.toASN1Primitive()), ((com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey)aSN1Object).toASN1Primitive()) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters.toASN1Primitive()), ((com.aspose.cad.internal.bouncycastle.asn1.sec.ECPrivateKey)aSN1Object).toASN1Primitive());
            return ((ASN1Object)object).getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.d;
    }

    @Override
    public com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        if (this.d == null) {
            return null;
        }
        return EC5Util.convertSpec(this.d, this.b);
    }

    com.aspose.cad.internal.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.d != null) {
            return EC5Util.convertSpec(this.d, this.b);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.c;
    }

    @Override
    public BigInteger getD() {
        return this.c;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.f.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.f.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.f.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string) {
        this.b = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCDSTU4145PrivateKey)) {
            return false;
        }
        BCDSTU4145PrivateKey bCDSTU4145PrivateKey = (BCDSTU4145PrivateKey)object;
        return this.getD().equals(bCDSTU4145PrivateKey.getD()) && this.engineGetSpec().equals(bCDSTU4145PrivateKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString(this.a, this.c, this.engineGetSpec());
    }

    private DERBitString a(BCDSTU4145PublicKey bCDSTU4145PublicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCDSTU4145PublicKey.getEncoded()));
            return subjectPublicKeyInfo.getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.a(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
        this.f = new PKCS12BagAttributeCarrierImpl();
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

