/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.ocsp;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.CertID;
import com.aspose.cad.internal.bouncycastle.asn1.ocsp.CertStatus;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.X509Extensions;

public class SingleResponse
extends ASN1Object {
    private CertID a;
    private CertStatus b;
    private ASN1GeneralizedTime c;
    private ASN1GeneralizedTime d;
    private Extensions e;

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1GeneralizedTime aSN1GeneralizedTime2, X509Extensions x509Extensions) {
        this(certID, certStatus, aSN1GeneralizedTime, aSN1GeneralizedTime2, Extensions.getInstance(x509Extensions));
    }

    public SingleResponse(CertID certID, CertStatus certStatus, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1GeneralizedTime aSN1GeneralizedTime2, Extensions extensions) {
        this.a = certID;
        this.b = certStatus;
        this.c = aSN1GeneralizedTime;
        this.d = aSN1GeneralizedTime2;
        this.e = extensions;
    }

    private SingleResponse(ASN1Sequence aSN1Sequence) {
        this.a = CertID.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = CertStatus.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(2));
        if (aSN1Sequence.size() > 4) {
            this.d = ASN1GeneralizedTime.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(3), true);
            this.e = Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(4), true);
        } else if (aSN1Sequence.size() > 3) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(3);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.d = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
            } else {
                this.e = Extensions.getInstance(aSN1TaggedObject, true);
            }
        }
    }

    public static SingleResponse getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return SingleResponse.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static SingleResponse getInstance(Object object) {
        if (object instanceof SingleResponse) {
            return (SingleResponse)object;
        }
        if (object != null) {
            return new SingleResponse(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertID getCertID() {
        return this.a;
    }

    public CertStatus getCertStatus() {
        return this.b;
    }

    public ASN1GeneralizedTime getThisUpdate() {
        return this.c;
    }

    public ASN1GeneralizedTime getNextUpdate() {
        return this.d;
    }

    public Extensions getSingleExtensions() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.e));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

