/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.crmf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.crmf.PKMACValue;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class POPOSigningKeyInput
extends ASN1Object {
    private GeneralName a;
    private PKMACValue b;
    private SubjectPublicKeyInfo c;

    private POPOSigningKeyInput(ASN1Sequence aSN1Sequence) {
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(0);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable;
            if (aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("Unknown authInfo tag: " + aSN1TaggedObject.getTagNo());
            }
            this.a = GeneralName.getInstance(aSN1TaggedObject.getObject());
        } else {
            this.b = PKMACValue.getInstance(aSN1Encodable);
        }
        this.c = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static POPOSigningKeyInput getInstance(Object object) {
        if (object instanceof POPOSigningKeyInput) {
            return (POPOSigningKeyInput)object;
        }
        if (object != null) {
            return new POPOSigningKeyInput(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public POPOSigningKeyInput(GeneralName generalName, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.a = generalName;
        this.c = subjectPublicKeyInfo;
    }

    public POPOSigningKeyInput(PKMACValue pKMACValue, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.b = pKMACValue;
        this.c = subjectPublicKeyInfo;
    }

    public GeneralName getSender() {
        return this.a;
    }

    public PKMACValue getPublicKeyMAC() {
        return this.b;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        } else {
            aSN1EncodableVector.add(this.b);
        }
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

