/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.BERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class DigestedData
extends ASN1Object {
    private ASN1Integer a;
    private AlgorithmIdentifier b;
    private ContentInfo c;
    private ASN1OctetString d;

    public DigestedData(AlgorithmIdentifier algorithmIdentifier, ContentInfo contentInfo, byte[] byArray) {
        this.a = new ASN1Integer(0L);
        this.b = algorithmIdentifier;
        this.c = contentInfo;
        this.d = new DEROctetString(byArray);
    }

    private DigestedData(ASN1Sequence aSN1Sequence) {
        this.a = (ASN1Integer)aSN1Sequence.getObjectAt(0);
        this.b = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = ContentInfo.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(3));
    }

    public static DigestedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DigestedData.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static DigestedData getInstance(Object object) {
        if (object instanceof DigestedData) {
            return (DigestedData)object;
        }
        if (object != null) {
            return new DigestedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.b;
    }

    public ContentInfo getEncapContentInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new BERSequence(aSN1EncodableVector);
    }

    public byte[] getDigest() {
        return this.d.getOctets();
    }
}

