/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.OfficeZip;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedBinaryObject
extends EmbeddedObject {
    private byte[] objData = null;

    public EmbeddedBinaryObject(String name, String type) {
        super(name, type);
    }

    EmbeddedBinaryObject(String name, String type, OfficeZip source) {
        super(name, type, source);
    }

    public byte[] getBinaryData() {
        if (this.objData == null && this.zipFile != null) {
            this.objData = this.zipFile.getNamedBytes(this.objName);
        }
        return this.objData;
    }

    public void setBinaryData(byte[] data) {
        this.objData = data;
        this.hasChanged = true;
    }

    @Override
    void write(OfficeZip zip) {
        if (this.hasChanged) {
            zip.setNamedBytes(this.objName, this.objData);
        }
    }

    @Override
    void writeManifestData(Document manifestDoc) throws DOMException {
        Element objNode = manifestDoc.createElement("manifest:file-entry");
        objNode.setAttribute("manifest:media-type", this.objType);
        objNode.setAttribute("manifest:full-path", this.objName);
        manifestDoc.getDocumentElement().appendChild(objNode);
    }
}

