/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif;

import be.teletask.onvif.DiscoveryMode;
import be.teletask.onvif.listeners.DiscoveryListener;
import be.teletask.onvif.models.Device;
import be.teletask.onvif.parsers.DiscoveryParser;
import be.teletask.onvif.responses.OnvifResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.List;

public class DiscoveryThread
extends Thread {
    public static final String TAG = DiscoveryThread.class.getSimpleName();
    private DatagramSocket server;
    private int timeout;
    private DiscoveryParser parser;
    private DiscoveryListener callback;

    DiscoveryThread(DatagramSocket server, int timeout, DiscoveryMode mode, DiscoveryListener callback) {
        this.server = server;
        this.timeout = timeout;
        this.callback = callback;
        this.parser = new DiscoveryParser(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean started = false;
            DatagramPacket packet = new DatagramPacket(new byte[4096], 4096);
            this.server.setSoTimeout(this.timeout);
            long timerStarted = System.currentTimeMillis();
            while (System.currentTimeMillis() - timerStarted < (long)this.timeout) {
                if (!started) {
                    this.callback.onDiscoveryStarted();
                    started = true;
                }
                this.server.receive(packet);
                String response = new String(packet.getData(), 0, packet.getLength());
                this.parser.setHostName(packet.getAddress().getHostName());
                this.callback.onDevicesFound((List<Device>)this.parser.parse(new OnvifResponse(response)));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.server.close();
            this.callback.onDiscoveryFinished();
        }
    }
}

