/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import org.jfree.report.expressions.FormulaExpression;
import org.libreoffice.report.pentaho.model.FormatCondition;
import org.libreoffice.report.pentaho.model.ReportElement;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormatConditionReadHandler
extends AbstractXmlReadHandler {
    private final ReportElement element;

    public FormatConditionReadHandler(ReportElement element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.element = element;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String formula = attrs.getValue("http://openoffice.org/2005/report", "formula");
        if (formula == null) {
            throw new ParseException("Required attribute 'formula' is missing.", this.getLocator());
        }
        String stylename = attrs.getValue("http://openoffice.org/2005/report", "style-name");
        if (stylename == null) {
            throw new ParseException("Required attribute 'style-name' is missing.", this.getLocator());
        }
        FormulaExpression valueExpression = new FormulaExpression();
        valueExpression.setFormula(formula);
        String enabledText = attrs.getValue("http://openoffice.org/2005/report", "enabled");
        boolean enabled = enabledText == null || "true".equals(enabledText);
        FormatCondition formatCondition = new FormatCondition(valueExpression, stylename, enabled);
        this.element.addFormatCondition(formatCondition);
    }

    public Object getObject() throws SAXException {
        return this.element;
    }
}

