/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.comp.Calc.NLPSolver.BaseNLPSolver;
import com.sun.star.comp.Calc.NLPSolver.PropertyInfo;
import com.sun.star.comp.Calc.NLPSolver.dialogs.DummyEvolutionarySolverStatusDialog;
import com.sun.star.comp.Calc.NLPSolver.dialogs.EvolutionarySolverStatusUno;
import com.sun.star.comp.Calc.NLPSolver.dialogs.IEvolutionarySolverStatusDialog;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import net.adaptivebox.goodness.ACRComparator;
import net.adaptivebox.goodness.BCHComparator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;

public abstract class BaseEvolutionarySolver
extends BaseNLPSolver {
    protected CalcProblemEncoder m_problemEncoder;
    protected Library m_library;
    protected IGoodnessCompareEngine m_envCompareEngine;
    protected IGoodnessCompareEngine m_specCompareEngine;
    protected SearchPoint m_totalBestPoint;
    protected int m_toleratedCount;
    protected double m_toleratedMin;
    protected double m_toleratedMax;
    private final ArrayList<Variable> m_variables = new ArrayList();
    protected PropertyInfo<Integer> m_swarmSize = new PropertyInfo<Integer>("SwarmSize", 70, "Size of Swarm");
    protected PropertyInfo<Integer> m_librarySize = new PropertyInfo<Integer>("LibrarySize", 210, "Size of Library");
    protected PropertyInfo<Integer> m_learningCycles = new PropertyInfo<Integer>("LearningCycles", 2000, "Learning Cycles");
    private final PropertyInfo<Boolean> m_guessVariableRange = new PropertyInfo<Boolean>("GuessVariableRange", true, "Variable Bounds Guessing");
    private final PropertyInfo<Double> m_variableRangeThreshold = new PropertyInfo<Double>("VariableRangeThreshold", 3.0, "Variable Bounds Threshold (when guessing)");
    private final PropertyInfo<Boolean> m_useACRComperator = new PropertyInfo<Boolean>("UseACRComparator", false, "Use ACR Comparator (instead of BCH)");
    private final PropertyInfo<Boolean> m_useRandomStartingPoint = new PropertyInfo<Boolean>("UseRandomStartingPoint", false, "Use Random starting point");
    protected PropertyInfo<Integer> m_required = new PropertyInfo<Integer>("StagnationLimit", 70, "Stagnation Limit");
    protected PropertyInfo<Double> m_tolerance = new PropertyInfo<Double>("Tolerance", 1.0E-6, "Stagnation Tolerance");
    private final PropertyInfo<Boolean> m_enhancedSolverStatus = new PropertyInfo<Boolean>("EnhancedSolverStatus", true, "Show enhanced solver status");
    protected IEvolutionarySolverStatusDialog m_solverStatusDialog;

    public BaseEvolutionarySolver(XComponentContext xContext, String name) {
        super(xContext, name);
        this.registerProperty(this.m_swarmSize);
        this.registerProperty(this.m_learningCycles);
        this.registerProperty(this.m_guessVariableRange);
        this.registerProperty(this.m_variableRangeThreshold);
        this.registerProperty(this.m_useACRComperator);
        this.registerProperty(this.m_useRandomStartingPoint);
        this.registerProperty(this.m_required);
        this.registerProperty(this.m_tolerance);
        this.registerProperty(this.m_enhancedSolverStatus);
    }

    private void prepareVariables(double[][] variableBounds) {
        this.m_variables.clear();
        for (int i = 0; i < this.m_variableCount; ++i) {
            Variable var = new Variable(this.m_variableMap[i], i);
            var.MinValue = variableBounds[i][0];
            var.MaxValue = variableBounds[i][1];
            var.Granularity = variableBounds[i][2];
            this.m_variables.add(var);
        }
    }

    @Override
    protected void initializeSolve() {
        super.initializeSolve();
        if (this.m_variableCount == 0) {
            return;
        }
        this.m_solverStatusDialog = this.m_enhancedSolverStatus.getValue() != false ? new EvolutionarySolverStatusUno(this.m_xContext) : new DummyEvolutionarySolverStatusDialog();
        double[][] variableBounds = new double[this.m_variableCount][3];
        for (int i = 0; i < this.m_variableCount; ++i) {
            if (this.m_guessVariableRange.getValue().booleanValue()) {
                double b2;
                double b1;
                double value = this.m_variableCells[i].getValue();
                if (value == 0.0) {
                    value = 1000.0;
                }
                if (((Boolean)this.m_assumeNonNegative.getValue()).booleanValue()) {
                    b1 = 0.0;
                    b2 = value + value * 2.0 * this.m_variableRangeThreshold.getValue();
                } else {
                    b1 = value + value * this.m_variableRangeThreshold.getValue();
                    b2 = value - value * this.m_variableRangeThreshold.getValue();
                }
                variableBounds[i][0] = Math.min(b1, b2);
                variableBounds[i][1] = Math.max(b1, b2);
            } else {
                variableBounds[i][0] = (Boolean)this.m_assumeNonNegative.getValue() != false ? 0.0 : -1.0E308;
                variableBounds[i][1] = 1.0E308;
            }
            variableBounds[i][2] = 0.0;
        }
        ArrayList<BaseNLPSolver.ExtSolverConstraint> constraints = new ArrayList<BaseNLPSolver.ExtSolverConstraint>();
        for (int i = 0; i < this.m_constraintCount; ++i) {
            Double doubleValue = this.m_extConstraints[i].Right != null ? null : Double.valueOf(this.m_extConstraints[i].Data);
            boolean isVariableBound = false;
            if (this.m_extConstraints[i].Right == null) {
                block11: for (int j = 0; j < this.m_variableCount && !isVariableBound; ++j) {
                    if (this.m_constraints[i].Left.Sheet != ((BaseNLPSolver)this).m_variables[j].Sheet || this.m_constraints[i].Left.Column != ((BaseNLPSolver)this).m_variables[j].Column || this.m_constraints[i].Left.Row != ((BaseNLPSolver)this).m_variables[j].Row) continue;
                    isVariableBound = true;
                    switch (this.m_extConstraints[i].Operator.getValue()) {
                        case 1: {
                            if (doubleValue == null) continue block11;
                            variableBounds[j][0] = doubleValue;
                            variableBounds[j][1] = doubleValue;
                            continue block11;
                        }
                        case 2: {
                            if (doubleValue == null) continue block11;
                            variableBounds[j][0] = doubleValue;
                            continue block11;
                        }
                        case 0: {
                            if (doubleValue == null) continue block11;
                            variableBounds[j][1] = doubleValue;
                            continue block11;
                        }
                        case 3: {
                            variableBounds[j][2] = 1.0;
                            continue block11;
                        }
                        case 4: {
                            variableBounds[j][0] = 0.0;
                            variableBounds[j][1] = 1.0;
                            variableBounds[j][2] = 1.0;
                            continue block11;
                        }
                        default: {
                            isVariableBound = false;
                        }
                    }
                }
            }
            if (isVariableBound) continue;
            constraints.add(this.m_extConstraints[i]);
        }
        this.prepareVariables(variableBounds);
        try {
            this.m_problemEncoder = new CalcProblemEncoder(this.m_variables, constraints);
        }
        catch (Exception e) {
            this.m_problemEncoder = null;
            return;
        }
        this.m_library = new Library(this.m_librarySize.getValue().intValue(), (ProblemEncoder)this.m_problemEncoder);
        if (this.m_useRandomStartingPoint.getValue().booleanValue()) {
            this.m_totalBestPoint = this.m_problemEncoder.getEncodedSearchPoint();
        } else {
            this.m_totalBestPoint = this.m_problemEncoder.getFreshSearchPoint();
            double[] currentValues = new double[this.m_variables.size()];
            for (int i = 0; i < this.m_variables.size(); ++i) {
                currentValues[i] = this.m_currentParameters[this.m_variables.get(i).OriginalVariable];
            }
            this.m_totalBestPoint.importLocation(currentValues);
            this.m_problemEncoder.evaluate(this.m_totalBestPoint);
        }
        this.m_library.getSelectedPoint(0).importPoint(this.m_totalBestPoint);
        this.m_solverStatusDialog.setBestSolution(this.m_totalBestPoint.getObjectiveValue(), this.checkConstraints());
        this.m_envCompareEngine = new BCHComparator();
        this.m_specCompareEngine = this.m_useACRComperator.getValue() != false ? new ACRComparator(this.m_library, this.m_learningCycles.getValue().intValue()) : new BCHComparator();
    }

    protected void applySolution() {
        double[] location = this.m_totalBestPoint.getLocation();
        this.m_problemEncoder.getDesignSpace().getMappingPoint(location);
        for (int i = 0; i < this.m_variableCount; ++i) {
            this.m_variableCells[i].setValue(location[i]);
            this.m_currentParameters[i] = location[i];
        }
        this.m_functionValue = this.m_objectiveCell.getValue();
    }

    @Override
    protected void finalizeSolve() {
        this.applySolution();
        this.m_success = this.m_objectiveCell.getError() == 0 && this.checkConstraints();
        this.m_solverStatusDialog.setVisible(false);
        this.m_solverStatusDialog.dispose();
        super.finalizeSolve();
    }

    private boolean checkConstraints() {
        boolean result = true;
        for (int i = 0; i < this.m_constraintCount && result; ++i) {
            if (this.m_extConstraints[i].Left.getError() == 0) {
                double value = this.m_extConstraints[i].getLeftValue();
                double targetValue = this.m_extConstraints[i].Data;
                switch (this.m_extConstraints[i].Operator.getValue()) {
                    case 1: {
                        result = value == targetValue;
                        break;
                    }
                    case 2: {
                        result = value >= targetValue;
                        break;
                    }
                    case 0: {
                        result = value <= targetValue;
                        break;
                    }
                    case 3: {
                        result = Math.rint(value) == value;
                        break;
                    }
                    case 4: {
                        result = value == 0.0 || value == 1.0;
                    }
                }
                continue;
            }
            result = false;
        }
        return result;
    }

    private class CalcProblemEncoder
    extends ProblemEncoder {
        private final ArrayList<Variable> m_variables;
        private final ArrayList<BaseNLPSolver.ExtSolverConstraint> m_constraints;

        private CalcProblemEncoder(ArrayList<Variable> variables, ArrayList<BaseNLPSolver.ExtSolverConstraint> constraints) throws Exception {
            int i;
            super(variables.size(), 1 + constraints.size());
            this.m_variables = variables;
            this.m_constraints = constraints;
            double objective = BaseEvolutionarySolver.this.m_maximize ? 1.0E308 : -1.0E308;
            this.setDefaultYAt(0, objective, objective);
            block7: for (i = 0; i < constraints.size(); ++i) {
                BaseNLPSolver.ExtSolverConstraint constraint = constraints.get(i);
                switch (constraint.Operator.getValue()) {
                    case 1: {
                        this.setDefaultYAt(i + 1, constraint.Data, constraint.Data);
                        continue block7;
                    }
                    case 2: {
                        this.setDefaultYAt(i + 1, constraint.Data, 1.0E308);
                        continue block7;
                    }
                    case 0: {
                        this.setDefaultYAt(i + 1, -1.0E308, constraint.Data);
                        continue block7;
                    }
                    case 3: {
                        this.setDefaultYAt(i + 1, -1.0E308, 1.0E308);
                        continue block7;
                    }
                    case 4: {
                        this.setDefaultYAt(i + 1, 0.0, 1.0);
                    }
                }
            }
            for (i = 0; i < this.m_variables.size(); ++i) {
                Variable variable = this.m_variables.get(i);
                this.setDefaultXAt(i, variable.MinValue, variable.MaxValue, variable.Granularity);
            }
        }

        protected double calcTargetAt(int index, double[] VX) {
            if (index == 0) {
                int i;
                for (i = 0; i < this.m_variables.size(); ++i) {
                    BaseNLPSolver.CellMap variableMap = this.m_variables.get(i).CellMap;
                    BaseEvolutionarySolver.this.m_variableData[variableMap.Range][variableMap.Row][variableMap.Col] = VX[i];
                }
                for (i = 0; i < BaseEvolutionarySolver.this.m_cellRangeCount; ++i) {
                    BaseEvolutionarySolver.this.m_cellRangeData[i].setData(BaseEvolutionarySolver.this.m_variableData[i]);
                }
                if (BaseEvolutionarySolver.this.m_objectiveCell.getError() != 0) {
                    return BaseEvolutionarySolver.this.m_maximize ? -1.0E308 : 1.0E308;
                }
                double result = BaseEvolutionarySolver.this.m_objectiveCell.getValue();
                if (result >= BaseEvolutionarySolver.this.m_toleratedMin && result <= BaseEvolutionarySolver.this.m_toleratedMax && BaseEvolutionarySolver.this.checkConstraints()) {
                    ++BaseEvolutionarySolver.this.m_toleratedCount;
                }
                return result;
            }
            return this.m_constraints.get(index - 1).getLeftValue();
        }
    }

    private static class Variable {
        private final BaseNLPSolver.CellMap CellMap;
        private final int OriginalVariable;
        private double MinValue;
        private double MaxValue;
        private double Granularity;

        private Variable(BaseNLPSolver.CellMap cellMap, int originalVariable) {
            this.CellMap = cellMap;
            this.OriginalVariable = originalVariable;
            this.MinValue = -1.0E308;
            this.MaxValue = 1.0E308;
            this.Granularity = 0.0;
        }
    }
}

