/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class SurveyScaleLegendItem {
    private Shape shape;
    private String label;
    private boolean draw;
    private boolean fill;
    private Font font;

    public SurveyScaleLegendItem() {
        this.font = new Font("Serif", 2, 10);
    }

    public SurveyScaleLegendItem(Shape shape, String string, boolean bl, boolean bl2) {
        this.shape = shape;
        this.label = string;
        this.draw = bl;
        this.fill = bl2;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.shape == null || this.font == null || this.label == null) {
            return;
        }
        if (!this.draw && !this.fill) {
            return;
        }
        Rectangle2D rectangle2D2 = this.shape.getBounds2D();
        double d = rectangle2D.getMinX() + rectangle2D2.getWidth() / 2.0 + 1.0;
        double d2 = rectangle2D.getCenterY();
        Shape shape = this.getShape();
        graphics2D.translate(d, d2);
        graphics2D.setPaint(Color.black);
        if (this.draw) {
            graphics2D.setStroke(new BasicStroke(0.5f));
            graphics2D.draw(shape);
        }
        if (this.fill) {
            graphics2D.fill(shape);
        }
        graphics2D.translate(-d, -d2);
        d += rectangle2D2.getWidth() / 2.0 + 3.0;
        graphics2D.setFont(this.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        LineMetrics lineMetrics = font.getLineMetrics(this.label, fontRenderContext);
        float f = lineMetrics.getAscent();
        float f2 = f / 2.0f;
        graphics2D.drawString(this.label, (float)d, (float)(d2 + (double)f2));
    }

    public boolean isDraw() {
        return this.draw;
    }

    public void setDraw(boolean bl) {
        this.draw = bl;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }
}

