/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.AbstractLValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;

public class FormulaFunction
extends AbstractLValue {
    private static final Log logger = LogFactory.getLog(FormulaFunction.class);
    private String functionName;
    private LValue[] parameters;
    private Function function;
    private FunctionDescription metaData;
    private static final long serialVersionUID = 8023588016882997962L;

    public FormulaFunction(String functionName, LValue[] parameters, ParsePosition parsePosition) {
        this.functionName = functionName;
        this.setParsePosition(parsePosition);
        this.parameters = (LValue[])parameters.clone();
    }

    public FormulaFunction(String functionName, LValue[] parameters) {
        this(functionName, parameters, null);
    }

    @Override
    public void initialize(FormulaContext context) throws EvaluationException {
        super.initialize(context);
        FunctionRegistry registry = context.getFunctionRegistry();
        if (this.function == null) {
            this.function = registry.createFunction(this.functionName);
        }
        if (this.metaData == null) {
            this.metaData = registry.getMetaData(this.functionName);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].initialize(context);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Function getFunction() {
        return this.function;
    }

    public FunctionDescription getMetaData() {
        return this.metaData;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FormulaFunction fn = (FormulaFunction)super.clone();
        fn.parameters = (LValue[])this.parameters.clone();
        for (int i = 0; i < this.parameters.length; ++i) {
            LValue parameter = this.parameters[i];
            fn.parameters[i] = (LValue)parameter.clone();
        }
        return fn;
    }

    @Override
    public TypeValuePair evaluate() throws EvaluationException {
        FormulaContext context = this.getContext();
        if (this.function == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_FUNCTION_VALUE);
        }
        try {
            return this.function.evaluate(context, new FormulaParameterCallback(this));
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected exception while evaluating", (Throwable)e);
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    @Override
    public LValue[] getChildValues() {
        return (LValue[])this.parameters.clone();
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append(this.functionName);
        b.append('(');
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                b.append(';');
            }
            LValue parameter = this.parameters[i];
            b.append(parameter);
        }
        b.append(')');
        return b.toString();
    }

    @Override
    public boolean isConstant() {
        if (this.metaData.isVolatile()) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            LValue value = this.parameters[i];
            if (value.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static class FormulaParameterCallback
    implements ParameterCallback {
        private TypeValuePair[] backend;
        private FormulaFunction function;

        private FormulaParameterCallback(FormulaFunction function) {
            this.function = function;
            this.backend = new TypeValuePair[function.parameters.length];
        }

        private TypeValuePair get(int pos) throws EvaluationException {
            LValue parameter = this.function.parameters[pos];
            Type paramType = this.function.metaData.getParameterType(pos);
            if (parameter != null) {
                TypeValuePair result = parameter.evaluate();
                if (result.getValue() == null) {
                    return result;
                }
                TypeRegistry typeRegistry = this.function.getContext().getTypeRegistry();
                TypeValuePair converted = typeRegistry.convertTo(paramType, result);
                if (converted == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to evaluate parameter " + pos + " on function " + this.function));
                    }
                    throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_AUTO_ARGUMENT_VALUE);
                }
                return converted;
            }
            return new TypeValuePair(paramType, this.function.metaData.getDefaultValue(pos));
        }

        @Override
        public LValue getRaw(int position) {
            return this.function.parameters[position];
        }

        @Override
        public Object getValue(int position) throws EvaluationException {
            TypeValuePair pair;
            TypeValuePair retval = this.backend[position];
            if (retval != null) {
                return retval.getValue();
            }
            this.backend[position] = pair = this.get(position);
            return pair.getValue();
        }

        @Override
        public Type getType(int position) throws EvaluationException {
            TypeValuePair pair;
            TypeValuePair retval = this.backend[position];
            if (retval != null) {
                return retval.getType();
            }
            this.backend[position] = pair = this.get(position);
            return pair.getType();
        }

        @Override
        public int getParameterCount() {
            return this.backend.length;
        }
    }
}

