/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.JIFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;

public final class JavaAdapter {
    private static final String IFGLUE_BASE = IFGlue.class.getName();

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        JIFunction x = new JIFunction("JavaAdapter", 1){

            @Override
            public Scriptable createObject(Context cx, Scriptable scope) {
                return null;
            }

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return JavaAdapter.js_createAdpter(cx, scope, args);
            }
        };
        x.defineAsProperty(scope);
    }

    public static Object convertResult(Object result, Class c) {
        if (result == Undefined.instance && c != ScriptRuntime.ObjectClass && c != ScriptRuntime.StringClass) {
            return null;
        }
        return NativeJavaObject.coerceType(c, result, true);
    }

    public static Scriptable createAdapterWrapper(Scriptable obj, Object adapter) {
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        NativeJavaObject res = new NativeJavaObject(scope, adapter, null);
        res.setPrototype(obj);
        return res;
    }

    public static Object getAdapterSelf(Class adapterClass, Object adapter) throws NoSuchFieldException, IllegalAccessException {
        Field self = adapterClass.getDeclaredField("self");
        return self.get(adapter);
    }

    static Object js_createAdpter(Context cx, Scriptable scope, Object[] args) {
        int N = args.length;
        if (N == 0) {
            throw ScriptRuntime.typeError0("msg.adapter.zero.args");
        }
        Class superClass = null;
        Class[] intfs = new Class[N - 1];
        int interfaceCount = 0;
        for (int i = 0; i != N - 1; ++i) {
            Object arg = args[i];
            if (!(arg instanceof NativeJavaClass)) {
                throw ScriptRuntime.typeError2("msg.not.java.class.arg", String.valueOf(i), ScriptRuntime.toString(arg));
            }
            Class c = ((NativeJavaClass)arg).getClassObject();
            if (!c.isInterface()) {
                if (superClass != null) {
                    throw ScriptRuntime.typeError2("msg.only.one.super", superClass.getName(), c.getName());
                }
                superClass = c;
                continue;
            }
            intfs[interfaceCount++] = c;
        }
        if (superClass == null) {
            superClass = ScriptRuntime.ObjectClass;
        }
        Class[] interfaces = new Class[interfaceCount];
        System.arraycopy(intfs, 0, interfaces, 0, interfaceCount);
        Scriptable obj = ScriptRuntime.toObject(cx, scope, args[N - 1]);
        Class adapterClass = JavaAdapter.getAdapterClass(scope, superClass, interfaces, obj);
        Class[] ctorParms = new Class[]{ScriptRuntime.ScriptableClass};
        Object[] ctorArgs = new Object[]{obj};
        try {
            Object adapter = adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
            return JavaAdapter.getAdapterSelf(adapterClass, adapter);
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    public static void writeAdapterObject(Object javaObject, ObjectOutputStream out) throws IOException {
        Class<?> cl = javaObject.getClass();
        out.writeObject(cl.getSuperclass().getName());
        Class<?>[] interfaces = cl.getInterfaces();
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = interfaces[i].getName();
        }
        out.writeObject(interfaceNames);
        try {
            Object delegee = cl.getField("delegee").get(javaObject);
            out.writeObject(delegee);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        throw new IOException();
    }

    public static Object readAdapterObject(Scriptable self, ObjectInputStream in) throws IOException, ClassNotFoundException {
        Class<?> superClass = Class.forName((String)in.readObject());
        String[] interfaceNames = (String[])in.readObject();
        Class[] interfaces = new Class[interfaceNames.length];
        for (int i = 0; i < interfaceNames.length; ++i) {
            interfaces[i] = Class.forName(interfaceNames[i]);
        }
        Scriptable delegee = (Scriptable)in.readObject();
        Class adapterClass = JavaAdapter.getAdapterClass(self, superClass, interfaces, delegee);
        Class[] ctorParms = new Class[]{ScriptRuntime.ScriptableClass, ScriptRuntime.ScriptableClass};
        Object[] ctorArgs = new Object[]{delegee, self};
        try {
            return adapterClass.getConstructor(ctorParms).newInstance(ctorArgs);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ClassNotFoundException("adapter");
    }

    private static ObjToIntMap getObjectFunctionNames(Scriptable obj) {
        Object[] ids = ScriptableObject.getPropertyIds(obj);
        ObjToIntMap map = new ObjToIntMap(ids.length);
        for (int i = 0; i != ids.length; ++i) {
            String id;
            Object value;
            if (!(ids[i] instanceof String) || !((value = ScriptableObject.getProperty(obj, id = (String)ids[i])) instanceof Function)) continue;
            Function f = (Function)value;
            int length = ScriptRuntime.toInt32(ScriptableObject.getProperty((Scriptable)f, "length"));
            if (length < 0) {
                length = 0;
            }
            map.put(id, length);
        }
        return map;
    }

    private static Class getAdapterClass(Scriptable scope, Class superClass, Class[] interfaces, Scriptable obj) {
        ClassCache cache = ClassCache.get(scope);
        Hashtable generated = cache.javaAdapterGeneratedClasses;
        ObjToIntMap names = JavaAdapter.getObjectFunctionNames(obj);
        JavaAdapterSignature sig = new JavaAdapterSignature(superClass, interfaces, names);
        Class adapterClass = (Class)generated.get(sig);
        if (adapterClass == null) {
            String adapterName = "adapter" + cache.newClassSerialNumber();
            byte[] code = JavaAdapter.createAdapterCode(names, adapterName, superClass, interfaces, null);
            adapterClass = JavaAdapter.loadAdapterClass(adapterName, code);
            if (cache.isCachingEnabled()) {
                generated.put(sig, adapterClass);
            }
        }
        return adapterClass;
    }

    public static byte[] createAdapterCode(ObjToIntMap functionNames, String adapterName, Class superClass, Class[] interfaces, String scriptClassName) {
        String methodKey;
        String methodSignature;
        Class[] argTypes;
        String methodName;
        ClassFileWriter cfw = new ClassFileWriter(adapterName, superClass.getName(), "<adapter>");
        cfw.addField("delegee", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        cfw.addField("self", "Lorg/mozilla/javascript/Scriptable;", (short)17);
        int interfacesCount = interfaces == null ? 0 : interfaces.length;
        for (int i = 0; i < interfacesCount; ++i) {
            if (interfaces[i] == null) continue;
            cfw.addInterface(interfaces[i].getName());
        }
        String superName = superClass.getName().replace('.', '/');
        JavaAdapter.generateCtor(cfw, adapterName, superName);
        JavaAdapter.generateSerialCtor(cfw, adapterName, superName);
        if (scriptClassName != null) {
            JavaAdapter.generateEmptyCtor(cfw, adapterName, superName, scriptClassName);
        }
        ObjToIntMap generatedOverrides = new ObjToIntMap();
        ObjToIntMap generatedMethods = new ObjToIntMap();
        for (int i = 0; i < interfacesCount; ++i) {
            Method[] methods = interfaces[i].getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                int mods = method.getModifiers();
                if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
                methodName = method.getName();
                argTypes = method.getParameterTypes();
                if (!functionNames.has(methodName)) {
                    try {
                        superClass.getMethod(methodName, argTypes);
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                methodSignature = JavaAdapter.getMethodSignature(method, argTypes);
                methodKey = methodName + methodSignature;
                if (generatedOverrides.has(methodKey)) continue;
                JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method.getReturnType());
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
        }
        Method[] methods = superClass.getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            int mods = method.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            boolean isAbstractMethod = Modifier.isAbstract(mods);
            methodName = method.getName();
            if (!isAbstractMethod && !functionNames.has(methodName)) continue;
            argTypes = method.getParameterTypes();
            methodSignature = JavaAdapter.getMethodSignature(method, argTypes);
            methodKey = methodName + methodSignature;
            if (!generatedOverrides.has(methodKey)) {
                JavaAdapter.generateMethod(cfw, adapterName, methodName, argTypes, method.getReturnType());
                generatedOverrides.put(methodKey, 0);
                generatedMethods.put(methodName, 0);
            }
            if (isAbstractMethod) continue;
            JavaAdapter.generateSuper(cfw, adapterName, superName, methodName, methodSignature, argTypes, method.getReturnType());
        }
        ObjToIntMap.Iterator iter = new ObjToIntMap.Iterator(functionNames);
        iter.start();
        while (!iter.done()) {
            String functionName = (String)iter.getKey();
            if (!generatedMethods.has(functionName)) {
                int length = iter.getValue();
                Class[] parms = new Class[length];
                for (int k = 0; k < length; ++k) {
                    parms[k] = ScriptRuntime.ObjectClass;
                }
                JavaAdapter.generateMethod(cfw, adapterName, functionName, parms, ScriptRuntime.ObjectClass);
            }
            iter.next();
        }
        return cfw.toByteArray();
    }

    public static IFGlue makeIFGlue(Class cl, Function f) {
        ClassCache cache = ClassCache.get(f);
        Hashtable masters = cache.javaAdapterIFGlueMasters;
        IFGlue master = (IFGlue)masters.get(cl);
        if (master == null) {
            if (!cl.isInterface()) {
                return null;
            }
            Method[] methods = cl.getMethods();
            if (methods.length == 0) {
                return null;
            }
            Class[] argTypes = methods[0].getParameterTypes();
            for (int i = 1; i != methods.length; ++i) {
                Class<?>[] types2 = methods[i].getParameterTypes();
                if (types2.length != argTypes.length) {
                    return null;
                }
                for (int j = 0; j != argTypes.length; ++j) {
                    if (types2[j] == argTypes[j]) continue;
                    return null;
                }
            }
            String glueName = "ifglue" + cache.newClassSerialNumber();
            byte[] code = JavaAdapter.createIFGlueCode(cl, methods, argTypes, glueName);
            Class glueClass = JavaAdapter.loadAdapterClass(glueName, code);
            try {
                master = (IFGlue)glueClass.newInstance();
            }
            catch (Exception ex) {
                throw Context.throwAsScriptRuntimeEx(ex);
            }
            int[] argsToConvert = JavaAdapter.getArgsToConvert(argTypes);
            master.ifglue_initMaster(argsToConvert);
            if (cache.isCachingEnabled()) {
                masters.put(cl, master);
            }
        }
        return master.ifglue_make(f);
    }

    private static byte[] createIFGlueCode(Class interfaceClass, Method[] methods, Class[] argTypes, String className) {
        String superName = IFGLUE_BASE;
        ClassFileWriter cfw = new ClassFileWriter(className, superName, "<ifglue>");
        cfw.addInterface(interfaceClass.getName());
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add((byte)42);
        cfw.addInvoke((byte)-73, superName, "<init>", "()V");
        cfw.add((byte)-79);
        cfw.stopMethod((short)1, null);
        for (int i = 0; i != methods.length; ++i) {
            Method method = methods[i];
            Class<?> returnType = method.getReturnType();
            StringBuffer sb = new StringBuffer();
            int localsEnd = JavaAdapter.appendMethodSignature(argTypes, returnType, sb);
            String methodSignature = sb.toString();
            cfw.startMethod(method.getName(), methodSignature, (short)1);
            cfw.addLoadThis();
            JavaAdapter.generatePushWrappedArgs(cfw, argTypes, argTypes.length + 1);
            cfw.add((byte)89);
            cfw.addPush(argTypes.length);
            cfw.addPush(method.getName());
            cfw.add((byte)83);
            cfw.addInvoke((byte)-73, superName, "ifglue_call", "([Ljava/lang/Object;)Ljava/lang/Object;");
            JavaAdapter.generateReturnResult(cfw, returnType);
            cfw.stopMethod((short)localsEnd, null);
        }
        return cfw.toByteArray();
    }

    private static Class loadAdapterClass(String className, byte[] classBytes) {
        GeneratedClassLoader loader = SecurityController.createLoader(null, null);
        Class result = loader.defineClass(className, classBytes);
        loader.linkClass(result);
        return result;
    }

    public static Function getFunction(Scriptable obj, String functionName) {
        Object x = ScriptableObject.getProperty(obj, functionName);
        if (x == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(x instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", functionName);
        }
        return (Function)x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callMethod(Scriptable scope, Scriptable thisObj, Function f, Object[] args, long argsToWrap) {
        if (f == null) {
            return Undefined.instance;
        }
        scope = ScriptableObject.getTopLevelScope(scope);
        Context cx = Context.getCurrentContext();
        if (cx != null) {
            return JavaAdapter.doCall(cx, scope, thisObj, f, args, argsToWrap);
        }
        cx = Context.enter();
        try {
            Object object = JavaAdapter.doCall(cx, scope, thisObj, f, args, argsToWrap);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    private static Object doCall(Context cx, Scriptable scope, Scriptable thisObj, Function f, Object[] args, long argsToWrap) {
        for (int i = 0; i != args.length; ++i) {
            Object arg;
            if (0L == (argsToWrap & (long)(1 << i)) || (arg = args[i]) instanceof Scriptable) continue;
            args[i] = cx.getWrapFactory().wrap(cx, scope, arg, null);
        }
        try {
            return f.call(cx, scope, thisObj, args);
        }
        catch (JavaScriptException ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
    }

    private static void generateCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add((byte)42);
        cfw.addInvoke((byte)-73, superName, "<init>", "()V");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)42);
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)3, null);
    }

    private static void generateSerialCtor(ClassFileWriter cfw, String adapterName, String superName) {
        cfw.startMethod("<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)V", (short)1);
        cfw.add((byte)42);
        cfw.addInvoke((byte)-73, superName, "<init>", "()V");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)44);
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)20, null);
    }

    private static void generateEmptyCtor(ClassFileWriter cfw, String adapterName, String superName, String scriptClassName) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.add((byte)42);
        cfw.addInvoke((byte)-73, superName, "<init>", "()V");
        cfw.add((byte)-69, scriptClassName);
        cfw.add((byte)89);
        cfw.addInvoke((byte)-73, scriptClassName, "<init>", "()V");
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", "runScript", "(Lorg/mozilla/javascript/Script;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)76);
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)-75, adapterName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)42);
        cfw.add((byte)43);
        cfw.add((byte)42);
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "createAdapterWrapper", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-75, adapterName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)-79);
        cfw.stopMethod((short)2, null);
    }

    private static void generatePushWrappedArgs(ClassFileWriter cfw, Class[] argTypes, int arrayLength) {
        cfw.addPush(arrayLength);
        cfw.add((byte)-67, "java/lang/Object");
        int paramOffset = 1;
        for (int i = 0; i != argTypes.length; ++i) {
            cfw.add((byte)89);
            cfw.addPush(i);
            paramOffset += JavaAdapter.generateWrapArg(cfw, paramOffset, argTypes[i]);
            cfw.add((byte)83);
        }
    }

    private static int generateWrapArg(ClassFileWriter cfw, int paramOffset, Class argType) {
        int size = 1;
        if (!argType.isPrimitive()) {
            cfw.add((byte)25, paramOffset);
        } else if (argType == Boolean.TYPE) {
            cfw.add((byte)-69, "java/lang/Boolean");
            cfw.add((byte)89);
            cfw.add((byte)21, paramOffset);
            cfw.addInvoke((byte)-73, "java/lang/Boolean", "<init>", "(Z)V");
        } else if (argType == Character.TYPE) {
            cfw.add((byte)21, paramOffset);
            cfw.addInvoke((byte)-72, "java/lang/String", "valueOf", "(C)Ljava/lang/String;");
        } else {
            cfw.add((byte)-69, "java/lang/Double");
            cfw.add((byte)89);
            String typeName = argType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add((byte)21, paramOffset);
                    cfw.add((byte)-121);
                    break;
                }
                case 'l': {
                    cfw.add((byte)22, paramOffset);
                    cfw.add((byte)-118);
                    size = 2;
                    break;
                }
                case 'f': {
                    cfw.add((byte)23, paramOffset);
                    cfw.add((byte)-115);
                    break;
                }
                case 'd': {
                    cfw.add((byte)24, paramOffset);
                    size = 2;
                }
            }
            cfw.addInvoke((byte)-73, "java/lang/Double", "<init>", "(D)V");
        }
        return size;
    }

    private static void generateReturnResult(ClassFileWriter cfw, Class retType) {
        if (retType == Void.TYPE) {
            cfw.add((byte)87);
            cfw.add((byte)-79);
        } else if (retType == Boolean.TYPE) {
            cfw.addInvoke((byte)-72, "org/mozilla/javascript/Context", "toBoolean", "(Ljava/lang/Object;)Z");
            cfw.add((byte)-84);
        } else if (retType == Character.TYPE) {
            cfw.addInvoke((byte)-72, "org/mozilla/javascript/Context", "toString", "(Ljava/lang/Object;)Ljava/lang/String;");
            cfw.add((byte)3);
            cfw.addInvoke((byte)-74, "java/lang/String", "charAt", "(I)C");
            cfw.add((byte)-84);
        } else if (retType.isPrimitive()) {
            cfw.addInvoke((byte)-72, "org/mozilla/javascript/Context", "toNumber", "(Ljava/lang/Object;)D");
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'i': 
                case 's': {
                    cfw.add((byte)-114);
                    cfw.add((byte)-84);
                    break;
                }
                case 'l': {
                    cfw.add((byte)-113);
                    cfw.add((byte)-83);
                    break;
                }
                case 'f': {
                    cfw.add((byte)-112);
                    cfw.add((byte)-82);
                    break;
                }
                case 'd': {
                    cfw.add((byte)-81);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected return type " + retType.toString());
                }
            }
        } else {
            String retTypeStr = retType.getName();
            cfw.addLoadConstant(retTypeStr);
            cfw.addInvoke((byte)-72, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            cfw.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "convertResult", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;");
            cfw.add((byte)-64, retTypeStr.replace('.', '/'));
            cfw.add((byte)-80);
        }
    }

    private static void generateMethod(ClassFileWriter cfw, String genName, String methodName, Class[] parms, Class returnType) {
        StringBuffer sb = new StringBuffer();
        int firstLocal = JavaAdapter.appendMethodSignature(parms, returnType, sb);
        String methodSignature = sb.toString();
        cfw.startMethod(methodName, methodSignature, (short)1);
        int DELEGEE = firstLocal;
        int FUNCTION = firstLocal + 1;
        int LOCALS_END = firstLocal + 2;
        cfw.add((byte)42);
        cfw.add((byte)-76, genName, "delegee", "Lorg/mozilla/javascript/Scriptable;");
        cfw.add((byte)89);
        cfw.addAStore(DELEGEE);
        cfw.addPush(methodName);
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "getFunction", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Function;");
        cfw.add((byte)89);
        cfw.addAStore(FUNCTION);
        cfw.addALoad(DELEGEE);
        cfw.add((byte)42);
        cfw.add((byte)-76, genName, "self", "Lorg/mozilla/javascript/Scriptable;");
        cfw.addALoad(FUNCTION);
        JavaAdapter.generatePushWrappedArgs(cfw, parms, parms.length);
        if (parms.length > 64) {
            throw Context.reportRuntimeError0("JavaAdapter can not subclass methods with more then 64 arguments.");
        }
        long convertionMask = 0L;
        for (int i = 0; i != parms.length; ++i) {
            if (parms[i].isPrimitive()) continue;
            convertionMask |= (long)(1 << i);
        }
        cfw.addPush(convertionMask);
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/JavaAdapter", "callMethod", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Function;[Ljava/lang/Object;J)Ljava/lang/Object;");
        JavaAdapter.generateReturnResult(cfw, returnType);
        cfw.stopMethod((short)LOCALS_END, null);
    }

    private static int generatePushParam(ClassFileWriter cfw, int paramOffset, Class paramType) {
        if (!paramType.isPrimitive()) {
            cfw.addALoad(paramOffset);
            return 1;
        }
        String typeName = paramType.getName();
        switch (typeName.charAt(0)) {
            case 'b': 
            case 'c': 
            case 'i': 
            case 's': 
            case 'z': {
                cfw.addILoad(paramOffset);
                return 1;
            }
            case 'l': {
                cfw.addLLoad(paramOffset);
                return 2;
            }
            case 'f': {
                cfw.addFLoad(paramOffset);
                return 1;
            }
            case 'd': {
                cfw.addDLoad(paramOffset);
                return 2;
            }
        }
        throw Kit.codeBug();
    }

    private static void generatePopResult(ClassFileWriter cfw, Class retType) {
        if (retType.isPrimitive()) {
            String typeName = retType.getName();
            switch (typeName.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': 
                case 'z': {
                    cfw.add((byte)-84);
                    break;
                }
                case 'l': {
                    cfw.add((byte)-83);
                    break;
                }
                case 'f': {
                    cfw.add((byte)-82);
                    break;
                }
                case 'd': {
                    cfw.add((byte)-81);
                }
            }
        } else {
            cfw.add((byte)-80);
        }
    }

    private static void generateSuper(ClassFileWriter cfw, String genName, String superName, String methodName, String methodSignature, Class[] parms, Class returnType) {
        cfw.startMethod("super$" + methodName, methodSignature, (short)1);
        cfw.add((byte)25, 0);
        int paramOffset = 1;
        for (int i = 0; i < parms.length; ++i) {
            paramOffset += JavaAdapter.generatePushParam(cfw, paramOffset, parms[i]);
        }
        cfw.addInvoke((byte)-73, superName, methodName, methodSignature);
        Class retType = returnType;
        if (!retType.equals(Void.TYPE)) {
            JavaAdapter.generatePopResult(cfw, retType);
        } else {
            cfw.add((byte)-79);
        }
        cfw.stopMethod((short)(paramOffset + 1), null);
    }

    private static String getMethodSignature(Method method, Class[] argTypes) {
        StringBuffer sb = new StringBuffer();
        JavaAdapter.appendMethodSignature(argTypes, method.getReturnType(), sb);
        return sb.toString();
    }

    private static int appendMethodSignature(Class[] argTypes, Class returnType, StringBuffer sb) {
        sb.append('(');
        int firstLocal = 1 + argTypes.length;
        for (int i = 0; i < argTypes.length; ++i) {
            Class type = argTypes[i];
            JavaAdapter.appendTypeString(sb, type);
            if (type != Long.TYPE && type != Double.TYPE) continue;
            ++firstLocal;
        }
        sb.append(')');
        JavaAdapter.appendTypeString(sb, returnType);
        return firstLocal;
    }

    private static StringBuffer appendTypeString(StringBuffer sb, Class type) {
        while (type.isArray()) {
            sb.append('[');
            type = type.getComponentType();
        }
        if (type.isPrimitive()) {
            char typeLetter;
            if (type == Boolean.TYPE) {
                typeLetter = 'Z';
            } else if (type == Long.TYPE) {
                typeLetter = 'J';
            } else {
                String typeName = type.getName();
                typeLetter = Character.toUpperCase(typeName.charAt(0));
            }
            sb.append(typeLetter);
        } else {
            sb.append('L');
            sb.append(type.getName().replace('.', '/'));
            sb.append(';');
        }
        return sb;
    }

    private static int[] getArgsToConvert(Class[] argTypes) {
        int count = 0;
        for (int i = 0; i != argTypes.length; ++i) {
            if (argTypes[i].isPrimitive()) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int[] array = new int[count];
        count = 0;
        for (int i = 0; i != argTypes.length; ++i) {
            if (argTypes[i].isPrimitive()) continue;
            array[count++] = i;
        }
        return array;
    }

    static class JavaAdapterSignature {
        Class superClass;
        Class[] interfaces;
        ObjToIntMap names;

        JavaAdapterSignature(Class superClass, Class[] interfaces, ObjToIntMap names) {
            this.superClass = superClass;
            this.interfaces = interfaces;
            this.names = names;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JavaAdapterSignature)) {
                return false;
            }
            JavaAdapterSignature sig = (JavaAdapterSignature)obj;
            if (this.superClass != sig.superClass) {
                return false;
            }
            if (this.interfaces != sig.interfaces) {
                if (this.interfaces.length != sig.interfaces.length) {
                    return false;
                }
                for (int i = 0; i < this.interfaces.length; ++i) {
                    if (this.interfaces[i] == sig.interfaces[i]) continue;
                    return false;
                }
            }
            if (this.names.size() != sig.names.size()) {
                return false;
            }
            ObjToIntMap.Iterator iter = new ObjToIntMap.Iterator(this.names);
            iter.start();
            while (!iter.done()) {
                String name = (String)iter.getKey();
                int arity = iter.getValue();
                if (arity != this.names.get(name, arity + 1)) {
                    return false;
                }
                iter.next();
            }
            return true;
        }

        public int hashCode() {
            return this.superClass.hashCode() | -1640531527 * (this.names.size() | this.interfaces.length << 16);
        }
    }

    public static class IFGlue
    implements Cloneable,
    Callable {
        private Function function;
        private int[] argsToConvert;

        final IFGlue ifglue_make(Function function) {
            IFGlue copy;
            if (function == null) {
                Kit.codeBug();
            }
            if (this.function != null) {
                Kit.codeBug();
            }
            try {
                copy = (IFGlue)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                copy = null;
            }
            copy.function = function;
            return copy;
        }

        final void ifglue_initMaster(int[] argsToConvert) {
            if (this.function != null) {
                Kit.codeBug();
            }
            this.argsToConvert = argsToConvert;
        }

        protected final Object ifglue_call(Object[] args) throws JavaScriptException {
            Scriptable scope;
            Scriptable thisObj = scope = this.function.getParentScope();
            return Context.call(this, scope, thisObj, args);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            if (this.argsToConvert != null) {
                WrapFactory wf = cx.getWrapFactory();
                int N = this.argsToConvert.length;
                for (int i = 0; i != N; ++i) {
                    int index = this.argsToConvert[i];
                    Object arg = args[index];
                    if (arg == null || arg instanceof Scriptable) continue;
                    args[index] = wf.wrap(cx, scope, arg, null);
                }
            }
            return this.function.call(cx, scope, thisObj, args);
        }
    }
}

