/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

final class NativeError
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private boolean prototypeFlag;

    NativeError() {
    }

    static void init(Context cx, Scriptable scope, boolean sealed) {
        NativeError obj = new NativeError();
        obj.prototypeFlag = true;
        ScriptableObject.putProperty((Scriptable)obj, "name", (Object)"Error");
        ScriptableObject.putProperty((Scriptable)obj, "message", (Object)"");
        ScriptableObject.putProperty((Scriptable)obj, "fileName", (Object)"");
        ScriptableObject.putProperty((Scriptable)obj, "lineNumber", (Object)new Integer(0));
        obj.addAsPrototype(3, cx, scope, sealed);
    }

    static NativeError make(Context cx, Scriptable scope, IdFunction ctorObj, Object[] args) {
        Scriptable proto = (Scriptable)ctorObj.get("prototype", (Scriptable)ctorObj);
        NativeError obj = new NativeError();
        obj.setPrototype(proto);
        obj.setParentScope(scope);
        if (args.length >= 1) {
            ScriptableObject.putProperty((Scriptable)obj, "message", (Object)ScriptRuntime.toString(args[0]));
            if (args.length >= 2) {
                ScriptableObject.putProperty((Scriptable)obj, "fileName", args[1]);
                if (args.length >= 3) {
                    int line = ScriptRuntime.toInt32(args[2]);
                    ScriptableObject.putProperty((Scriptable)obj, "lineNumber", (Object)new Integer(line));
                }
            }
        }
        return obj;
    }

    @Override
    public int methodArity(int methodId) {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                return 1;
            }
            if (methodId == 2) {
                return 0;
            }
            if (methodId == 3) {
                return 0;
            }
        }
        return super.methodArity(methodId);
    }

    @Override
    public Object execMethod(int methodId, IdFunction f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (methodId == 1) {
                return NativeError.make(cx, scope, f, args);
            }
            if (methodId == 2) {
                return NativeError.js_toString(thisObj);
            }
            if (methodId == 3) {
                return NativeError.js_toSource(cx, scope, thisObj);
            }
        }
        return super.execMethod(methodId, f, cx, scope, thisObj, args);
    }

    private static String js_toString(Scriptable thisObj) {
        return NativeError.getString(thisObj, "name") + ": " + NativeError.getString(thisObj, "message");
    }

    private static String js_toSource(Context cx, Scriptable scope, Scriptable thisObj) throws JavaScriptException {
        Object name = ScriptableObject.getProperty(thisObj, "name");
        Object message = ScriptableObject.getProperty(thisObj, "message");
        Object fileName = ScriptableObject.getProperty(thisObj, "fileName");
        Object lineNumber = ScriptableObject.getProperty(thisObj, "lineNumber");
        StringBuffer sb = new StringBuffer();
        sb.append("(new ");
        if (name == NOT_FOUND) {
            name = Undefined.instance;
        }
        sb.append(ScriptRuntime.toString(name));
        sb.append("(");
        if (message != NOT_FOUND || fileName != NOT_FOUND || lineNumber != NOT_FOUND) {
            if (message == NOT_FOUND) {
                message = "";
            }
            sb.append(ScriptRuntime.uneval(cx, scope, message));
            if (fileName != NOT_FOUND || lineNumber != NOT_FOUND) {
                int line;
                sb.append(", ");
                if (fileName == NOT_FOUND) {
                    fileName = "";
                }
                sb.append(ScriptRuntime.uneval(cx, scope, fileName));
                if (lineNumber != NOT_FOUND && (line = ScriptRuntime.toInt32(lineNumber)) != 0) {
                    sb.append(", ");
                    sb.append(ScriptRuntime.toString(line));
                }
            }
        }
        sb.append("))");
        return sb.toString();
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    public String toString() {
        return NativeError.js_toString(this);
    }

    private static String getString(Scriptable obj, String id) {
        Object value = ScriptableObject.getProperty(obj, id);
        if (value == NOT_FOUND) {
            return "";
        }
        return ScriptRuntime.toString(value);
    }

    @Override
    protected String getIdName(int id) {
        if (this.prototypeFlag) {
            if (id == 1) {
                return "constructor";
            }
            if (id == 2) {
                return "toString";
            }
            if (id == 3) {
                return "toSource";
            }
        }
        return null;
    }

    @Override
    protected int mapNameToId(String s) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int id = 0;
        String X = null;
        int s_length = s.length();
        if (s_length == 8) {
            char c = s.charAt(3);
            if (c == 'o') {
                X = "toSource";
                id = 3;
            } else if (c == 't') {
                X = "toString";
                id = 2;
            }
        } else if (s_length == 11) {
            X = "constructor";
            id = 1;
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

