/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.expressions.sys;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.expressions.AbstractExpression;

public class GroupByExpression
extends AbstractExpression {
    private ArrayList fields = new ArrayList();
    private transient String[] fieldsCached;

    @Override
    public Object computeValue() throws DataSourceException {
        DataRow dataRow = this.getDataRow();
        String[] stringArray = this.getField();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            DataFlags dataFlags = dataRow.getFlags(string);
            if (dataFlags == null || !dataFlags.isChanged()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setField(int n, String string) {
        if (this.fields.size() == n) {
            this.fields.add(string);
        } else {
            this.fields.set(n, string);
        }
        this.fieldsCached = null;
    }

    public String getField(int n) {
        return (String)this.fields.get(n);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public String[] getField() {
        if (this.fieldsCached == null) {
            this.fieldsCached = this.fields.toArray(new String[this.fields.size()]);
        }
        return (String[])this.fieldsCached.clone();
    }

    public void setField(String[] stringArray) {
        this.fields.clear();
        this.fields.addAll(Arrays.asList(stringArray));
        this.fieldsCached = (String[])stringArray.clone();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GroupByExpression groupByExpression = (GroupByExpression)super.clone();
        groupByExpression.fields = (ArrayList)this.fields.clone();
        groupByExpression.fieldsCached = this.fieldsCached;
        return groupByExpression;
    }
}

