/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.script.framework.container.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLParserFactory {
    private static XMLParser parser = null;
    private static String officedtdurl = null;

    private XMLParserFactory() {
    }

    public static synchronized XMLParser getParser() {
        if (parser == null) {
            parser = new DefaultParser();
        }
        return parser;
    }

    public static void setOfficeDTDURL(String url) {
        officedtdurl = url;
    }

    private static class DefaultParser
    implements XMLParser {
        private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        @Override
        public Document parse(InputStream inputStream) throws IOException {
            Document result = null;
            try {
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                InputSource is = new InputSource(inputStream);
                if (officedtdurl != null) {
                    is.setSystemId(officedtdurl);
                }
                result = builder.parse(is);
            }
            catch (SAXParseException ex1) {
                IOException ex2 = new IOException();
                ex2.initCause(ex1);
                throw ex2;
            }
            catch (SAXException ex1) {
                IOException ex2 = new IOException();
                ex2.initCause(ex1);
                throw ex2;
            }
            catch (ParserConfigurationException ex1) {
                IOException ex2 = new IOException();
                ex2.initCause(ex1);
                throw ex2;
            }
            return result;
        }

        @Override
        public void write(Document doc, OutputStream out) throws IOException {
            block7: {
                Class<?> clazz = doc.getClass();
                String name = clazz.getName();
                try {
                    if (name.equals("com.sun.xml.tree.XmlDocument") || name.equals("org.apache.crimson.tree.XmlDocument")) {
                        Method write = clazz.getDeclaredMethod("write", OutputStream.class);
                        write.invoke((Object)doc, out);
                        break block7;
                    }
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class<?> serializerClass = null;
                    Class<?> formatterClass = null;
                    try {
                        serializerClass = Class.forName("org.apache.xml.serialize.XMLSerializer", true, cl);
                        formatterClass = Class.forName("org.apache.xml.serialize.OutputFormat", true, cl);
                    }
                    catch (ClassNotFoundException cnfe) {
                        String prefix = "com.sun.org.apache.xml.internal.";
                        serializerClass = Class.forName(prefix + "serialize.XMLSerializer", true, cl);
                        formatterClass = Class.forName(prefix + "serialize.OutputFormat", true, cl);
                    }
                    Object serializerObject = serializerClass.newInstance();
                    Object formatterObject = formatterClass.newInstance();
                    Method method = formatterClass.getMethod("setMethod", String.class);
                    method.invoke(formatterObject, "xml");
                    method = formatterClass.getMethod("setIndenting", Boolean.TYPE);
                    method.invoke(formatterObject, Boolean.TRUE);
                    method = serializerClass.getMethod("setOutputByteStream", OutputStream.class);
                    method.invoke(serializerObject, out);
                    method = serializerClass.getMethod("setOutputFormat", formatterClass);
                    method.invoke(serializerObject, formatterObject);
                    method = serializerClass.getMethod("asDOMSerializer", new Class[0]);
                    Object impl = method.invoke(serializerObject, new Object[0]);
                    method = impl.getClass().getMethod("serialize", Document.class);
                    method.invoke(impl, doc);
                }
                catch (NoSuchMethodException ex1) {
                    IOException ex2 = new IOException();
                    ex2.initCause(ex1);
                    throw ex2;
                }
                catch (ClassNotFoundException ex1) {
                    IOException ex2 = new IOException();
                    ex2.initCause(ex1);
                    throw ex2;
                }
                catch (Exception ex1) {
                    IOException ex2 = new IOException();
                    ex2.initCause(ex1);
                    throw ex2;
                }
            }
        }
    }
}

