/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.office;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.report.JFreeReport;
import org.jfree.report.structure.Node;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.parser.office.BodyReadHandler;
import org.libreoffice.report.pentaho.parser.office.FontFaceDeclsReadHandler;
import org.libreoffice.report.pentaho.parser.office.MasterStylesReadHandler;
import org.libreoffice.report.pentaho.parser.style.OfficeStylesReadHandler;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DocumentContentReadHandler
extends AbstractXmlReadHandler {
    private static final Log LOGGER = LogFactory.getLog(DocumentContentReadHandler.class);
    private OfficeDocument report;
    private FontFaceDeclsReadHandler fontFaceReadHandler;
    private BodyReadHandler bodyReadHandler;
    private OfficeStylesCollection officeStylesCollection;

    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.report = this.parseContentXml();
        this.report.setVirtual(true);
        this.report.setType("document-content");
        this.report.setNamespace("urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.report.setVirtual(true);
        this.officeStylesCollection = this.parseStylesXml();
    }

    private OfficeStylesCollection parseStylesXml() {
        ResourceKey contextKey = this.getRootHandler().getContext();
        ResourceManager resourceManager = this.getRootHandler().getResourceManager();
        try {
            ResourceKey key = resourceManager.deriveKey(contextKey, "styles.xml");
            Resource resource = resourceManager.create(key, contextKey, OfficeStylesCollection.class);
            OfficeStylesCollection styles = (OfficeStylesCollection)((Object)resource.getResource());
            if (styles != null) {
                return styles;
            }
        }
        catch (ResourceKeyCreationException e) {
            LOGGER.debug((Object)"Failed to create resource-key for 'styles.xml'. Ignoring.", (Throwable)e);
        }
        catch (ResourceException e) {
            LOGGER.debug((Object)"Failed to parse resource for 'styles.xml'. Ignoring.", (Throwable)e);
        }
        return new OfficeStylesCollection();
    }

    private OfficeDocument parseContentXml() {
        if (!"urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(this.getUri()) || "document-content".equals(this.getTagName())) {
            return new OfficeDocument();
        }
        ResourceKey contextKey = this.getRootHandler().getContext();
        ResourceManager resourceManager = this.getRootHandler().getResourceManager();
        try {
            ResourceKey key = resourceManager.deriveKey(contextKey, "content.xml");
            Resource resource = resourceManager.create(key, contextKey, JFreeReport.class);
            OfficeDocument doc = (OfficeDocument)((Object)resource.getResource());
            if (doc != null) {
                return doc;
            }
        }
        catch (ResourceKeyCreationException e) {
            LOGGER.debug((Object)"Failed to create resource-key for 'content.xml'. Ignoring.");
        }
        catch (ResourceException e) {
            LOGGER.debug((Object)"Failed to parse resource for 'content.xml'. Ignoring.");
        }
        return new OfficeDocument();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:office:1.0".equals(uri)) {
            if ("font-face-decls".equals(tagName)) {
                if (this.fontFaceReadHandler == null) {
                    this.fontFaceReadHandler = new FontFaceDeclsReadHandler(this.officeStylesCollection.getFontFaceDecls());
                }
                return this.fontFaceReadHandler;
            }
            if ("automatic-styles".equals(tagName)) {
                return new OfficeStylesReadHandler(this.officeStylesCollection.getAutomaticStyles());
            }
            if ("styles".equals(tagName)) {
                return new OfficeStylesReadHandler(this.officeStylesCollection.getCommonStyles());
            }
            if ("master-styles".equals(tagName)) {
                return new MasterStylesReadHandler(this.officeStylesCollection.getMasterStyles());
            }
            if ("body".equals(tagName)) {
                this.bodyReadHandler = new BodyReadHandler();
                return this.bodyReadHandler;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.report.setStylesCollection(this.officeStylesCollection);
        if (this.bodyReadHandler != null) {
            this.report.addNode((Node)this.bodyReadHandler.getElement());
        }
    }

    public Object getObject() throws SAXException {
        return this.report;
    }
}

