/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class FilesystemFilter
extends FileFilter
implements FilenameFilter {
    private String[] fileext;
    private String descr;
    private boolean accDirs;

    public FilesystemFilter(String fileext, String descr) {
        this(fileext, descr, true);
    }

    public FilesystemFilter(String fileext, String descr, boolean accDirs) {
        this(new String[]{fileext}, descr, accDirs);
    }

    public FilesystemFilter(String[] fileext, String descr, boolean accDirs) {
        this.fileext = (String[])fileext.clone();
        this.descr = descr;
        this.accDirs = accDirs;
    }

    @Override
    public boolean accept(File dir, String name) {
        File f = new File(dir, name);
        if (f.isDirectory() && this.acceptsDirectories()) {
            return true;
        }
        for (int i = 0; i < this.fileext.length; ++i) {
            if (!name.endsWith(this.fileext[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File dir) {
        if (dir.isDirectory() && this.acceptsDirectories()) {
            return true;
        }
        for (int i = 0; i < this.fileext.length; ++i) {
            if (!dir.getName().endsWith(this.fileext[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.descr;
    }

    public void acceptDirectories(boolean b) {
        this.accDirs = b;
    }

    public boolean acceptsDirectories() {
        return this.accDirs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilesystemFilter that = (FilesystemFilter)o;
        if (this.accDirs != that.accDirs) {
            return false;
        }
        if (this.descr != null ? !this.descr.equals(that.descr) : that.descr != null) {
            return false;
        }
        return ObjectUtilities.equalArray(this.fileext, that.fileext);
    }

    public int hashCode() {
        int result = ObjectUtilities.hashCode(this.fileext);
        result = 31 * result + (this.descr != null ? this.descr.hashCode() : 0);
        result = 31 * result + (this.accDirs ? 1 : 0);
        return result;
    }
}

