/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import java.util.Date;
import org.jfree.report.DataFlags;

public class DefaultDataFlags
implements DataFlags {
    private Object value;
    private boolean changed;
    private String name;

    public DefaultDataFlags(String string, Object object, boolean bl) {
        this.value = object;
        this.changed = bl;
        this.name = string;
    }

    @Override
    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    @Override
    public boolean isDate() {
        return this.value instanceof Date;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isZero() {
        if (!this.isNumeric()) {
            return false;
        }
        Number number = (Number)this.value;
        return number.floatValue() == 0.0f;
    }

    @Override
    public boolean isNegative() {
        if (!this.isNumeric()) {
            return false;
        }
        Number number = (Number)this.value;
        return number.floatValue() < 0.0f;
    }

    @Override
    public boolean isPositive() {
        if (!this.isNumeric()) {
            return false;
        }
        Number number = (Number)this.value;
        return number.floatValue() > 0.0f;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DefaultDataFlags={name=");
        stringBuffer.append(this.name);
        stringBuffer.append(", value=");
        stringBuffer.append(this.value);
        stringBuffer.append(", changed=");
        stringBuffer.append(this.changed);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

