/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.sql.Time;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class TimeFunction
implements Function {
    private static final long serialVersionUID = -9175775325047486483L;

    @Override
    public String getCanonicalName() {
        return "TIME";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Number n3;
        Number n2;
        Number n1;
        if (parameters.getParameterCount() != 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        try {
            TypeRegistry typeRegistry = context.getTypeRegistry();
            n1 = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
            n2 = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
            n3 = typeRegistry.convertToNumber(parameters.getType(2), parameters.getValue(2));
        }
        catch (NumberFormatException e) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (n1 == null || n2 == null || n3 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int hours = n1.intValue();
        int minutes = n2.intValue();
        int seconds = n3.intValue();
        LocalizationContext localizationContext = context.getLocalizationContext();
        Time time = DateUtil.createTime(hours, minutes, seconds, localizationContext);
        return new TypeValuePair(DateTimeType.TIME_TYPE, time);
    }
}

