/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.java;

import com.sun.star.lib.uno.Proxy;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public final class java_environment
implements IEnvironment {
    private static final Registry localObjects = new Registry();
    private final Object context;
    private final Registry proxies = new Registry();

    public java_environment(Object context) {
        this.context = context;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public String getName() {
        return "java";
    }

    @Override
    public Object registerInterface(Object object, String[] oid, Type type) {
        if (oid[0] == null) {
            oid[0] = UnoRuntime.generateOid(object);
        }
        return (this.isProxy(object) ? this.proxies : localObjects).register(object, oid[0], type);
    }

    @Override
    public void revokeInterface(String oid, Type type) {
        if (!this.proxies.revoke(oid, type)) {
            localObjects.revoke(oid, type);
        }
    }

    @Override
    public Object getRegisteredInterface(String oid, Type type) {
        Object o = this.proxies.get(oid, type);
        if (o == null) {
            o = localObjects.get(oid, type);
        }
        return o;
    }

    @Override
    public String getRegisteredObjectIdentifier(Object object) {
        return UnoRuntime.generateOid(object);
    }

    @Override
    public void list() {
    }

    public void revokeAllProxies() {
        this.proxies.clear();
    }

    public boolean equals(Object obj) {
        return false;
    }

    private boolean isProxy(Object object) {
        return object instanceof Proxy;
    }

    private static final class Registry {
        private final HashMap<String, Level1Entry> level1map = new HashMap();
        private final ReferenceQueue<Object> queue = new ReferenceQueue();

        private Registry() {
        }

        public synchronized Object register(Object object, String oid, Type type) {
            Object o;
            Level2Entry l2;
            this.cleanUp();
            Level1Entry l1 = this.level1map.get(oid);
            if (l1 != null && (l2 = l1.level2map.get(type)) != null && (o = l2.get()) != null) {
                l2.acquire();
                return o;
            }
            if (l1 == null) {
                l1 = new Level1Entry();
                this.level1map.put(oid, l1);
            }
            l1.level2map.put(type, new Level2Entry(oid, type, object, this.queue));
            return object;
        }

        public synchronized boolean revoke(String oid, Type type) {
            Level1Entry l1 = this.level1map.get(oid);
            Level2Entry l2 = null;
            if (l1 != null && (l2 = l1.level2map.get(type)) != null && l2.release()) {
                this.removeLevel2Entry(l1, oid, type);
            }
            this.cleanUp();
            return l2 != null;
        }

        public synchronized Object get(String oid, Type type) {
            Level1Entry l1 = this.level1map.get(oid);
            return l1 == null ? null : l1.find(type);
        }

        public synchronized void clear() {
            this.level1map.clear();
            this.cleanUp();
        }

        private void cleanUp() {
            Reference<Object> tmp;
            Level2Entry l2;
            while ((l2 = (Level2Entry)(tmp = this.queue.poll())) != null) {
                Level1Entry l1 = this.level1map.get(l2.oid);
                if (l1 == null || l1.level2map.get(l2.type) != l2) continue;
                this.removeLevel2Entry(l1, l2.oid, l2.type);
            }
        }

        private void removeLevel2Entry(Level1Entry l1, String oid, Type type) {
            l1.level2map.remove(type);
            if (l1.level2map.isEmpty()) {
                this.level1map.remove(oid);
            }
        }

        private static final class Level2Entry
        extends WeakReference<Object> {
            public final String oid;
            public final Type type;
            private int count = 1;

            public Level2Entry(String oid, Type type, Object object, ReferenceQueue<Object> queue) {
                super(object, queue);
                this.oid = oid;
                this.type = type;
            }

            public void acquire() {
                ++this.count;
            }

            public boolean release() {
                return --this.count == 0;
            }
        }

        private static final class Level1Entry {
            public final HashMap<Type, Level2Entry> level2map = new HashMap();

            private Level1Entry() {
            }

            public Object find(Type type) {
                Object o;
                Level2Entry l22 = this.level2map.get(type);
                if (l22 != null && (o = l22.get()) != null) {
                    return o;
                }
                for (Level2Entry l22 : this.level2map.values()) {
                    Object o2;
                    if (!type.isSupertypeOf(l22.type) || (o2 = l22.get()) == null) continue;
                    return o2;
                }
                return null;
            }
        }
    }
}

