/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.PrecomputeNode;
import org.jfree.report.data.StaticExpressionRuntimeData;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.ExpressionRuntime;
import org.jfree.report.expressions.Function;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.i18n.ResourceBundleFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class RunningExpressionSlot
implements ExpressionSlot,
ExpressionRuntime {
    private StaticExpressionRuntimeData staticRuntimeData;
    private Expression expression;
    private Object value;
    private String name;
    private boolean queried;
    private DataRow dataRow;

    public RunningExpressionSlot(Expression expression, StaticExpressionRuntimeData staticExpressionRuntimeData, PrecomputeNode precomputeNode) {
        this.staticRuntimeData = staticExpressionRuntimeData;
        this.expression = expression;
        this.name = expression.getName();
        this.expression.setRuntime(this);
        this.expression.setRuntime(null);
    }

    public Expression getExpression() {
        return this.expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() throws DataSourceException {
        if (!this.queried) {
            Expression expression = this.expression;
            synchronized (expression) {
                this.expression.setRuntime(this);
                this.value = this.expression.computeValue();
                this.expression.setRuntime(null);
            }
            this.queried = true;
        }
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataRow getDataRow() {
        return this.dataRow;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void updateDataRow(DataRow dataRow) {
        this.dataRow = dataRow;
    }

    @Override
    public ReportData getData() {
        return this.staticRuntimeData.getData();
    }

    @Override
    public Object getDeclaringParent() {
        return this.staticRuntimeData.getDeclaringParent();
    }

    @Override
    public Configuration getConfiguration() {
        return this.staticRuntimeData.getConfiguration();
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.staticRuntimeData.getResourceBundleFactory();
    }

    @Override
    public void advance() throws DataSourceException {
        if (this.expression instanceof Function) {
            Function function = (Function)this.expression;
            this.expression.setRuntime(this);
            this.expression = function.advance();
            function.setRuntime(null);
            this.expression.setRuntime(null);
        }
        this.value = null;
        this.queried = false;
    }

    @Override
    public boolean isDeepTraversing() {
        return this.expression.isDeepTraversing();
    }

    @Override
    public int getCurrentRow() {
        return this.staticRuntimeData.getCurrentRow();
    }

    @Override
    public ReportContext getReportContext() {
        return this.staticRuntimeData.getReportContext();
    }

    @Override
    public boolean isPreserve() {
        return this.expression.isPreserve();
    }
}

