/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pManager;
import android.util.Log;
import com.lvrenyang.nzio.NZNative;
import java.util.Collection;

@TargetApi(value=16)
public class NZWiFiP2PDeviceEnumerator {
    private static final String TAG = "WiFiP2PDeviceEnumerator";
    private long function_ptr = 0L;
    private long private_data = 0L;
    private WifiP2pManager mManager = null;
    private WifiP2pManager.Channel mChannel = null;
    private WifiP2pManager.PeerListListener mPeerListListener = new WifiP2pManager.PeerListListener(){

        public void onPeersAvailable(WifiP2pDeviceList peers) {
            Collection devices = peers.getDeviceList();
            for (WifiP2pDevice device : devices) {
                Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)(device.deviceName + " " + device.deviceAddress + " " + device.primaryDeviceType));
                if (NZWiFiP2PDeviceEnumerator.this.function_ptr == 0L) continue;
                NZNative.OnWiFiP2PDeviceScan(NZWiFiP2PDeviceEnumerator.this.function_ptr, NZWiFiP2PDeviceEnumerator.this.private_data, device.deviceName, device.deviceAddress, device.primaryDeviceType);
            }
        }
    };
    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("wifi_p2p_state", -1);
                if (state == 2) {
                    Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)"Wifi P2P is enabled");
                } else {
                    Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)"Wi-Fi P2P is not enabled");
                }
            } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
                if (NZWiFiP2PDeviceEnumerator.this.mManager != null) {
                    try {
                        NZWiFiP2PDeviceEnumerator.this.mManager.requestPeers(NZWiFiP2PDeviceEnumerator.this.mChannel, NZWiFiP2PDeviceEnumerator.this.mPeerListListener);
                    }
                    catch (SecurityException ex) {
                        ex.printStackTrace();
                    }
                    catch (Throwable tr) {
                        tr.printStackTrace();
                    }
                }
            } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action) || "android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
                // empty if block
            }
        }
    };
    private IntentFilter intentFilter = new IntentFilter();

    public void initBroadcast(Context ctx) {
        this.mManager = (WifiP2pManager)ctx.getSystemService("wifip2p");
        this.mChannel = this.mManager.initialize(ctx, ctx.getMainLooper(), null);
        this.intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        this.intentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        this.intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        this.intentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        ctx.registerReceiver(this.broadcastReceiver, this.intentFilter);
    }

    public void uninitBroadcast(Context ctx) {
        ctx.unregisterReceiver(this.broadcastReceiver);
    }

    public boolean StartScan(long function_ptr, long private_data) {
        this.function_ptr = function_ptr;
        this.private_data = private_data;
        try {
            this.mManager.discoverPeers(this.mChannel, new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)"Start Discover Peers");
                }

                public void onFailure(int reasonCode) {
                    Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)("Failed To Start Discover Peers. reasonCode:" + reasonCode));
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return true;
    }

    public boolean IsScanning() {
        return true;
    }

    public void StopScan() {
        this.mManager.stopPeerDiscovery(this.mChannel, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
                Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)"Stop Discover Peers");
            }

            public void onFailure(int reasonCode) {
                Log.i((String)NZWiFiP2PDeviceEnumerator.TAG, (String)("Failed To Stop Discover Peers. reasonCode:" + reasonCode));
            }
        });
    }
}

