/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.content.Context;
import android.util.Log;
import com.lvrenyang.io.NETClient;
import com.lvrenyang.nzio.NZIO;
import com.lvrenyang.nzio.NZWiFiP2PDeviceManager;

public class NZWiFiP2PClientSocketIO
extends NZIO {
    private static final String TAG = "NZWiFiP2PClientSocketIO";
    private NETClient netClient = new NETClient();

    public boolean Open(String address, int port, int timeout, Context ctx) {
        boolean result = false;
        try {
            NZWiFiP2PDeviceManager.InitHandlerAndManager(ctx);
            NZWiFiP2PDeviceManager.ConnectDeviceV2(address, timeout);
            String ipAddress = NZWiFiP2PDeviceManager.GetGroupOwnerHostAddress();
            if (ipAddress != null && !ipAddress.isEmpty()) {
                result = this.netClient.Open(ipAddress, port, timeout);
            }
            if (result = this.IsOpened()) {
                Log.i((String)TAG, (String)("Connected  to " + address + " " + ipAddress + " " + port));
            } else {
                Log.i((String)TAG, (String)("Failed Connect to " + address));
                this.Close();
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return result;
    }

    public void Close() {
        try {
            this.netClient.Close();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
    }

    @Override
    public boolean IsOpened() {
        boolean result = false;
        try {
            result = this.netClient.IsOpened();
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return result;
    }

    @Override
    public int Write(byte[] buffer, int offset, int count) {
        if (!this.IsOpened()) {
            return -1;
        }
        int nBytesWritten = 0;
        try {
            nBytesWritten = this.netClient.Write(buffer, offset, count);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
            nBytesWritten = -1;
        }
        return nBytesWritten;
    }

    @Override
    public int Read(byte[] buffer, int offset, int count, int timeout) {
        if (!this.IsOpened()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            nBytesReaded = this.netClient.Read(buffer, offset, count, timeout);
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return nBytesReaded;
    }
}

