package com.caysn.autoreplyprint.cmprint;

import com.caysn.autoreplyprint.AutoReplyPrint;

/**
 * 描述连接端口时要用到的信息
 * <p>
 * 蓝牙端口有分spp协议和ble协议
 * 网络端口有分tcp协议和udp协议
 * <p>
 * 连接端口时，可能还要用到其他各种参数，都在相应的子类中填入
 * <p>
 * 端口名称，端口地址，端口类别，都是做参考用的
 * 对于连接端口函数来说，仅会判断实例是哪个子类，然后转换成对应子类，通过相应的属性，去连接端口
 */
public class CMPrinterConnectPortInfo {

    public static final String CMPrinterConnectPortTypeCom = "com";
    public static final String CMPrinterConnectPortTypeUsb = "usb";
    public static final String CMPrinterConnectPortTypeNetTcp = "net-tcp";
    public static final String CMPrinterConnectPortTypeNetUdp = "net-udp";
    public static final String CMPrinterConnectPortTypeBtSpp = "bt-spp";
    public static final String CMPrinterConnectPortTypeBtBle = "bt-ble";

    public String port_name;
    public String port_address;
    public String port_type;

    public static class CMPrinterConnectComPortInfo extends CMPrinterConnectPortInfo {
        public String com_name;
        public int com_baudrate;
        public int com_databits;
        public int com_parity;
        public int com_stopbits;
        public int com_flowcontrol;

        public CMPrinterConnectComPortInfo(String com_name, int com_baudrate, int com_databits, int com_parity, int com_stopbits, int com_flowcontrol) {
            this.port_name = "COM";
            this.port_address = com_name;
            this.port_type = CMPrinterConnectPortTypeCom;
            this.com_name = com_name;
            this.com_baudrate = com_baudrate;
            this.com_databits = com_databits;
            this.com_parity = com_parity;
            this.com_stopbits = com_stopbits;
            this.com_flowcontrol = com_flowcontrol;
        }
    }

    public static class CMPrinterConnectUsbPortInfo extends CMPrinterConnectPortInfo {
        public String usb_path;

        public CMPrinterConnectUsbPortInfo(String usb_path) {
            this.port_name = "USB";
            this.port_address = usb_path;
            this.port_type = CMPrinterConnectPortTypeUsb;
            this.usb_path = usb_path;
        }
    }

    public static class CMPrinterConnectNetTcpPortInfo extends CMPrinterConnectPortInfo {
        public String local_ip;
        public String dest_mac;
        public String dest_ip;
        public String dest_name;
        public int dest_port;

        public CMPrinterConnectNetTcpPortInfo(String local_ip, String dest_mac, String dest_ip, String dest_name, int dest_port) {
            this.port_name = dest_name;
            this.port_address = dest_ip;
            this.port_type = CMPrinterConnectPortTypeNetTcp;
            this.local_ip = local_ip;
            this.dest_mac = dest_mac;
            this.dest_ip = dest_ip;
            this.dest_name = dest_name;
            this.dest_port = dest_port;
        }
    }

    public static class CMPrinterConnectNetUdpPortInfo extends CMPrinterConnectPortInfo {
        public String local_ip;
        public String dest_mac;
        public String dest_ip;
        public String dest_name;
        public int dest_port;

        public CMPrinterConnectNetUdpPortInfo(String local_ip, String dest_mac, String dest_ip, String dest_name, int dest_port) {
            this.port_name = dest_name;
            this.port_address = dest_ip;
            this.port_type = CMPrinterConnectPortTypeNetUdp;
            this.local_ip = local_ip;
            this.dest_mac = dest_mac;
            this.dest_ip = dest_ip;
            this.dest_name = dest_name;
            this.dest_port = dest_port;
        }
    }

    public static class CMPrinterConnectBtSppPortInfo extends CMPrinterConnectPortInfo {
        public String bluetooth_name;
        public String bluetooth_address;

        public CMPrinterConnectBtSppPortInfo(String bluetooth_name, String bluetooth_address) {
            this.port_name = bluetooth_name;
            this.port_address = bluetooth_address;
            this.port_type = CMPrinterConnectPortTypeBtSpp;
            this.bluetooth_name = bluetooth_name;
            this.bluetooth_address = bluetooth_address;
        }
    }

    public static class CMPrinterConnectBtBlePortInfo extends CMPrinterConnectPortInfo {
        public String bluetooth_name;
        public String bluetooth_address;

        public CMPrinterConnectBtBlePortInfo(String bluetooth_name, String bluetooth_address) {
            this.port_name = bluetooth_name;
            this.port_address = bluetooth_address;
            this.port_type = CMPrinterConnectPortTypeBtBle;
            this.bluetooth_name = bluetooth_name;
            this.bluetooth_address = bluetooth_address;
        }
    }

    // 判断已连接和待连接的两个端口，是不是同一个端口，如果是同一个端口，连接前就不必要先断开端口了。
    // 如果两个端口都不为空，且端口类型相同，继续往下判断，否则认为不是同一个端口
    // 串口，判断名称，波特率，数据位，校验位，停止位，流控制
    // USB，仅判断路径是否一致
    // 网口仅判断本地ip,目标ip,目标端口是否一致
    // 蓝牙仅判断蓝牙地址是否一致
    public static boolean isSamePort(CMPrinterConnectPortInfo p1, CMPrinterConnectPortInfo p2) {
        if ((p1 == null) && (p2 == null))
            return true;
        if ((p1 != null) && (p2 != null) && (p1.port_type.compareTo(p2.port_type) == 0)) {
            if (p1.port_type.compareTo(CMPrinterConnectPortTypeCom) == 0) {
                CMPrinterConnectComPortInfo pi1 = (CMPrinterConnectComPortInfo) p1;
                CMPrinterConnectComPortInfo pi2 = (CMPrinterConnectComPortInfo) p2;
                if ((pi1.com_name.compareTo(pi2.com_name) == 0) &&
                        (pi1.com_baudrate == pi2.com_baudrate) &&
                        (pi1.com_databits == pi2.com_databits) &&
                        (pi1.com_parity == pi2.com_parity) &&
                        (pi1.com_stopbits == pi2.com_stopbits) &&
                        (pi1.com_flowcontrol == pi2.com_flowcontrol))
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterConnectPortTypeUsb) == 0) {
                CMPrinterConnectUsbPortInfo pi1 = (CMPrinterConnectUsbPortInfo) p1;
                CMPrinterConnectUsbPortInfo pi2 = (CMPrinterConnectUsbPortInfo) p2;
                if (pi1.usb_path.compareTo(pi2.usb_path) == 0)
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterConnectPortTypeNetTcp) == 0) {
                CMPrinterConnectNetTcpPortInfo pi1 = (CMPrinterConnectNetTcpPortInfo) p1;
                CMPrinterConnectNetTcpPortInfo pi2 = (CMPrinterConnectNetTcpPortInfo) p2;
                if ((pi1.local_ip.compareTo(pi2.local_ip) == 0) &&
                        (pi1.dest_ip.compareTo(pi2.dest_ip) == 0) &&
                        (pi1.dest_port == pi2.dest_port))
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterConnectPortTypeNetUdp) == 0) {
                CMPrinterConnectNetUdpPortInfo pi1 = (CMPrinterConnectNetUdpPortInfo) p1;
                CMPrinterConnectNetUdpPortInfo pi2 = (CMPrinterConnectNetUdpPortInfo) p2;
                if ((pi1.local_ip.compareTo(pi2.local_ip) == 0) &&
                        (pi1.dest_ip.compareTo(pi2.dest_ip) == 0) &&
                        (pi1.dest_port == pi2.dest_port))
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterConnectPortTypeBtSpp) == 0) {
                CMPrinterConnectBtSppPortInfo pi1 = (CMPrinterConnectBtSppPortInfo) p1;
                CMPrinterConnectBtSppPortInfo pi2 = (CMPrinterConnectBtSppPortInfo) p2;
                if (pi1.bluetooth_address.compareTo(pi2.bluetooth_address) == 0)
                    return true;
            } else if (p1.port_type.compareTo(CMPrinterConnectPortTypeBtBle) == 0) {
                CMPrinterConnectBtBlePortInfo pi1 = (CMPrinterConnectBtBlePortInfo) p1;
                CMPrinterConnectBtBlePortInfo pi2 = (CMPrinterConnectBtBlePortInfo) p2;
                if (pi1.bluetooth_address.compareTo(pi2.bluetooth_address) == 0)
                    return true;
            }
        }
        return false;
    }

    // 根据搜到的端口信息，生成默认的用于连接打印机的连接端口信息
    public static CMPrinterConnectPortInfo defaultPort(CMPrinterDiscoveredPortInfo p) {
        if (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredComPortInfo.class.isInstance(p)) {
            CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredComPortInfo pi = (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredComPortInfo) p;
            return new CMPrinterConnectComPortInfo(pi.com_name, 115200, AutoReplyPrint.CP_ComDataBits_8, AutoReplyPrint.CP_ComParity_NoParity, AutoReplyPrint.CP_ComStopBits_One, AutoReplyPrint.CP_ComFlowControl_None);
        } else if (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredUsbPortInfo.class.isInstance(p)) {
            CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredUsbPortInfo pi = (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredUsbPortInfo) p;
            return new CMPrinterConnectUsbPortInfo(pi.usb_path);
        } else if (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredNetPortInfo.class.isInstance(p)) {
            CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredNetPortInfo pi = (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredNetPortInfo) p;
            return new CMPrinterConnectNetTcpPortInfo(pi.local_ip, pi.discovered_mac, pi.discovered_ip, pi.discovered_name, 9100);
        } else if (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredBtSppPortInfo.class.isInstance(p)) {
            CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredBtSppPortInfo pi = (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredBtSppPortInfo) p;
            return new CMPrinterConnectBtSppPortInfo(pi.bluetooth_name, pi.bluetooth_address);
        } else if (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredBtBlePortInfo.class.isInstance(p)) {
            CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredBtBlePortInfo pi = (CMPrinterDiscoveredPortInfo.CMPrinterDiscoveredBtBlePortInfo) p;
            return new CMPrinterConnectBtBlePortInfo(pi.bluetooth_name, pi.bluetooth_address);
        } else {
            return null;
        }
    }

}
