package com.caysn.autoreplyprint.caprint;

import java.util.Locale;

/**
 * 描述打印机状态。
 * 包含错误状态，信息状态。
 * 错误状态，表明打印机出错，需要排除错误后打印机才可以继续打印。
 * 信息状态，仅提供一些打印机的信息，比如是否处于标签模式等。
 */
public class CAPrinterStatus {

    private long error_status = 0;
    private long info_status = 0;

    public CAPrinterStatus(long error_status, long info_status) {
        this.error_status = error_status;
        this.info_status = info_status;
    }

    public long errorStatus() {
        return error_status;
    }

    public long infoStatus() {
        return info_status;
    }

    public boolean ERROR_OCCURED() {
        return error_status != 0;
    }

    public boolean ERROR_CUTTER() {
        return (error_status & 0x01) != 0;
    }

    public boolean ERROR_FLASH() {
        return (error_status & 0x02) != 0;
    }

    public boolean ERROR_NOPAPER() {
        return (error_status & 0x04) != 0;
    }

    public boolean ERROR_VOLTAGE() {
        return (error_status & 0x08) != 0;
    }

    public boolean ERROR_MARKER() {
        return (error_status & 0x10) != 0;
    }

    public boolean ERROR_ENGINE() {
        return (error_status & 0x20) != 0;
    }

    public boolean ERROR_OVERHEAT() {
        return (error_status & 0x40) != 0;
    }

    public boolean ERROR_COVERUP() {
        return (error_status & 0x80) != 0;
    }

    public boolean ERROR_MOTOR() {
        return (error_status & 0x100) != 0;
    }

    public boolean INFO_LABELPAPER() {
        return (info_status & 0x02) != 0;
    }

    public boolean INFO_LABELMODE() {
        return (info_status & 0x04) != 0;
    }

    public boolean INFO_HAVEDATA() {
        return (info_status & 0x08) != 0;
    }

    public boolean INFO_NOPAPERCANCELED() {
        return (info_status & 0x10) != 0;
    }

    public boolean INFO_PAPERNOFETCH() {
        return (info_status & 0x20) != 0;
    }

    public boolean INFO_PRINTIDLE() {
        return (info_status & 0x40) != 0;
    }

    public boolean INFO_RECVIDLE() {
        return (info_status & 0x80) != 0;
    }

    @Override
    public String toString() {
        String error_status_string = String.format(Locale.CHINA, "Printer Error Status: 0x%04X ", error_status & 0xffff);
        if (ERROR_OCCURED()) {
            if (ERROR_CUTTER())
                error_status_string += "[ERROR_CUTTER]";
            if (ERROR_FLASH())
                error_status_string += "[ERROR_FLASH]";
            if (ERROR_NOPAPER())
                error_status_string += "[ERROR_NOPAPER]";
            if (ERROR_VOLTAGE())
                error_status_string += "[ERROR_VOLTAGE]";
            if (ERROR_MARKER())
                error_status_string += "[ERROR_MARKER]";
            if (ERROR_ENGINE())
                error_status_string += "[ERROR_MOVEMENT]";
            if (ERROR_OVERHEAT())
                error_status_string += "[ERROR_OVERHEAT]";
            if (ERROR_COVERUP())
                error_status_string += "[ERROR_COVERUP]";
            if (ERROR_MOTOR())
                error_status_string += "[ERROR_MOTOR]";
        }
        String info_status_string = String.format(Locale.CHINA, "Printer Info Status: 0x%04X ", info_status & 0xffff);
        if (INFO_LABELMODE())
            info_status_string += "[Label Mode]";
        if (INFO_LABELPAPER())
            info_status_string += "[Label Paper]";
        if (INFO_PAPERNOFETCH())
            info_status_string += "[Paper Not Fetch]";
        return error_status_string + "\r\n" + info_status_string + "\r\n";
    }

}
