/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class NZUsbDeviceEnumerator {
    private static final String TAG = "NZUsbDeviceEnumerator";

    public static List<String> EnumUsbProductSerialNumber(Context context) {
        ArrayList<String> usbProductSerialNumberList = new ArrayList<String>();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                HashMap usbDeviceHashMap = usbManager.getDeviceList();
                Collection usbDeviceCollection = usbDeviceHashMap.values();
                for (UsbDevice usbDevice : usbDeviceCollection) {
                    int interfaceCount = usbDevice.getInterfaceCount();
                    if (interfaceCount == 1) {
                        String usbProductSerialNumber = usbDevice.getProductName() + "/" + usbDevice.getSerialNumber();
                        usbProductSerialNumberList.add(usbProductSerialNumber);
                        continue;
                    }
                    if (interfaceCount <= 1) continue;
                    for (int interfaceIndex = 0; interfaceIndex < interfaceCount; ++interfaceIndex) {
                        String usbProductSerialNumber = usbDevice.getProductName() + "/" + usbDevice.getSerialNumber() + ",MI:" + String.format("%02d", interfaceIndex);
                        usbProductSerialNumberList.add(usbProductSerialNumber);
                    }
                }
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return usbProductSerialNumberList;
    }

    public static List<String> EnumUsbVidPid(Context context) {
        ArrayList<String> usbVidPidList = new ArrayList<String>();
        try {
            if (Build.VERSION.SDK_INT >= 12) {
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                HashMap usbDeviceHashMap = usbManager.getDeviceList();
                Collection usbDeviceCollection = usbDeviceHashMap.values();
                for (UsbDevice usbDevice : usbDeviceCollection) {
                    int interfaceCount = usbDevice.getInterfaceCount();
                    if (interfaceCount == 1) {
                        String usbVidPid = String.format("VID:0x%04X,PID:0x%04X", usbDevice.getVendorId(), usbDevice.getProductId());
                        usbVidPidList.add(usbVidPid);
                        continue;
                    }
                    if (interfaceCount <= 1) continue;
                    for (int interfaceIndex = 0; interfaceIndex < interfaceCount; ++interfaceIndex) {
                        String usbVidPid = String.format("VID:0x%04X,PID:0x%04X,MI:%02d", usbDevice.getVendorId(), usbDevice.getProductId(), interfaceIndex);
                        usbVidPidList.add(usbVidPid);
                    }
                }
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return usbVidPidList;
    }
}

