/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.nzio;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.util.Log;
import com.lvrenyang.nzio.NZIO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;

@TargetApi(value=12)
public class NZUSBClientIO
extends NZIO {
    private static final String TAG = "NZUSBClientIO";
    private UsbDevice mUsbDevice = null;
    private UsbEndpoint mUsbEndpointOut = null;
    private UsbEndpoint mUsbEndpointIn = null;
    private UsbDeviceConnection mUsbDeviceConnection = null;
    private UsbInterface mUsbInterface = null;
    private BroadcastReceiver broadcastReceiver = null;
    private IntentFilter intentFilter = null;
    public int mUsbWriteAlignment = 64;

    public synchronized boolean Open(UsbDevice device, int mi, Context context) {
        try {
            if (this.IsOpened()) {
                throw new Exception("Already connected, Please disconnect first.");
            }
            UsbManager manager = (UsbManager)context.getSystemService("usb");
            if (manager == null) {
                throw new Exception("No UsbManager");
            }
            if (!NZUSBClientIO.CheckUsbDevicePermission(device, context)) {
                NZUSBClientIO.RequestUsbDevicePermission(device, context);
            }
            UsbInterface usbInterface = null;
            UsbEndpoint usbEndpointOut = null;
            UsbEndpoint usbEndpointIn = null;
            for (int k = 0; k < device.getInterfaceCount(); ++k) {
                if (mi != -1 && k != mi || (usbInterface = device.getInterface(k)) == null || device.getInterfaceCount() > 1 && (usbInterface.getInterfaceClass() != 7 || usbInterface.getInterfaceSubclass() != 1)) continue;
                usbEndpointOut = null;
                usbEndpointIn = null;
                for (int j = 0; j < usbInterface.getEndpointCount(); ++j) {
                    UsbEndpoint endpoint = usbInterface.getEndpoint(j);
                    if (endpoint.getDirection() == 0 && endpoint.getType() == 2) {
                        usbEndpointOut = endpoint;
                    } else if (endpoint.getDirection() == 128 && endpoint.getType() == 2) {
                        usbEndpointIn = endpoint;
                    }
                    if (null != usbEndpointOut && null != usbEndpointIn) break;
                }
                if (null != usbEndpointOut && null != usbEndpointIn) break;
            }
            if (null == usbInterface || null == usbEndpointOut || null == usbEndpointIn) {
                throw new Exception("No Endpoint");
            }
            UsbDeviceConnection usbDeviceConnection = manager.openDevice(device);
            if (null == usbDeviceConnection) {
                throw new Exception("Open Device Failed");
            }
            if (!usbDeviceConnection.claimInterface(usbInterface, true)) {
                usbDeviceConnection.close();
                throw new Exception("ClaimInterface Failed");
            }
            this.mUsbDevice = device;
            this.mUsbEndpointOut = usbEndpointOut;
            this.mUsbEndpointIn = usbEndpointIn;
            this.mUsbDeviceConnection = usbDeviceConnection;
            this.mUsbInterface = usbInterface;
            if (this.IsOpened()) {
                this.InitBroadcast(context);
            }
            if (this.IsOpened()) {
                Log.i((String)TAG, (String)("Opened " + device.getDeviceName()));
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
        }
        return this.IsOpened();
    }

    private synchronized void InitBroadcast(Context context) {
        if (this.broadcastReceiver == null) {
            this.broadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    try {
                        UsbDevice device;
                        String action = intent.getAction();
                        Log.i((String)NZUSBClientIO.TAG, (String)("action:" + action));
                        if (action.compareTo("android.hardware.usb.action.USB_DEVICE_DETACHED") == 0 && (device = (UsbDevice)intent.getParcelableExtra("device")) != null && NZUSBClientIO.this.mUsbDevice != null && device.getDeviceName().compareTo(NZUSBClientIO.this.mUsbDevice.getDeviceName()) == 0) {
                            NZUSBClientIO.this.Close();
                        }
                    }
                    catch (Throwable tr) {
                        tr.printStackTrace();
                    }
                }
            };
        }
        if (this.intentFilter == null) {
            this.intentFilter = new IntentFilter();
            this.intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        }
        if (context != null && this.broadcastReceiver != null && this.intentFilter != null) {
            try {
                context.registerReceiver(this.broadcastReceiver, this.intentFilter);
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
    }

    public synchronized boolean Open(int vid, int pid, int mi, Context context) {
        Log.i((String)TAG, (String)String.format(Locale.CHINA, "Open VID:0x%04X,PID:0x%04X,MI:%02d", vid, pid, mi));
        try {
            if (Build.VERSION.SDK_INT >= 12) {
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                HashMap usbDeviceHashMap = usbManager.getDeviceList();
                Collection usbDeviceCollection = usbDeviceHashMap.values();
                for (UsbDevice usbDevice : usbDeviceCollection) {
                    if (usbDevice.getVendorId() != vid || usbDevice.getProductId() != pid) continue;
                    return this.Open(usbDevice, mi, context);
                }
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return false;
    }

    public synchronized boolean Open(String productName, String serialNumber, int mi, Context context) {
        Log.i((String)TAG, (String)String.format(Locale.CHINA, "Open %s/%s,MI:%02d", productName, serialNumber, mi));
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                UsbManager usbManager = (UsbManager)context.getSystemService("usb");
                HashMap usbDeviceHashMap = usbManager.getDeviceList();
                Collection usbDeviceCollection = usbDeviceHashMap.values();
                for (UsbDevice usbDevice : usbDeviceCollection) {
                    String usbDeviceProductName = usbDevice.getProductName();
                    String usbDeviceSerialNumber = usbDevice.getSerialNumber();
                    if (productName == null) {
                        productName = "null";
                    }
                    if (serialNumber == null) {
                        serialNumber = "null";
                    }
                    if (usbDeviceProductName == null) {
                        usbDeviceProductName = "null";
                    }
                    if (usbDeviceSerialNumber == null) {
                        usbDeviceSerialNumber = "null";
                    }
                    if (usbDeviceProductName.compareTo(productName) != 0 || usbDeviceSerialNumber.compareTo(serialNumber) != 0) continue;
                    return this.Open(usbDevice, mi, context);
                }
            }
        }
        catch (Throwable tr) {
            tr.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean IsOpened() {
        return this.mUsbEndpointOut != null && this.mUsbEndpointIn != null && this.mUsbDeviceConnection != null && this.mUsbInterface != null;
    }

    public synchronized void Close() {
        if (this.mUsbDeviceConnection != null) {
            try {
                this.mUsbDeviceConnection.releaseInterface(this.mUsbInterface);
            }
            catch (Throwable tr) {
                Log.e((String)TAG, (String)tr.toString());
            }
            try {
                this.mUsbDeviceConnection.close();
            }
            catch (Throwable tr) {
                Log.e((String)TAG, (String)tr.toString());
            }
            this.mUsbDeviceConnection = null;
            this.mUsbEndpointOut = null;
            this.mUsbEndpointIn = null;
            this.mUsbInterface = null;
            Log.i((String)TAG, (String)"Closed");
        }
    }

    @Override
    public int Write(byte[] buffer, int offset, int count) {
        if (!this.IsOpened()) {
            return -1;
        }
        try {
            int nBytesWritten;
            int nSended;
            for (nBytesWritten = 0; nBytesWritten < count; nBytesWritten += nSended) {
                if (!this.IsOpened()) {
                    throw new Exception("Write Failed... Closed");
                }
                int nPackageSize = Math.min(16384, count - nBytesWritten);
                byte[] data = new byte[nPackageSize];
                System.arraycopy(buffer, offset + nBytesWritten, data, 0, data.length);
                nSended = 0;
                nSended = this.mUsbWriteAlignment > 0 ? this.WriteBulkWithAlignment(data, this.mUsbWriteAlignment) : this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointOut, data, data.length, Integer.MAX_VALUE);
                if (nSended >= 0) continue;
                throw new Exception("Write Failed... bulkTransfer " + nSended);
            }
            return nBytesWritten;
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
            return -1;
        }
    }

    private int WriteBulkWithAlignment(byte[] buffer, int alignment) {
        int nSended;
        byte[] data = buffer;
        if (alignment > 0) {
            data = new byte[(buffer.length + alignment - 1) / alignment * alignment];
            System.arraycopy(buffer, 0, data, 0, buffer.length);
        }
        if ((nSended = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointOut, data, data.length, Integer.MAX_VALUE)) >= buffer.length) {
            return buffer.length;
        }
        return nSended;
    }

    @Override
    public int Read(byte[] buffer, int offset, int count, int timeout) {
        if (!this.IsOpened()) {
            return -1;
        }
        try {
            int nPackageSize = this.mUsbEndpointIn.getMaxPacketSize();
            byte[] receive = new byte[Math.min(nPackageSize, count)];
            int nReceived = this.mUsbDeviceConnection.bulkTransfer(this.mUsbEndpointIn, receive, receive.length, 100);
            if (nReceived > 0) {
                System.arraycopy(receive, 0, buffer, offset, nReceived);
                String str = "Recv: ";
                for (int i = 0; i < nReceived; ++i) {
                    str = str + String.format(Locale.CHINA, "%02X ", (long)buffer[offset + i] & 0xFFL);
                }
            } else if (nReceived < 0) {
                nReceived = 0;
            }
            return nReceived;
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)tr.toString());
            return -1;
        }
    }

    public static boolean CheckUsbDevicePermission(UsbDevice usbDevice, Context context) {
        try {
            UsbManager usbManager = (UsbManager)context.getSystemService("usb");
            if (usbManager.hasPermission(usbDevice)) {
                return true;
            }
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)"", (Throwable)tr);
        }
        return false;
    }

    public static boolean RequestUsbDevicePermission(UsbDevice usbDevice, Context context) {
        try {
            UsbManager usbManager = (UsbManager)context.getSystemService("usb");
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(context.getPackageName()), (int)0);
            usbManager.requestPermission(usbDevice, pendingIntent);
            return true;
        }
        catch (Throwable tr) {
            Log.e((String)TAG, (String)"", (Throwable)tr);
            return false;
        }
    }
}

