/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.Log;
import com.lvrenyang.io.IO;
import com.lvrenyang.io.IOCallBack;
import com.lvrenyang.io.NETClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=1)
public class NETPrinting
extends IO {
    private static final String TAG = "NETPrinting";
    private NETClient mmNetClient = new NETClient();
    private Socket mmClientSocket = null;
    private DataInputStream is = null;
    private DataOutputStream os = null;
    private AtomicBoolean isOpened = new AtomicBoolean(false);
    private AtomicBoolean isReadyRW = new AtomicBoolean(false);
    private IOCallBack cb = null;
    private Vector<Byte> rxBuffer = new Vector();
    private AtomicLong nIdleTime = new AtomicLong(0L);
    private final ReentrantLock mOpenLocker = new ReentrantLock();
    private final ReentrantLock mCloseLocker = new ReentrantLock();
    private String address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean Open(String IPAddress, int PortNumber, Context mContext) {
        try {
            this.mOpenLocker.lock();
            if (this.isOpened.get()) {
                throw new Exception("Already open");
            }
            if (null == IPAddress) {
                throw new Exception("Null Pointer IPAddress");
            }
            this.address = IPAddress;
            this.isReadyRW.set(false);
            try {
                InetSocketAddress socketAddress = new InetSocketAddress(IPAddress, PortNumber);
                this.mmClientSocket = new Socket();
                this.mmClientSocket.connect(socketAddress, 5000);
                this.os = new DataOutputStream(this.mmClientSocket.getOutputStream());
                this.is = new DataInputStream(this.mmClientSocket.getInputStream());
                this.isReadyRW.set(true);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
                try {
                    this.mmClientSocket.close();
                }
                catch (Exception closeException) {
                    Log.i((String)TAG, (String)closeException.toString());
                }
                finally {
                    this.mmClientSocket = null;
                    this.os = null;
                    this.is = null;
                }
            }
            if (this.isReadyRW.get()) {
                Log.v((String)TAG, (String)("Connected to " + IPAddress + ":" + PortNumber));
                this.rxBuffer.clear();
            }
            this.isOpened.set(this.isReadyRW.get());
            if (this.isOpened.get()) {
                this.StartReadThread();
            }
            if (null != this.cb) {
                if (this.isOpened.get()) {
                    this.cb.OnOpen();
                } else {
                    this.cb.OnOpenFailed();
                }
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mOpenLocker.unlock();
        }
        return this.isOpened.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void BaseClose() {
        this.mmNetClient.Close();
        this.mCloseLocker.lock();
        try {
            try {
                if (null != this.mmClientSocket) {
                    this.mmClientSocket.shutdownInput();
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
            }
            try {
                if (null != this.mmClientSocket) {
                    this.mmClientSocket.shutdownOutput();
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
            }
            try {
                if (null != this.mmClientSocket) {
                    this.mmClientSocket.close();
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)ex.toString());
            }
            if (!this.isReadyRW.get()) {
                throw new Exception();
            }
            this.mmClientSocket = null;
            this.is = null;
            this.os = null;
            this.isReadyRW.set(false);
            if (!this.isOpened.get()) {
                throw new Exception();
            }
            this.isOpened.set(false);
            if (null != this.cb) {
                this.cb.OnClose();
            }
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
        finally {
            this.mCloseLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int Write(byte[] buffer, int offset, int count) {
        if (!this.isReadyRW.get()) {
            return -1;
        }
        int nBytesWritten = 0;
        try {
            this.nIdleTime.set(0L);
            this.os.write(buffer, offset, count);
            this.os.flush();
            nBytesWritten = count;
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesWritten = -1;
        }
        return nBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int BaseRead(byte[] buffer, int offset, int count, int timeout) {
        if (!this.isReadyRW.get()) {
            return -1;
        }
        int nBytesReaded = 0;
        try {
            this.nIdleTime.set(0L);
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < (long)timeout) {
                if (!this.isReadyRW.get()) {
                    throw new Exception("Not Ready For Read Write");
                }
                if (nBytesReaded == count) break;
                if (this.rxBuffer.size() > 0) {
                    buffer[offset + nBytesReaded] = this.rxBuffer.get(0);
                    this.rxBuffer.remove(0);
                    ++nBytesReaded;
                    continue;
                }
                int available = this.is.available();
                if (available > 0) {
                    byte[] receive = new byte[available];
                    int nReceived = this.is.read(receive);
                    if (nReceived <= 0) continue;
                    for (int i = 0; i < nReceived; ++i) {
                        this.rxBuffer.add(receive[i]);
                    }
                    continue;
                }
                Thread.sleep(1L);
            }
            this.nIdleTime.set(System.currentTimeMillis());
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.toString());
            this.Close();
            nBytesReaded = -1;
        }
        return nBytesReaded;
    }

    @Override
    public boolean IsOpened() {
        return this.isOpened.get();
    }

    public void SetCallBack(IOCallBack callBack) {
        try {
            this.cb = callBack;
        }
        catch (Exception ex) {
            Log.i((String)TAG, (String)ex.toString());
        }
    }
}

