/*
 * Decompiled with CFR 0.152.
 */
package com.lvrenyang.io;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;

class ImageProcessing {
    private static int[][] Floyd16x16 = new int[][]{{0, 128, 32, 160, 8, 136, 40, 168, 2, 130, 34, 162, 10, 138, 42, 170}, {192, 64, 224, 96, 200, 72, 232, 104, 194, 66, 226, 98, 202, 74, 234, 106}, {48, 176, 16, 144, 56, 184, 24, 152, 50, 178, 18, 146, 58, 186, 26, 154}, {240, 112, 208, 80, 248, 120, 216, 88, 242, 114, 210, 82, 250, 122, 218, 90}, {12, 140, 44, 172, 4, 132, 36, 164, 14, 142, 46, 174, 6, 134, 38, 166}, {204, 76, 236, 108, 196, 68, 228, 100, 206, 78, 238, 110, 198, 70, 230, 102}, {60, 188, 28, 156, 52, 180, 20, 148, 62, 190, 30, 158, 54, 182, 22, 150}, {252, 124, 220, 92, 244, 116, 212, 84, 254, 126, 222, 94, 246, 118, 214, 86}, {3, 131, 35, 163, 11, 139, 43, 171, 1, 129, 33, 161, 9, 137, 41, 169}, {195, 67, 227, 99, 203, 75, 235, 107, 193, 65, 225, 97, 201, 73, 233, 105}, {51, 179, 19, 147, 59, 187, 27, 155, 49, 177, 17, 145, 57, 185, 25, 153}, {243, 115, 211, 83, 251, 123, 219, 91, 241, 113, 209, 81, 249, 121, 217, 89}, {15, 143, 47, 175, 7, 135, 39, 167, 13, 141, 45, 173, 5, 133, 37, 165}, {207, 79, 239, 111, 199, 71, 231, 103, 205, 77, 237, 109, 197, 69, 229, 101}, {63, 191, 31, 159, 55, 183, 23, 151, 61, 189, 29, 157, 53, 181, 21, 149}, {254, 127, 223, 95, 247, 119, 215, 87, 253, 125, 221, 93, 245, 117, 213, 85}};

    ImageProcessing() {
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        float scaleWidth = (float)w / (float)bitmapWidth;
        float scaleHeight = (float)h / (float)bitmapHeight;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmapWidth, (int)bitmapHeight, (Matrix)matrix, (boolean)false);
    }

    public static void format_K_dither16x16(int xsize, int ysize, byte[] orgpixels, boolean[] despixels) {
        int k = 0;
        for (int y = 0; y < ysize; ++y) {
            for (int x = 0; x < xsize; ++x) {
                despixels[k] = (orgpixels[k] & 0xFF) <= Floyd16x16[x & 0xF][y & 0xF];
                ++k;
            }
        }
    }

    public static void format_K_threshold(int xsize, int ysize, byte[] orgpixels, boolean[] despixels) {
        int gray;
        int j;
        int i;
        int graytotal = 0;
        int grayave = 128;
        int k = 0;
        for (i = 0; i < ysize; ++i) {
            for (j = 0; j < xsize; ++j) {
                gray = orgpixels[k] & 0xFF;
                graytotal += gray;
                ++k;
            }
        }
        grayave = graytotal / ysize / xsize;
        k = 0;
        for (i = 0; i < ysize; ++i) {
            for (j = 0; j < xsize; ++j) {
                gray = orgpixels[k] & 0xFF;
                despixels[k] = gray <= grayave;
                ++k;
            }
        }
    }

    public static void format_K_threshold(Bitmap mBitmap) {
        int gray;
        int j;
        int i;
        int graytotal = 0;
        int grayave = 128;
        int graycnt = 1;
        int ysize = mBitmap.getHeight();
        int xsize = mBitmap.getWidth();
        for (i = 0; i < ysize; ++i) {
            for (j = 0; j < xsize; ++j) {
                gray = mBitmap.getPixel(j, i) & 0xFF;
                if (gray == 0 || gray == 255) continue;
                graytotal += gray;
                ++graycnt;
            }
        }
        grayave = graytotal / graycnt;
        for (i = 0; i < ysize; ++i) {
            for (j = 0; j < xsize; ++j) {
                gray = mBitmap.getPixel(j, i) & 0xFF;
                if (gray > grayave) {
                    mBitmap.setPixel(j, i, -1);
                    continue;
                }
                mBitmap.setPixel(j, i, -16777216);
            }
        }
    }

    public static Bitmap alignBitmap(Bitmap bitmap, int wbits, int hbits, int color) {
        if (bitmap.getWidth() % wbits == 0 && bitmap.getHeight() % hbits == 0) {
            return bitmap;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int newwidth = (width + wbits - 1) / wbits * wbits;
        int newheight = (height + hbits - 1) / hbits * hbits;
        int[] newpixels = new int[newwidth * newheight];
        Bitmap newbitmap = Bitmap.createBitmap((int)newwidth, (int)newheight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        for (int i = 0; i < newheight; ++i) {
            for (int j = 0; j < newwidth; ++j) {
                newpixels[i * newwidth + j] = i < height && j < width ? pixels[i * width + j] : color;
            }
        }
        newbitmap.setPixels(newpixels, 0, newwidth, 0, 0, newwidth, newheight);
        return newbitmap;
    }

    public static Bitmap adjustPhotoRotation(Bitmap bm, int orientationDegree) {
        Matrix m = new Matrix();
        m.setRotate((float)orientationDegree, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
        try {
            Bitmap bm1 = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)m, (boolean)true);
            return bm1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    private static int PixOffset(int w, int x, int y) {
        return y * w + x;
    }

    public static byte[] Image1ToNVData(int width, int height, boolean[] src) {
        int x = (width + 7) / 8;
        int y = (height + 7) / 8;
        int dstlen = 4 + x * y * 8;
        byte[] dst = new byte[dstlen];
        dst[0] = (byte)x;
        dst[1] = (byte)(x >> 8);
        dst[2] = (byte)y;
        dst[3] = (byte)(y >> 8);
        int idx = 4;
        int d = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int offset = ImageProcessing.PixOffset(width, i, j);
                d = j % 8 == 0 ? (src[offset] ? 1 : 0) << 7 - j % 8 : (d |= (src[offset] ? 1 : 0) << 7 - j % 8);
                if (j % 8 != 7 && j != height - 1) continue;
                dst[idx++] = (byte)d;
            }
        }
        return dst;
    }

    public static byte[] Image1ToGSCmd(int width, int height, boolean[] src) {
        int x = (width + 7) / 8;
        int y = (height + 7) / 8;
        int dstlen = 4 + x * y * 8;
        byte[] dst = new byte[dstlen];
        dst[0] = 29;
        dst[1] = 42;
        dst[2] = (byte)x;
        dst[3] = (byte)y;
        int idx = 4;
        int d = 0;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int offset = ImageProcessing.PixOffset(width, i, j);
                d = j % 8 == 0 ? (src[offset] ? 1 : 0) << 7 - j % 8 : (d |= (src[offset] ? 1 : 0) << 7 - j % 8);
                if (j % 8 != 7 && j != height - 1) continue;
                dst[idx++] = (byte)d;
            }
        }
        return dst;
    }

    public static byte[] Image1ToRasterCmd(int width, int height, boolean[] src) {
        int x = (width + 7) / 8;
        int y = (height + 7) / 8 * 8;
        int dstlen = 8 + x * y;
        byte[] dst = new byte[dstlen];
        dst[0] = 29;
        dst[1] = 118;
        dst[2] = 48;
        dst[3] = 0;
        dst[4] = (byte)(x % 256);
        dst[5] = (byte)(x / 256);
        dst[6] = (byte)(y % 256);
        dst[7] = (byte)(y / 256);
        int idx = 8;
        int d = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int offset = ImageProcessing.PixOffset(width, i, j);
                d = i % 8 == 0 ? (src[offset] ? 1 : 0) << 7 - i % 8 : (d |= (src[offset] ? 1 : 0) << 7 - i % 8);
                if (i % 8 != 7 && i != width - 1) continue;
                dst[idx++] = (byte)d;
            }
        }
        return dst;
    }

    public static byte[] Image1ToRasterData(int width, int height, boolean[] src) {
        int x = (width + 7) / 8;
        int y = height;
        int dstlen = x * y;
        byte[] dst = new byte[dstlen];
        int idx = 0;
        int d = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int offset = ImageProcessing.PixOffset(width, i, j);
                d = i % 8 == 0 ? (src[offset] ? 1 : 0) << 7 - i % 8 : (d |= (src[offset] ? 1 : 0) << 7 - i % 8);
                if (i % 8 != 7 && i != width - 1) continue;
                dst[idx++] = (byte)d;
            }
        }
        return dst;
    }

    public static byte[] Image1ToTM88IVRasterCmd(int width, int height, boolean[] src) {
        int x = (width + 7) / 8 * 8;
        int y = (height + 7) / 8 * 8;
        int dstlen = 26 + x * y / 8;
        byte[] dst = new byte[dstlen];
        dst[0] = 29;
        dst[1] = 56;
        dst[2] = 76;
        dst[3] = (byte)(x * y / 8 + 10 & 0xFF);
        dst[4] = (byte)(x * y / 8 + 10 >> 8 & 0xFF);
        dst[5] = (byte)(x * y / 8 + 10 >> 16 & 0xFF);
        dst[6] = (byte)(x * y / 8 + 10 >> 24 & 0xFF);
        dst[7] = 48;
        dst[8] = 112;
        dst[9] = 48;
        dst[10] = 1;
        dst[11] = 1;
        dst[12] = 49;
        dst[13] = (byte)(x % 256);
        dst[14] = (byte)(x / 256);
        dst[15] = (byte)(y % 256);
        dst[16] = (byte)(y / 256);
        byte[] cmdPrint = new byte[]{29, 56, 76, 2, 0, 0, 0, 48, 2};
        System.arraycopy(cmdPrint, 0, dst, dstlen - cmdPrint.length, cmdPrint.length);
        int idx = 17;
        byte d = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int offset = ImageProcessing.PixOffset(width, i, j);
                d = i % 8 == 0 ? (byte)((src[offset] ? 1 : 0) << 7 - i % 8) : (byte)(d | (byte)((src[offset] ? 1 : 0) << 7 - i % 8));
                if (i % 8 != 7 && i != width - 1) continue;
                dst[idx++] = d;
            }
        }
        return dst;
    }

    public static byte[] eachLinePixToCmd(boolean[] src, int nWidth, int nMode) {
        int nHeight = src.length / nWidth;
        int nBytesPerLine = nWidth / 8;
        byte[] data = new byte[nHeight * (8 + nBytesPerLine)];
        int offset = 0;
        int k = 0;
        for (int i = 0; i < nHeight; ++i) {
            offset = i * (8 + nBytesPerLine);
            data[offset + 0] = 29;
            data[offset + 1] = 118;
            data[offset + 2] = 48;
            data[offset + 3] = (byte)(nMode & 1);
            data[offset + 4] = (byte)(nBytesPerLine % 256);
            data[offset + 5] = (byte)(nBytesPerLine / 256);
            data[offset + 6] = 1;
            data[offset + 7] = 0;
            for (int j = 0; j < nBytesPerLine; ++j) {
                data[offset + 8 + j] = (byte)((src[k] ? 128 : 0) | (src[k + 1] ? 64 : 0) | (src[k + 2] ? 32 : 0) | (src[k + 3] ? 16 : 0) | (src[k + 4] ? 8 : 0) | (src[k + 5] ? 4 : 0) | (src[k + 6] ? 2 : 0) | (src[k + 7] ? 1 : 0));
                k += 8;
            }
        }
        return data;
    }

    public static byte[] eachLinePixToCompressCmd(boolean[] src, int nWidth) {
        int nHeight = src.length / nWidth;
        int nBytesPerLine = nWidth / 8;
        byte[] data = new byte[nHeight * nBytesPerLine];
        int k = 0;
        for (int i = 0; i < nHeight; ++i) {
            for (int j = 0; j < nBytesPerLine; ++j) {
                data[i * nBytesPerLine + j] = (byte)((src[k] ? 128 : 0) | (src[k + 1] ? 64 : 0) | (src[k + 2] ? 32 : 0) | (src[k + 3] ? 16 : 0) | (src[k + 4] ? 8 : 0) | (src[k + 5] ? 4 : 0) | (src[k + 6] ? 2 : 0) | (src[k + 7] ? 1 : 0));
                k += 8;
            }
        }
        int compresseddatalen = 0;
        for (int y = 0; y < nHeight; ++y) {
            byte[] line = new byte[nBytesPerLine];
            System.arraycopy(data, y * nBytesPerLine, line, 0, nBytesPerLine);
            byte[] buf = ImageProcessing.CompressDataBuf(line);
            byte[] cmd = new byte[]{31, 40, 80, (byte)((long)buf.length & 0xFFL), (byte)(((long)buf.length & 0xFFFFL) >> 8)};
            compresseddatalen += cmd.length;
            compresseddatalen += buf.length;
        }
        byte[] compresseddatabytes = new byte[compresseddatalen];
        int offset = 0;
        for (int y = 0; y < nHeight; ++y) {
            byte[] line = new byte[nBytesPerLine];
            System.arraycopy(data, y * nBytesPerLine, line, 0, nBytesPerLine);
            byte[] buf = ImageProcessing.CompressDataBuf(line);
            byte[] cmd = new byte[]{31, 40, 80, (byte)((long)buf.length & 0xFFL), (byte)(((long)buf.length & 0xFFFFL) >> 8)};
            System.arraycopy(cmd, 0, compresseddatabytes, offset, cmd.length);
            System.arraycopy(buf, 0, compresseddatabytes, offset += cmd.length, buf.length);
            offset += buf.length;
        }
        return compresseddatabytes;
    }

    public static byte[] CompressDataBuf(byte[] src) {
        byte ch;
        int srclen = src.length;
        byte[] buf = new byte[srclen * 2];
        buf[0] = ch = src[0];
        int cnt = 1;
        int idx = 1;
        for (int i = 1; i < srclen; ++i) {
            while (src[i] == ch) {
                ++cnt;
                if (++i < srclen) continue;
            }
            if (i >= srclen) {
                buf[idx] = (byte)cnt;
                ++idx;
                break;
            }
            buf[idx] = (byte)cnt;
            buf[idx + 1] = ch = src[i];
            cnt = 1;
            idx += 2;
        }
        if (idx & true) {
            buf[idx] = (byte)cnt;
            ++idx;
        }
        if (idx >= srclen) {
            byte[] dst = new byte[srclen + 1];
            dst[0] = 0;
            System.arraycopy(src, 0, dst, 1, srclen);
            return dst;
        }
        byte[] dst = new byte[idx + 1];
        dst[0] = (byte)idx;
        System.arraycopy(buf, 0, dst, 1, idx);
        return dst;
    }

    public static void PicZoom_ThreeOrder0(int srcw, int srch, int[] src, int dstw, int dsth, int[] dst) {
        if (0 == dstw || 0 == dsth || 0 == srcw || 0 == srch) {
            return;
        }
        if (srcw == dstw && srch == dsth) {
            System.arraycopy(src, 0, dst, 0, src.length);
            return;
        }
        int k = 0;
        for (int y = 0; y < dsth; ++y) {
            double srcy = ((double)y + 0.4999999) * (double)srch / (double)dsth - 0.5;
            for (int x = 0; x < dstw; ++x) {
                double srcx = ((double)x + 0.4999999) * (double)srcw / (double)dstw - 0.5;
                dst[k++] = ImageProcessing.ThreeOrder0(srcw, srch, src, srcx, srcy);
            }
        }
    }

    static int ThreeOrder0(int srcw, int srch, int[] src, double fx, double fy) {
        int y0;
        int x0 = (int)fx;
        if ((double)x0 > fx) {
            --x0;
        }
        if ((double)(y0 = (int)fy) > fy) {
            --y0;
        }
        double fu = fx - (double)x0;
        double fv = fy - (double)y0;
        TARGB32[] pixel = new TARGB32[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                long x = x0 - 1 + j;
                long y = y0 - 1 + i;
                pixel[i * 4 + j] = ImageProcessing.Pixels_Bound(srcw, srch, src, x, y);
            }
        }
        double[] afu = new double[4];
        double[] afv = new double[4];
        afu[0] = ImageProcessing.SinXDivX(1.0 + fu);
        afu[1] = ImageProcessing.SinXDivX(fu);
        afu[2] = ImageProcessing.SinXDivX(1.0 - fu);
        afu[3] = ImageProcessing.SinXDivX(2.0 - fu);
        afv[0] = ImageProcessing.SinXDivX(1.0 + fv);
        afv[1] = ImageProcessing.SinXDivX(fv);
        afv[2] = ImageProcessing.SinXDivX(1.0 - fv);
        afv[3] = ImageProcessing.SinXDivX(2.0 - fv);
        float sR = 0.0f;
        float sG = 0.0f;
        float sB = 0.0f;
        float sA = 0.0f;
        for (int i = 0; i < 4; ++i) {
            float aR = 0.0f;
            float aG = 0.0f;
            float aB = 0.0f;
            float aA = 0.0f;
            for (int j = 0; j < 4; ++j) {
                aA = (float)((double)aA + afu[j] * (double)pixel[i * 4 + j].a);
                aR = (float)((double)aR + afu[j] * (double)pixel[i * 4 + j].r);
                aG = (float)((double)aG + afu[j] * (double)pixel[i * 4 + j].g);
                aB = (float)((double)aB + afu[j] * (double)pixel[i * 4 + j].b);
            }
            sA = (float)((double)sA + (double)aA * afv[i]);
            sR = (float)((double)sR + (double)aR * afv[i]);
            sG = (float)((double)sG + (double)aG * afv[i]);
            sB = (float)((double)sB + (double)aB * afv[i]);
        }
        byte a = (byte)ImageProcessing.border_color((long)((double)sA + 0.5));
        byte r = (byte)ImageProcessing.border_color((long)((double)sR + 0.5));
        byte g = (byte)ImageProcessing.border_color((long)((double)sG + 0.5));
        byte b = (byte)ImageProcessing.border_color((long)((double)sB + 0.5));
        return (int)(((long)a & 0xFFL) << 24 | ((long)r & 0xFFL) << 16 | ((long)g & 0xFFL) << 8 | ((long)b & 0xFFL) << 0);
    }

    static TARGB32 Pixels_Bound(int srcw, int srch, int[] src, long x, long y) {
        boolean IsInPic = true;
        if (x < 0L) {
            x = 0L;
            IsInPic = false;
        } else if (x >= (long)srcw) {
            x = srcw - 1;
            IsInPic = false;
        }
        if (y < 0L) {
            y = 0L;
            IsInPic = false;
        } else if (y >= (long)srch) {
            y = srch - 1;
            IsInPic = false;
        }
        TARGB32 result = ImageProcessing.Pixels(srcw, srch, src, x, y);
        if (!IsInPic) {
            result.a = 0;
        }
        return result;
    }

    static TARGB32 Pixels(int srcw, int srch, int[] src, long x, long y) {
        int pixel = src[(int)(y * (long)srcw + x)];
        return new TARGB32(pixel);
    }

    static double SinXDivX(double x) {
        float a = -1.0f;
        if (x < 0.0) {
            x = -x;
        }
        double x2 = x * x;
        double x3 = x2 * x;
        if (x <= 1.0) {
            return 1.0 * x3 - 2.0 * x2 + 1.0;
        }
        if (x <= 2.0) {
            return -1.0 * x3 - -5.0 * x2 + -8.0 * x - -4.0;
        }
        return 0.0;
    }

    static long border_color(long Color) {
        if (Color <= 0L) {
            return 0L;
        }
        if (Color >= 255L) {
            return 255L;
        }
        return Color;
    }

    public static byte[] GrayImage(int[] src) {
        int srclen = src.length;
        byte[] dst = new byte[srclen];
        for (int k = 0; k < srclen; ++k) {
            dst[k] = (byte)((((long)src[k] & 0xFF0000L) >> 16) * 19595L + (((long)src[k] & 0xFF00L) >> 8) * 38469L + (((long)src[k] & 0xFFL) >> 0) * 7472L >> 16);
        }
        return dst;
    }

    public static void ReverseBitmap(int srcw, int srch, int[] src) {
        int srclen = src.length;
        for (int i = 0; i < srclen; ++i) {
            src[i] = (int)(0xFF000000L | (long)src[i] & 0xFFFFFFL ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    static class TPicRegion {
        public int[] pdata;
        public int width;
        public int height;

        TPicRegion() {
        }
    }

    static class TARGB32 {
        public int b;
        public int g;
        public int r;
        public int a;

        public TARGB32(int argb) {
            this.a = (int)(((long)argb & 0xFFFFFFFFL) >> 24);
            this.r = (int)(((long)argb & 0xFFFFFFFFL) >> 16);
            this.g = (int)(((long)argb & 0xFFFFFFFFL) >> 8);
            this.b = (int)(((long)argb & 0xFFFFFFFFL) >> 0);
        }

        public int IntValue() {
            return (int)(((long)this.a & 0xFFL) << 24 | ((long)this.r & 0xFFL) << 16 | ((long)this.g & 0xFFL) << 8 | ((long)this.b & 0xFFL) << 0);
        }
    }
}

