/*
 * Decompiled with CFR 0.152.
 */
package com.brightek.whdrawlabel;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import com.brightek.whdrawlabel.CreateBarCode;
import com.brightek.whdrawlabel.WHDrawCodeType;
import com.brightek.whdrawlabel.WHDrawItem;
import com.brightek.whdrawlabel.WHDrawType;
import java.util.ArrayList;
import java.util.List;

public class WHDrawLabelManager {
    private static volatile WHDrawLabelManager instance = null;
    private List<Byte> byteListHeaderCMD = new ArrayList<Byte>();
    private List<Byte> byteListEndCMD = new ArrayList<Byte>();
    private List<WHDrawItem> listDrawItem = new ArrayList<WHDrawItem>();
    private int dotWidth = 384;
    private int dotHeight = 384;
    private boolean fontBold = false;
    private boolean fontUnderLine = false;
    private boolean fontDeleteLine = false;
    private boolean fontItalic = false;

    private WHDrawLabelManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WHDrawLabelManager getInstance() {
        if (instance != null) return instance;
        Class<WHDrawLabelManager> clazz = WHDrawLabelManager.class;
        synchronized (WHDrawLabelManager.class) {
            if (instance != null) return instance;
            instance = new WHDrawLabelManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void createNewLabel(int width, int height) {
        this.dotWidth = width;
        this.dotHeight = height;
        this.clearLabel();
    }

    public void clearLabel() {
        this.clearItem();
        this.resetCMD();
    }

    public void resetCMD() {
        this.clearCMDHeader();
        this.clearCMDEnd();
    }

    public void addCMDtoHeader(byte[] cmd) {
        for (byte b : cmd) {
            this.byteListHeaderCMD.add(b);
        }
    }

    public void clearCMDHeader() {
        this.byteListHeaderCMD.clear();
    }

    public void addCMDtoEnd(byte[] cmd) {
        for (byte b : cmd) {
            this.byteListEndCMD.add(b);
        }
    }

    public void clearCMDEnd() {
        this.byteListEndCMD.clear();
    }

    public void setFontBold(boolean bold) {
        this.fontBold = bold;
    }

    public void setFontUnderLine(boolean underLine) {
        this.fontUnderLine = underLine;
    }

    public void setFontDeleteLine(boolean deleteLine) {
        this.fontDeleteLine = deleteLine;
    }

    private void setFontItalic(boolean italic) {
        this.fontItalic = italic;
    }

    public void addText(float x, float y, float fontSize, String text) {
        WHDrawItem item = new WHDrawItem();
        item.setType(WHDrawType.DrawText);
        item.setPosX(x);
        item.setPosY(y);
        item.setText(text);
        item.setFontSizePixel(fontSize);
        item.setFontBold(this.fontBold);
        item.setFontUnderLine(this.fontUnderLine);
        item.setFontDeleteLine(this.fontDeleteLine);
        item.setFontItalic(this.fontItalic);
        this.addItem(item);
    }

    public void addBarCode(WHDrawCodeType code, float x, float y, int width, int height, String text) {
        this.addCode(WHDrawType.DrawBarCode, code, x, y, width, height, text);
    }

    public void addQrCode(WHDrawCodeType code, float x, float y, int width, int height, String text) {
        this.addCode(WHDrawType.DrawQrCode, code, x, y, width, height, text);
    }

    public void addLine(float x, float y, float x_end, float y_end, int lineSize) {
        WHDrawItem item = new WHDrawItem();
        item.setType(WHDrawType.DrawLine);
        item.setPosX(x);
        item.setPosY(y);
        item.setPosXEnd(x_end);
        item.setPosYEnd(y_end);
        item.setLineSize(lineSize);
        this.addItem(item);
    }

    public void addBitmap(float x, float y, float width, float height, Bitmap bitmap) {
        WHDrawItem item = new WHDrawItem();
        item.setType(WHDrawType.DrawBitmap);
        item.setPosX(x);
        item.setPosY(y);
        item.setItemWidth(width);
        item.setItemHeight(height);
        item.setBitmap(bitmap);
        this.addItem(item);
    }

    private void addCode(WHDrawType type, WHDrawCodeType barcode, float x, float y, int width, int height, String text) {
        WHDrawItem item = new WHDrawItem();
        item.setType(type);
        item.setPosX(x);
        item.setPosY(y);
        item.setText(text);
        item.setItemWidth(width);
        item.setItemHeight(height);
        item.setCodeType(barcode);
        this.addItem(item);
    }

    private void addItem(WHDrawItem item) {
        this.listDrawItem.add(item);
    }

    private void clearItem() {
        this.listDrawItem.clear();
    }

    public Bitmap getBitmap() {
        if (this.dotWidth < 8) {
            this.dotWidth = 384;
        }
        if (this.dotHeight < 8) {
            this.dotHeight = 384;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.dotWidth, (int)this.dotHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint photoPaint = new Paint();
        photoPaint.setColor(-1);
        canvas.drawRect(0.0f, 0.0f, (float)this.dotWidth, (float)this.dotHeight, photoPaint);
        for (WHDrawItem item : this.listDrawItem) {
            float fontSize = item.getFontSizePixel();
            Paint pFont = new Paint();
            pFont.setColor(-16777216);
            pFont.setAntiAlias(true);
            if (item.getType() == WHDrawType.DrawText) {
                if (item.isFontBold()) {
                    Typeface typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)1);
                    pFont.setTypeface(typeface);
                }
                if (item.isFontDeleteLine()) {
                    pFont.setStrikeThruText(true);
                }
                if (item.isFontUnderLine()) {
                    pFont.setUnderlineText(true);
                }
                pFont.setTextSize(fontSize);
                pFont.setTextAlign(Paint.Align.LEFT);
                canvas.drawText(item.getText(), item.getPosX(), item.getPosY(), pFont);
                continue;
            }
            if (item.getType() == WHDrawType.DrawLine) {
                pFont.setStrokeWidth(item.getLineSize());
                canvas.drawLine(item.getPosX(), item.getPosY(), item.getPosXEnd(), item.getPosYEnd(), pFont);
                continue;
            }
            Bitmap bitmap1 = null;
            if (item.getType() == WHDrawType.DrawBitmap) {
                Bitmap bitmapOld = item.getBitmap();
                if (bitmapOld != null) {
                    bitmap1 = Bitmap.createBitmap((Bitmap)bitmapOld, (int)0, (int)0, (int)((int)item.getItemWidth()), (int)((int)item.getItemHeight()));
                }
            } else {
                bitmap1 = CreateBarCode.createQRCode(item.getCodeType().getBarType(), item.getText(), (int)item.getItemWidth(), (int)item.getItemHeight());
            }
            if (bitmap1 == null) continue;
            canvas.drawBitmap(bitmap1, item.getPosX(), item.getPosY(), pFont);
        }
        canvas.save();
        canvas.restore();
        return bitmap;
    }

    public byte[] getPrintData() {
        Bitmap bitmap = this.getBitmap();
        bitmap = this.convertGreyImgByBW(bitmap);
        byte[] bytesBit = WHDrawLabelManager.Command_1b4b(bitmap, true);
        int len = bytesBit.length + this.byteListHeaderCMD.size() + this.byteListEndCMD.size();
        ArrayList<Byte> listRet = new ArrayList<Byte>();
        listRet.addAll(this.byteListHeaderCMD);
        for (byte b : bytesBit) {
            listRet.add(b);
        }
        listRet.addAll(this.byteListEndCMD);
        return WHDrawLabelManager.ListByteToBytes(listRet);
    }

    private Bitmap convertGreyImgByBW(Bitmap img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int grey = pixels[width * i + j];
                int red = (grey & 0xFF0000) >> 16;
                int green = (grey & 0xFF00) >> 8;
                int blue = grey & 0xFF;
                int newBit = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                pixels[width * i + j] = newBit < 128 ? -16777216 : -1;
            }
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    private List<List<Byte>> CommandSerial_1b4b(Bitmap bitmap, boolean addReturnEveryLine) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        ArrayList<Byte> listData = new ArrayList<Byte>();
        ArrayList<List<Byte>> listReturn = new ArrayList<List<Byte>>();
        int xWidth = (width + 7) / 8;
        int xHeight = (height + 7) / 8;
        int posHeight = 0;
        boolean k = false;
        for (int i = 0; i < xHeight; ++i) {
            listData.clear();
            listData.add((byte)27);
            listData.add((byte)75);
            listData.add((byte)(width % 256));
            listData.add((byte)(width / 256));
            for (int x = 0; x < width; ++x) {
                int b = 0;
                byte bDot = 0;
                for (int n = 0; n < 8; ++n) {
                    int pixel;
                    posHeight = 8 * i + n;
                    b = posHeight >= height ? 0 : ((pixel = bitmap.getPixel(x, posHeight)) == -1 ? 0 : 1);
                    bDot = (byte)(b << 7 - n | bDot);
                }
                listData.add(bDot);
            }
            if (addReturnEveryLine) {
                listData.add((byte)13);
            }
            listReturn.add(listData);
        }
        return listReturn;
    }

    private static byte[] Command_1b4b(Bitmap bitmap, boolean addReturnEveryLine) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int length = width / 8 * height + 8 * height;
        ArrayList<Byte> listData = new ArrayList<Byte>();
        int xWidth = (width + 7) / 8;
        int xHeight = (height + 7) / 8;
        int posHeight = 0;
        boolean k = false;
        for (int i = 0; i < xHeight; ++i) {
            listData.add((byte)27);
            listData.add((byte)75);
            listData.add((byte)(width % 256));
            listData.add((byte)(width / 256));
            for (int x = 0; x < width; ++x) {
                int b = 0;
                byte bDot = 0;
                for (int n = 0; n < 8; ++n) {
                    int pixel;
                    posHeight = 8 * i + n;
                    b = posHeight >= height ? 0 : ((pixel = bitmap.getPixel(x, posHeight)) == -1 ? 0 : 1);
                    bDot = (byte)(b << 7 - n | bDot);
                }
                listData.add(bDot);
            }
            if (!addReturnEveryLine) continue;
            listData.add((byte)13);
        }
        return WHDrawLabelManager.ListByteToBytes(listData);
    }

    private static byte[] ListByteToBytes(List<Byte> listData) {
        if (listData.isEmpty()) {
            return new byte[]{10};
        }
        byte[] retData = new byte[listData.size()];
        int i = 0;
        for (byte b : listData) {
            retData[i++] = b;
        }
        return retData;
    }
}

