/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.wifi.ble;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import com.feasycom.encrypted.controler.FscEncryptApi;
import com.feasycom.encrypted.controler.FscEncryptApiImp;
import com.feasycom.wifi.bean.BluetoothDeviceWrapper;
import com.feasycom.wifi.bean.FeasyBeacon;
import com.feasycom.wifi.ble.FscBleCentralApi;
import com.feasycom.wifi.ble.FscBleCentralCallbacks;
import com.feasycom.wifi.ble.FscBleCentralCallbacksImp;
import com.feasycom.wifi.ble.FscNetworkCentralCallbacks;
import com.feasycom.wifi.ble.FscOtaCentralCallbacks;
import com.feasycom.wifi.utils.LogUtil;
import com.feasycom.wifi.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class FscBleCentralApiImp
implements FscBleCentralApi {
    private static final String TAG = "FscBleCentralApiImp";
    private static FscBleCentralApiImp instance;
    private static Context mContext;
    private String ipRegex;
    private String otaName;
    private final int SCAN_TIME_OUT;
    public Runnable stopScanRunnable;
    private ScanCallback mScanCallback;
    private ScanSettings mScanSettings;
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothDevice mBluetoothDevice;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothGattCharacteristic mWriteCharacteristic;
    private FscBleCentralCallbacks mUiCallback;
    private FscNetworkCentralCallbacks mFscNetworkCentralCallbacks;
    private FscOtaCentralCallbacks mOtaCentralCallbacks;
    private boolean isBeacon;
    private boolean isPinError;
    private final int maxConnectCount;
    private int connectCount;
    private byte[] take;
    private int maxPackgeSize;
    private final Handler sHandler;
    private FscEncryptApi mFeasycomApiImp;
    private String receivePasswordInfo;
    private byte[] sendPasswordInfo;
    private boolean isAtCommand;
    private final UUID SERVER_UUID;
    private final UUID NOTIFY_CHARA_UUID;
    private final UUID WRITE_CHARA_UUID;
    public Runnable runnable;
    public Runnable r;
    public Runnable otaFailRunnable;
    public Runnable mRunnable;
    private final BluetoothAdapter.LeScanCallback mDeviceFoundCallback;
    private final BluetoothGattCallback mBleCallback;
    private final Runnable atCommandOut;
    @Keep
    public Runnable mOnConnectTimeoutCallback;

    private void logInfoIfCompile(Object object) {
        LogUtil.i(TAG, object.toString());
    }

    private FscBleCentralApiImp() {
        FscBleCentralApiImp fscBleCentralApiImp = this;
        fscBleCentralApiImp.ipRegex = "((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))";
        fscBleCentralApiImp.SCAN_TIME_OUT = 15000;
        fscBleCentralApiImp.stopScanRunnable = () -> {
            Log.e((String)TAG, (String)"ly: \u505c\u6b62\u626b\u63cf\u5b9a\u65f6\u5668\u751f\u6548");
            this.stopScan();
        };
        fscBleCentralApiImp.mWriteCharacteristic = null;
        fscBleCentralApiImp.isBeacon = false;
        fscBleCentralApiImp.isPinError = false;
        fscBleCentralApiImp.maxConnectCount = 5;
        fscBleCentralApiImp.take = new byte[0];
        fscBleCentralApiImp.maxPackgeSize = 0;
        fscBleCentralApiImp.sHandler = new Handler(Looper.getMainLooper());
        fscBleCentralApiImp.isAtCommand = false;
        fscBleCentralApiImp.SERVER_UUID = UUID.fromString("0000fff0-0000-1000-8000-00805f9b34fb");
        fscBleCentralApiImp.NOTIFY_CHARA_UUID = UUID.fromString("0000fff1-0000-1000-8000-00805f9b34fb");
        fscBleCentralApiImp.WRITE_CHARA_UUID = UUID.fromString("0000fff2-0000-1000-8000-00805f9b34fb");
        fscBleCentralApiImp.runnable = () -> {
            if (this.isBeacon) {
                this.isPinError = false;
            }
            Log.e((String)TAG, (String)"\u65ad\u5f00\u8fde\u63a5 1");
            this.disconnect();
        };
        fscBleCentralApiImp.r = new Runnable(){

            @Override
            public void run() {
                a a2 = this;
                Log.e((String)FscBleCentralApiImp.TAG, (String)"run: \u83b7\u53d6ip");
                a2.FscBleCentralApiImp.this.getIp();
                a2.FscBleCentralApiImp.this.sHandler.postDelayed((Runnable)this, 1000L);
            }
        };
        fscBleCentralApiImp.otaFailRunnable = () -> {
            FscOtaCentralCallbacks fscOtaCentralCallbacks = this.mOtaCentralCallbacks;
            if (fscOtaCentralCallbacks != null) {
                fscOtaCentralCallbacks.onOtaFailure();
                this.mOtaCentralCallbacks = null;
            }
        };
        fscBleCentralApiImp.mRunnable = () -> {
            FscBleCentralApiImp fscBleCentralApiImp = this;
            Log.e((String)TAG, (String)"\u53d6\u6d88\u83b7\u53d6ip\u7684\u5b9a\u65f6\u5668");
            fscBleCentralApiImp.sHandler.removeCallbacks(this.r);
            FscNetworkCentralCallbacks fscNetworkCentralCallbacks = fscBleCentralApiImp.mFscNetworkCentralCallbacks;
            if (fscNetworkCentralCallbacks != null) {
                fscNetworkCentralCallbacks.failure();
                this.mFscNetworkCentralCallbacks = null;
            }
        };
        fscBleCentralApiImp.mDeviceFoundCallback = new BluetoothAdapter.LeScanCallback(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onLeScan(BluetoothDevice object, int n, byte[] byArray) {
                Throwable throwable2;
                BluetoothDeviceWrapper bluetoothDeviceWrapper;
                block6: {
                    BluetoothDeviceWrapper bluetoothDeviceWrapper2;
                    bluetoothDeviceWrapper = bluetoothDeviceWrapper2;
                    bluetoothDeviceWrapper2 = new BluetoothDeviceWrapper((BluetoothDevice)object, n);
                    object = Utils.getBeacon(byArray);
                    if (object != null) {
                        bluetoothDeviceWrapper.setBeacon((FeasyBeacon)object);
                    }
                    bluetoothDeviceWrapper.setLocationName(Utils.getLocationName(byArray));
                    FscBleCentralApiImp.this.mUiCallback.blePeripheralFound(bluetoothDeviceWrapper, n, byArray);
                    return;
                    {
                        catch (Throwable throwable2) {
                            break block6;
                        }
                        catch (Exception exception) {}
                        {
                            exception.printStackTrace();
                            FscBleCentralApiImp.this.mUiCallback.blePeripheralFound(bluetoothDeviceWrapper, n, byArray);
                        }
                    }
                    return;
                }
                FscBleCentralApiImp.this.mUiCallback.blePeripheralFound(bluetoothDeviceWrapper, n, byArray);
                throw throwable2;
            }
        };
        fscBleCentralApiImp.mBleCallback = new BluetoothGattCallback(){

            @SuppressLint(value={"MissingPermission"})
            public void onMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
                super.onMtuChanged(bluetoothGatt, n, n2);
                bluetoothGatt.discoverServices();
                FscBleCentralApiImp.access$202(FscBleCentralApiImp.this, n - 3);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @SuppressLint(value={"MissingPermission"})
            public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
                Exception exception2;
                block13: {
                    FscBleCentralApiImp fscBleCentralApiImp;
                    block14: {
                        block12: {
                            block9: {
                                BluetoothGatt bluetoothGatt2;
                                FscBleCentralApiImp fscBleCentralApiImp2;
                                block11: {
                                    block10: {
                                        d d2 = this;
                                        super.onConnectionStateChange(bluetoothGatt, n, n2);
                                        d2.FscBleCentralApiImp.this.sHandler.removeCallbacks(FscBleCentralApiImp.this.runnable);
                                        d2.FscBleCentralApiImp.this.logInfoIfCompile("status: " + n + ",newState: " + n2);
                                        Log.e((String)FscBleCentralApiImp.TAG, (String)("status: " + n + ",newState: " + n2));
                                        if (n == 133) {
                                            bluetoothGatt.close();
                                        }
                                        if (n2 == 2) {
                                            if (Build.VERSION.SDK_INT >= 21) {
                                                bluetoothGatt.requestMtu(185);
                                                return;
                                            }
                                            bluetoothGatt.discoverServices();
                                            return;
                                        }
                                        if (n2 != 0) return;
                                        d d3 = this;
                                        d3.FscBleCentralApiImp.this.sHandler.removeCallbacks(FscBleCentralApiImp.this.r);
                                        d3.FscBleCentralApiImp.this.sHandler.removeCallbacks(FscBleCentralApiImp.this.mRunnable);
                                        FscBleCentralApiImp.access$402(d3.FscBleCentralApiImp.this, null);
                                        FscBleCentralApiImp.access$502(d3.FscBleCentralApiImp.this, null);
                                        if (n == 133) {
                                            FscBleCentralApiImp.this.sHandler.post(() -> {
                                                d d2 = this;
                                                d2.FscBleCentralApiImp.this.close(bluetoothGatt);
                                                d2.FscBleCentralApiImp.this.sHandler.postDelayed(() -> {
                                                    if (FscBleCentralApiImp.this.connectCount <= 5) {
                                                        FscBleCentralApiImp.this.connectCount++;
                                                        if (Build.VERSION.SDK_INT >= 23) {
                                                            FscBleCentralApiImp fscBleCentralApiImp = FscBleCentralApiImp.this;
                                                            FscBleCentralApiImp.access$702(fscBleCentralApiImp, fscBleCentralApiImp.mBluetoothDevice.connectGatt(mContext, false, FscBleCentralApiImp.this.mBleCallback, 2));
                                                        } else {
                                                            FscBleCentralApiImp fscBleCentralApiImp = FscBleCentralApiImp.this;
                                                            FscBleCentralApiImp.access$702(fscBleCentralApiImp, fscBleCentralApiImp.mBluetoothDevice.connectGatt(mContext, false, FscBleCentralApiImp.this.mBleCallback));
                                                        }
                                                    } else {
                                                        FscBleCentralApiImp.this.closeBluetooth(bluetoothGatt);
                                                    }
                                                }, 200L);
                                            });
                                            return;
                                        }
                                        if (n != 22) break block12;
                                        try {
                                            d d4 = this;
                                            d4.FscBleCentralApiImp.this.close(bluetoothGatt);
                                            if (d4.FscBleCentralApiImp.this.connectCount > 5) break block9;
                                            FscBleCentralApiImp.this.connectCount++;
                                        }
                                        catch (Exception exception2) {}
                                        if (Build.VERSION.SDK_INT < 23) break block10;
                                        FscBleCentralApiImp fscBleCentralApiImp3 = FscBleCentralApiImp.this;
                                        fscBleCentralApiImp2 = fscBleCentralApiImp3;
                                        boolean bl = false;
                                        bluetoothGatt2 = fscBleCentralApiImp3.mBluetoothDevice.connectGatt(mContext, bl, FscBleCentralApiImp.this.mBleCallback, 2);
                                        break block11;
                                    }
                                    FscBleCentralApiImp fscBleCentralApiImp4 = FscBleCentralApiImp.this;
                                    fscBleCentralApiImp2 = fscBleCentralApiImp4;
                                    boolean bl = false;
                                    bluetoothGatt2 = fscBleCentralApiImp4.mBluetoothDevice.connectGatt(mContext, bl, FscBleCentralApiImp.this.mBleCallback);
                                    break block13;
                                }
                                FscBleCentralApiImp.access$702(fscBleCentralApiImp2, bluetoothGatt2);
                                return;
                            }
                            fscBleCentralApiImp = FscBleCentralApiImp.this;
                            break block14;
                        }
                        fscBleCentralApiImp = FscBleCentralApiImp.this;
                    }
                    fscBleCentralApiImp.closeBluetooth(bluetoothGatt);
                    return;
                }
                exception2.printStackTrace();
            }

            public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
                super.onServicesDiscovered(bluetoothGatt, n);
                if (n == 0) {
                    d d2 = this;
                    d2.FscBleCentralApiImp.this.getSupportedServices(bluetoothGatt);
                    d2.FscBleCentralApiImp.this.mWriteCharacteristic.setValue(FscBleCentralApiImp.this.sendPasswordInfo);
                    d2.FscBleCentralApiImp.this.sHandler.postDelayed(FscBleCentralApiImp.this.mOnConnectTimeoutCallback, 6000L);
                    new Thread(() -> {
                        try {
                            while (FscBleCentralApiImp.this.isDeviceBusy()) {
                                Thread.sleep(6L);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        FscBleCentralApiImp fscBleCentralApiImp = FscBleCentralApiImp.this;
                        fscBleCentralApiImp.writeCharacteristic(fscBleCentralApiImp.mWriteCharacteristic);
                    }).start();
                }
            }

            public void onCharacteristicChanged(BluetoothGatt object, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                String string;
                d d2 = d10;
                super.onCharacteristicChanged(object, bluetoothGattCharacteristic);
                String string2 = string;
                string = new String(bluetoothGattCharacteristic.getValue());
                Log.e((String)FscBleCentralApiImp.TAG, (String)("onCharacteristicChanged: \u6536\u5230\u6570\u636e " + string2));
                if (d2.FscBleCentralApiImp.this.receivePasswordInfo == null) {
                    if (d10.FscBleCentralApiImp.this.mFeasycomApiImp.verifyEncrypted(bluetoothGattCharacteristic.getValue())) {
                        d d3 = d10;
                        FscBleCentralApiImp.access$1502(d3.FscBleCentralApiImp.this, string2);
                        d3.FscBleCentralApiImp.this.sHandler.postDelayed(d10.FscBleCentralApiImp.this.atCommandOut, 5000L);
                        d3.FscBleCentralApiImp.this.mWriteCharacteristic.setValue("$OpenFscAtEngine$");
                        FscBleCentralApiImp fscBleCentralApiImp = d3.FscBleCentralApiImp.this;
                        fscBleCentralApiImp.writeCharacteristic(fscBleCentralApiImp.mWriteCharacteristic);
                    } else {
                        d10.FscBleCentralApiImp.this.disconnect();
                    }
                } else if ("$OK,Opened$".equals(string2)) {
                    d d4 = d10;
                    FscBleCentralApiImp.access$1902(d4.FscBleCentralApiImp.this, true);
                    BluetoothGatt bluetoothGatt = object;
                    d4.FscBleCentralApiImp.this.mUiCallback.blePeripheralConnected(bluetoothGatt, bluetoothGatt.getDevice());
                } else {
                    String string3 = FscBleCentralApiImp.toHexString(bluetoothGattCharacteristic.getValue());
                    if (d10.FscBleCentralApiImp.this.mOtaCentralCallbacks != null) {
                        if (string2.contains("+LIP=")) {
                            if (string2.split("=")[1].split("\r\n")[0].equals("0.0.0.0")) {
                                d d5 = d10;
                                d5.FscBleCentralApiImp.this.mOtaCentralCallbacks.onOtaNetworkIsNotConfigured();
                                FscBleCentralApiImp.access$402(d5.FscBleCentralApiImp.this, null);
                            } else {
                                Log.e((String)FscBleCentralApiImp.TAG, (String)("onCharacteristicChanged otaName ->" + d10.FscBleCentralApiImp.this.otaName));
                                if (d10.FscBleCentralApiImp.this.otaName.matches(d10.FscBleCentralApiImp.this.ipRegex)) {
                                    FscBleCentralApiImp fscBleCentralApiImp = d10.FscBleCentralApiImp.this;
                                    fscBleCentralApiImp.ota(fscBleCentralApiImp.otaName);
                                } else {
                                    FscBleCentralApiImp fscBleCentralApiImp = d10.FscBleCentralApiImp.this;
                                    fscBleCentralApiImp.otaDFU(fscBleCentralApiImp.otaName);
                                }
                                d d6 = d10;
                                d6.FscBleCentralApiImp.this.mOtaCentralCallbacks.onOtaStartConfig();
                                d6.FscBleCentralApiImp.this.sHandler.postDelayed(d10.FscBleCentralApiImp.this.otaFailRunnable, 60000L);
                            }
                        } else if (string2.contains("$OTA=1")) {
                            d d7 = d10;
                            d7.FscBleCentralApiImp.this.sHandler.removeCallbacks(d10.FscBleCentralApiImp.this.otaFailRunnable);
                            d7.FscBleCentralApiImp.this.mOtaCentralCallbacks.onOtaSuccess();
                            FscBleCentralApiImp.access$402(d7.FscBleCentralApiImp.this, null);
                        } else if (string2.contains("$OTA=0")) {
                            d d8 = d10;
                            d8.FscBleCentralApiImp.this.sHandler.removeCallbacks(d10.FscBleCentralApiImp.this.otaFailRunnable);
                            d8.FscBleCentralApiImp.this.mOtaCentralCallbacks.onOtaFailure();
                            FscBleCentralApiImp.access$402(d8.FscBleCentralApiImp.this, null);
                        } else if (string2.contains("$PROGRESS")) {
                            d10.FscBleCentralApiImp.this.mOtaCentralCallbacks.onOtaProgress(string2.split("=")[1].split("\r\n")[0]);
                        }
                    } else if (d10.FscBleCentralApiImp.this.mFscNetworkCentralCallbacks != null) {
                        if (string2.contains("+LIP=") && !(object = string2.split("=")[1].split("\r\n")[0]).equals("0.0.0.0")) {
                            d d9 = d10;
                            d9.FscBleCentralApiImp.this.sHandler.removeCallbacks(d10.FscBleCentralApiImp.this.r);
                            d9.FscBleCentralApiImp.this.sHandler.removeCallbacks(d10.FscBleCentralApiImp.this.mRunnable);
                            d9.FscBleCentralApiImp.this.mFscNetworkCentralCallbacks.success((String)object);
                            FscBleCentralApiImp.access$502(d9.FscBleCentralApiImp.this, null);
                        }
                    } else {
                        if (string2.contains("+LIP=")) {
                            String string4 = string2.split("=")[1].split("\r\n")[0];
                            d10.FscBleCentralApiImp.this.mUiCallback.ipInformation(string4);
                        } else if (string2.contains("+VER")) {
                            d10.FscBleCentralApiImp.this.mUiCallback.versionInformation(string2.split("=")[1].split("\r\n")[0]);
                        }
                        d d10 = object.getDevice();
                        object = bluetoothGattCharacteristic.getValue();
                        d10.FscBleCentralApiImp.this.mUiCallback.packetReceived((BluetoothDevice)d10, string2, string3, (byte[])object);
                    }
                }
            }

            public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic object, int n) {
                d d2 = object2;
                super.onCharacteristicWrite(bluetoothGatt, object, n);
                Object object2 = FscBleCentralApiImp.toHexString(object.getValue());
                BluetoothGattCharacteristic bluetoothGattCharacteristic = object;
                bluetoothGatt = bluetoothGatt.getDevice();
                object = bluetoothGattCharacteristic.getStringValue(0);
                byte[] byArray = bluetoothGattCharacteristic.getValue();
                d2.FscBleCentralApiImp.this.mUiCallback.packetSend((BluetoothDevice)bluetoothGatt, (String)object, (String)object2, byArray);
            }
        };
        fscBleCentralApiImp.atCommandOut = () -> {
            if (!this.isAtCommand) {
                this.disconnect();
            }
        };
        fscBleCentralApiImp.mOnConnectTimeoutCallback = new Runnable(){

            @Override
            public void run() {
                if (FscBleCentralApiImp.this.receivePasswordInfo == null) {
                    FscBleCentralApiImp.this.disconnect();
                }
            }
        };
        if (Build.VERSION.SDK_INT >= 21) {
            FscBleCentralApiImp fscBleCentralApiImp2 = this;
            fscBleCentralApiImp2.mScanCallback = new ScanCallback(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onScanResult(int n, ScanResult scanResult) {
                    Throwable throwable2;
                    BluetoothDeviceWrapper bluetoothDeviceWrapper;
                    byte[] byArray;
                    int n2;
                    block6: {
                        BluetoothDeviceWrapper bluetoothDeviceWrapper2;
                        ScanResult scanResult2 = scanResult;
                        super.onScanResult(n, scanResult);
                        Object object = scanResult2.getDevice();
                        n2 = scanResult2.getRssi();
                        byArray = scanResult2.getScanRecord().getBytes();
                        bluetoothDeviceWrapper = bluetoothDeviceWrapper2;
                        bluetoothDeviceWrapper2 = new BluetoothDeviceWrapper((BluetoothDevice)object, n2);
                        object = Utils.getBeacon(byArray);
                        if (object != null) {
                            bluetoothDeviceWrapper.setBeacon((FeasyBeacon)object);
                        }
                        bluetoothDeviceWrapper.setLocationName(Utils.getLocationName(byArray));
                        FscBleCentralApiImp.this.mUiCallback.blePeripheralFound(bluetoothDeviceWrapper, n2, byArray);
                        return;
                        {
                            catch (Throwable throwable2) {
                                break block6;
                            }
                            catch (Exception exception) {}
                            {
                                exception.printStackTrace();
                                FscBleCentralApiImp.this.mUiCallback.blePeripheralFound(bluetoothDeviceWrapper, n2, byArray);
                            }
                        }
                        return;
                    }
                    FscBleCentralApiImp.this.mUiCallback.blePeripheralFound(bluetoothDeviceWrapper, n2, byArray);
                    throw throwable2;
                }

                public void onBatchScanResults(List<ScanResult> list) {
                    super.onBatchScanResults(list);
                }

                public void onScanFailed(int n) {
                    super.onScanFailed(n);
                }
            };
            fscBleCentralApiImp2.mScanSettings = new ScanSettings.Builder().setScanMode(2).setReportDelay(0L).build();
        }
    }

    public static FscBleCentralApiImp getInstance() {
        if (instance == null) {
            instance = new FscBleCentralApiImp();
        }
        return instance;
    }

    public static FscBleCentralApiImp getInstance(Context context) {
        mContext = context;
        if (instance == null) {
            instance = new FscBleCentralApiImp();
        }
        return instance;
    }

    private boolean isDeviceBusy() {
        Field field = this.mBluetoothGatt.getClass().getDeclaredField("mDeviceBusy");
        field.setAccessible(true);
        return (Boolean)field.get(this.mBluetoothGatt);
    }

    private void closeBluetooth(BluetoothGatt bluetoothGatt) {
        FscBleCentralApiImp fscBleCentralApiImp = fscBleCentralApiImp3;
        BluetoothGatt bluetoothGatt2 = bluetoothGatt;
        fscBleCentralApiImp3.isBeacon = false;
        fscBleCentralApiImp3.isPinError = false;
        fscBleCentralApiImp3.sHandler.removeCallbacks(fscBleCentralApiImp3.mOnConnectTimeoutCallback);
        FscBleCentralApiImp.bluetoothGattRefresh(bluetoothGatt2);
        fscBleCentralApiImp.close(bluetoothGatt2);
        fscBleCentralApiImp.take = null;
        fscBleCentralApiImp.mWriteCharacteristic = null;
        fscBleCentralApiImp.mBluetoothDevice = null;
        FscBleCentralApiImp fscBleCentralApiImp2 = fscBleCentralApiImp3;
        FscBleCentralApiImp fscBleCentralApiImp3 = bluetoothGatt.getDevice();
        fscBleCentralApiImp.mUiCallback.blePeripheralDisconnected(bluetoothGatt, (BluetoothDevice)fscBleCentralApiImp3, fscBleCentralApiImp2.isPinError);
    }

    private void unpairDevice(BluetoothDevice bluetoothDevice) {
        Class<?> clazz = bluetoothDevice.getClass();
        Method method = clazz.getMethod("removeBond", null);
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        method.setAccessible(true);
        try {
            method.invoke((Object)bluetoothDevice2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getSupportedServices(BluetoothGatt object) {
        BluetoothGattService bluetoothGattService = object.getService(fscBleCentralApiImp2.SERVER_UUID);
        if (bluetoothGattService == null) {
            for (BluetoothGattService bluetoothGattService2 : object.getServices()) {
                if (bluetoothGattService2 == null || "180a".equals(bluetoothGattService2.getUuid().toString().substring(4, 8).toLowerCase(Locale.ROOT))) continue;
                fscBleCentralApiImp2.getFeasycomCharacteristic((BluetoothGatt)object, bluetoothGattService2);
            }
        } else {
            FscBleCentralApiImp fscBleCentralApiImp = fscBleCentralApiImp2;
            BluetoothGatt bluetoothGatt = object;
            fscBleCentralApiImp2.mWriteCharacteristic = bluetoothGattService.getCharacteristic(fscBleCentralApiImp2.WRITE_CHARA_UUID);
            FscBleCentralApiImp fscBleCentralApiImp2 = bluetoothGattService.getCharacteristic(fscBleCentralApiImp2.NOTIFY_CHARA_UUID);
            object = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
            fscBleCentralApiImp.updateGattDescriptor(bluetoothGatt, (BluetoothGattCharacteristic)fscBleCentralApiImp2, true, (byte[])object);
        }
    }

    private void getFeasycomCharacteristic(BluetoothGatt bluetoothGatt, BluetoothGattService bluetoothGattService) {
        BluetoothGattService bluetoothGattService2 = bluetoothGattService;
        bluetoothGattService = null;
        BluetoothGattCharacteristic bluetoothGattCharacteristic = null;
        for (BluetoothGattCharacteristic bluetoothGattCharacteristic2 : bluetoothGattService2.getCharacteristics()) {
            block7: {
                block6: {
                    if (bluetoothGattCharacteristic2 != null) {
                        try {
                            int n = bluetoothGattCharacteristic2.getProperties();
                            if ((n & 0x10) != 0) {
                                bluetoothGattCharacteristic = bluetoothGattCharacteristic2;
                            }
                            if ((n & 8) == 0) break block6;
                            break block7;
                        }
                        catch (NullPointerException nullPointerException) {
                            nullPointerException.printStackTrace();
                        }
                    }
                }
                bluetoothGattCharacteristic2 = bluetoothGattService;
            }
            bluetoothGattService = bluetoothGattCharacteristic2;
        }
        if (bluetoothGattService != null && bluetoothGattCharacteristic != null) {
            FscBleCentralApiImp fscBleCentralApiImp = object;
            Object object = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
            fscBleCentralApiImp.updateGattDescriptor(bluetoothGatt, bluetoothGattCharacteristic, true, (byte[])object);
            fscBleCentralApiImp.mWriteCharacteristic = bluetoothGattService;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void updateGattDescriptor(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl, byte[] byArray) {
        if (!((FscBleCentralApiImp)object).mBluetoothGatt.setCharacteristicNotification(bluetoothGattCharacteristic, bl)) {
            return;
        }
        Object object = bluetoothGattCharacteristic.getDescriptors();
        if (object != null && object.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                BluetoothGattDescriptor bluetoothGattDescriptor = (BluetoothGattDescriptor)object.next();
                bluetoothGattDescriptor.setValue(byArray);
                bluetoothGatt.writeDescriptor(bluetoothGattDescriptor);
            }
            return;
        }
    }

    private static void bluetoothGattRefresh(BluetoothGatt bluetoothGatt) {
        Class<?> clazz = bluetoothGatt.getClass();
        try {
            ((Boolean)clazz.getMethod("refresh", new Class[0]).invoke((Object)bluetoothGatt, new Object[0])).booleanValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void writeCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        BluetoothGatt bluetoothGatt = this.mBluetoothGatt;
        if (bluetoothGatt != null && bluetoothGattCharacteristic != null) {
            try {
                bluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disconnect();
            }
        }
    }

    private void ota(String string) {
        Log.e((String)TAG, (String)("ota ip -> " + string));
        this.send(("AT+OTA=0," + string + "," + 8082 + "\r\n").getBytes());
    }

    private void otaDFU(String string) {
        Log.e((String)TAG, (String)("otaDFU dfuName -> " + string));
        this.send(("AT+OTA=" + string + "\r\n").getBytes());
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            stringBuilder2.append(String.format("%02x ", objectArray2).toUpperCase());
        }
        return stringBuilder2.toString();
    }

    public static /* synthetic */ int access$202(FscBleCentralApiImp fscBleCentralApiImp, int n) {
        fscBleCentralApiImp.maxPackgeSize = n;
        return n;
    }

    public static /* synthetic */ FscOtaCentralCallbacks access$402(FscBleCentralApiImp fscBleCentralApiImp, FscOtaCentralCallbacks fscOtaCentralCallbacks) {
        fscBleCentralApiImp.mOtaCentralCallbacks = fscOtaCentralCallbacks;
        return fscOtaCentralCallbacks;
    }

    public static /* synthetic */ FscNetworkCentralCallbacks access$502(FscBleCentralApiImp fscBleCentralApiImp, FscNetworkCentralCallbacks fscNetworkCentralCallbacks) {
        fscBleCentralApiImp.mFscNetworkCentralCallbacks = fscNetworkCentralCallbacks;
        return fscNetworkCentralCallbacks;
    }

    public static /* synthetic */ BluetoothGatt access$702(FscBleCentralApiImp fscBleCentralApiImp, BluetoothGatt bluetoothGatt) {
        fscBleCentralApiImp.mBluetoothGatt = bluetoothGatt;
        return bluetoothGatt;
    }

    public static /* synthetic */ String access$1502(FscBleCentralApiImp fscBleCentralApiImp, String string) {
        fscBleCentralApiImp.receivePasswordInfo = string;
        return string;
    }

    public static /* synthetic */ boolean access$1902(FscBleCentralApiImp fscBleCentralApiImp, boolean bl) {
        fscBleCentralApiImp.isAtCommand = bl;
        return bl;
    }

    @Override
    public void initialize() {
        Context context = mContext;
        if (context != null) {
            if (this.mBluetoothManager == null) {
                this.mBluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
            }
            if (this.mBluetoothAdapter == null) {
                this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
            }
            this.mFeasycomApiImp = FscEncryptApiImp.getInstance();
        }
    }

    @Override
    public boolean isBtEnabled() {
        return this.mBluetoothAdapter.isEnabled();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean enabled() {
        return this.mBluetoothAdapter.enable();
    }

    @Override
    public void setCallbacks(FscBleCentralCallbacks fscBleCentralCallbacks) {
        if (fscBleCentralCallbacks != null) {
            ((FscBleCentralApiImp)((Object)fscBleCentralCallbacksImp2)).mUiCallback = fscBleCentralCallbacks;
        } else {
            FscBleCentralCallbacksImp fscBleCentralCallbacksImp;
            FscBleCentralApiImp fscBleCentralApiImp = fscBleCentralCallbacksImp2;
            FscBleCentralCallbacksImp fscBleCentralCallbacksImp2 = fscBleCentralCallbacksImp;
            fscBleCentralCallbacksImp = new FscBleCentralCallbacksImp();
            fscBleCentralApiImp.mUiCallback = fscBleCentralCallbacksImp2;
        }
    }

    @Override
    public boolean connect(String string) {
        FscBleCentralApiImp fscBleCentralApiImp = this;
        fscBleCentralApiImp.isBeacon = false;
        fscBleCentralApiImp.sendPasswordInfo = fscBleCentralApiImp.mFeasycomApiImp.getEncrypted();
        fscBleCentralApiImp.connectGatt(fscBleCentralApiImp.mBluetoothAdapter.getRemoteDevice(string));
        return true;
    }

    @Override
    public boolean connect(String string, String string2) {
        if (string2 != null) {
            String string3;
            try {
                String string4 = string2;
                string3 = string4;
                Integer.valueOf(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            if (string3.length() == 0 || string2.length() > 6) {
                return false;
            }
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        fscBleCentralApiImp.isBeacon = true;
        fscBleCentralApiImp.sendPasswordInfo = fscBleCentralApiImp.mFeasycomApiImp.getBeaconEncrypted(string, string2);
        fscBleCentralApiImp.connectGatt(fscBleCentralApiImp.mBluetoothAdapter.getRemoteDevice(string));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"MissingPermission"})
    public void connectGatt(BluetoothDevice bluetoothDevice) {
        try {
            BluetoothGatt bluetoothGatt;
            FscBleCentralApiImp fscBleCentralApiImp;
            this.take = new byte[0];
            this.connectCount = 0;
            this.isAtCommand = false;
            this.receivePasswordInfo = null;
            this.sHandler.removeCallbacks(this.mOnConnectTimeoutCallback);
            if (Build.VERSION.SDK_INT >= 23) {
                fscBleCentralApiImp = this;
                Context context = mContext;
                boolean bl = false;
                BluetoothGattCallback bluetoothGattCallback = this.mBleCallback;
                bluetoothGatt = bluetoothDevice.connectGatt(context, bl, bluetoothGattCallback, 2);
            } else {
                fscBleCentralApiImp = this;
                Context context = mContext;
                boolean bl = false;
                BluetoothGattCallback bluetoothGattCallback = this.mBleCallback;
                bluetoothGatt = bluetoothDevice.connectGatt(context, bl, bluetoothGattCallback);
            }
            fscBleCentralApiImp.mBluetoothGatt = bluetoothGatt;
            this.mBluetoothDevice = bluetoothDevice;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void disconnect() {
        BluetoothGatt bluetoothGatt = this.mBluetoothGatt;
        if (bluetoothGatt != null) {
            bluetoothGatt.disconnect();
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        fscBleCentralApiImp.sHandler.removeCallbacks(this.atCommandOut);
        fscBleCentralApiImp.sHandler.removeCallbacks(this.runnable);
        fscBleCentralApiImp.sHandler.removeCallbacks(this.r);
        fscBleCentralApiImp.sHandler.removeCallbacks(this.mRunnable);
        fscBleCentralApiImp.mOtaCentralCallbacks = null;
        fscBleCentralApiImp.mFscNetworkCentralCallbacks = null;
    }

    @SuppressLint(value={"MissingPermission"})
    public void close(BluetoothGatt bluetoothGatt) {
        if (bluetoothGatt != null) {
            bluetoothGatt.close();
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void startScan(Long l) {
        Runnable runnable = ((FscBleCentralApiImp)((Object)runnable2)).stopScanRunnable;
        if (runnable != null) {
            ((FscBleCentralApiImp)((Object)runnable2)).sHandler.removeCallbacks(runnable);
        }
        Log.e((String)TAG, (String)"startScan:    ");
        if (Build.VERSION.SDK_INT >= 21) {
            Log.e((String)TAG, (String)"startScan: \u5f00\u59cb\u626b\u63cf1");
            FscBleCentralApiImp fscBleCentralApiImp = runnable2;
            runnable = fscBleCentralApiImp.mScanSettings;
            ScanCallback scanCallback = fscBleCentralApiImp.mScanCallback;
            ((FscBleCentralApiImp)((Object)runnable2)).mBluetoothAdapter.getBluetoothLeScanner().startScan(null, (ScanSettings)runnable, scanCallback);
        } else {
            Log.e((String)TAG, (String)"startScan: \u5f00\u59cb\u626b\u63cf2");
            ((FscBleCentralApiImp)((Object)runnable2)).mBluetoothAdapter.startLeScan(((FscBleCentralApiImp)((Object)runnable2)).mDeviceFoundCallback);
        }
        if (l != 0L) {
            Runnable runnable2 = ((FscBleCentralApiImp)((Object)runnable2)).stopScanRunnable;
            long l2 = l;
            ((FscBleCentralApiImp)((Object)runnable2)).sHandler.postDelayed(runnable2, l2);
        } else {
            ((FscBleCentralApiImp)((Object)runnable2)).sHandler.postDelayed(((FscBleCentralApiImp)((Object)runnable2)).stopScanRunnable, 15000L);
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void stopScan() {
        Object object;
        Log.e((String)TAG, (String)"stopScan: \u505c\u6b62\u626b\u63cf  ");
        if (Build.VERSION.SDK_INT >= 21) {
            object = this.mBluetoothAdapter.getBluetoothLeScanner();
            if (object != null) {
                object.stopScan(this.mScanCallback);
            }
        } else {
            this.mBluetoothAdapter.stopLeScan(this.mDeviceFoundCallback);
        }
        if ((object = this.stopScanRunnable) != null) {
            this.sHandler.removeCallbacks((Runnable)object);
        }
    }

    @Override
    public boolean isConnect() {
        return this.mBluetoothDevice != null;
    }

    @Override
    public boolean send(byte[] byArray) {
        if (this.mWriteCharacteristic != null) {
            new Thread(() -> {
                this.mWriteCharacteristic.setValue(byArray);
                try {
                    while (this.isDeviceBusy()) {
                        Thread.sleep(6L);
                    }
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                FscBleCentralApiImp fscBleCentralApiImp = this;
                fscBleCentralApiImp.writeCharacteristic(fscBleCentralApiImp.mWriteCharacteristic);
            }).start();
        }
        return true;
    }

    @Override
    public void setNetwork(String string, String string2, FscNetworkCentralCallbacks fscNetworkCentralCallbacks) {
        Log.e((String)TAG, (String)"setNetwork: --------------------------");
        this.mFscNetworkCentralCallbacks = fscNetworkCentralCallbacks;
        if (string2.isEmpty()) {
            this.send(("AT+RAP=" + string + "\r\n").getBytes());
        } else {
            this.send(("AT+RAP=" + string + "," + string2 + "\r\n").getBytes());
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        fscBleCentralApiImp.sHandler.removeCallbacks(this.r);
        fscBleCentralApiImp.sHandler.postDelayed(this.r, 1000L);
        fscBleCentralApiImp.sHandler.postDelayed(this.mRunnable, 15000L);
    }

    @Override
    public void getIp() {
        this.send("AT+LIP\r\n".getBytes());
    }

    @Override
    public void getVersion() {
        this.send("AT+VER\r\n".getBytes());
    }

    @Override
    public void reset() {
        this.send("AT+RESTORE\r\n".getBytes());
    }

    @Override
    public void setBroker(String string) {
        this.send(("AT+BROKER=" + string + "\r\n").getBytes());
    }

    @Override
    public void setPort(String string) {
        this.send(("AT+PORT=" + string + "\r\n").getBytes());
    }

    @Override
    public void setTopic(String string) {
        this.send(("AT+TOPIC=" + string + "\r\n").getBytes());
    }

    @Override
    public void setCert(String string) {
        this.send(("AT+CERT=" + string + "\r\n").getBytes());
    }

    @Override
    public void setKey(String string) {
        this.send(("AT+KEY=" + string + "\r\n").getBytes());
    }

    @Override
    public void getMac() {
        this.send("AT+MAC\r\n".getBytes());
    }

    @Override
    public void getVer() {
        this.send("AT+VER\r\n".getBytes());
    }

    @Override
    public void startOTA(String string, FscOtaCentralCallbacks fscOtaCentralCallbacks) {
        this.mOtaCentralCallbacks = fscOtaCentralCallbacks;
        this.otaName = string;
        this.getIp();
    }

    @Override
    public void setReboot() {
        this.send("AT+REBOOT\r\n".getBytes());
    }

    @Override
    public void getDhcp() {
        this.send("AT+DHCP\r\n".getBytes());
    }

    @Override
    public void setIp(@NotNull String string) {
        this.send(("AT+SIP=" + string + "\r\n").getBytes());
    }

    @Override
    public void setGw(String string) {
        this.send(("AT+GW=" + string + "\r\n").getBytes());
    }

    @Override
    public void setMask(String string) {
        this.send(("AT+MASK=" + string + "\r\n").getBytes());
    }

    @Override
    public void setDns(String string) {
        this.send(("AT+DNS=" + string + "\r\n").getBytes());
    }

    @Override
    public void setDhcp(@NotNull boolean bl) {
        if (bl) {
            this.send("AT+DHCP=1\r\n".getBytes());
        } else {
            this.send("AT+DHCP=0\r\n".getBytes());
        }
    }
}

