/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.encrypted.controler;

import androidx.annotation.Keep;
import com.feasycom.encrypted.bean.EncryptAlgorithm;
import com.feasycom.encrypted.bean.EncryptInfo;
import com.feasycom.encrypted.controler.FscEncryptApi;
import com.feasycom.encrypted.utils.EncryptedUtil;

public class FscEncryptApiImp
implements FscEncryptApi {
    private static final String TAG = "FeasycomApiImp";
    private static FscEncryptApi instance;
    private EncryptInfo mEncryptInfo;

    @Keep
    public static synchronized FscEncryptApi getInstance() {
        if (instance == null) {
            instance = new FscEncryptApiImp();
        }
        return instance;
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            stringBuilder2.append(String.format("%02x ", objectArray2).toUpperCase());
        }
        return stringBuilder2.toString();
    }

    private FscEncryptApiImp() {
    }

    static {
        System.loadLibrary("util");
    }

    @Override
    public byte[] getEncrypted() {
        this.mEncryptInfo = EncryptInfo.createRandom("Universal");
        return EncryptedUtil.covAssicAndByte("AUTH", this.mEncryptInfo.getPassword());
    }

    @Override
    public byte[] getBeaconEncrypted(String string, String string2) {
        this.mEncryptInfo = EncryptInfo.create(string, string2, "Beacon");
        return EncryptedUtil.covAssicAndByte("AUTH", this.mEncryptInfo.getPassword());
    }

    @Override
    public boolean verifyEncrypted(byte[] object) {
        object = FscEncryptApiImp.toHexString(object).replace(" ", "").toUpperCase();
        if (this.mEncryptInfo.isEncryptAlgorithmUniversal()) {
            return EncryptAlgorithm.Universal.randomNumberMatches(this.mEncryptInfo, (String)object);
        }
        if (this.mEncryptInfo.isEncryptAlgorithmBeacon()) {
            return EncryptAlgorithm.Beacon.randomNumberMatches(this.mEncryptInfo, (String)object);
        }
        return false;
    }
}

