/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.encrypted.bean;

import androidx.annotation.Keep;

@Keep
public class EncryptInfo {
    private static final String TAG = "EncryptInfo";
    public static final int ENCRYPT_WAY = 2;
    public static final String ENCRYPT_BEACON = "Beacon";
    public static final String ENCRYPT_UNIVERSAL = "Universal";
    private String mPassword = "";
    private String mRandomNumber = "";
    private String mEncryptAlgorithm = "";

    private EncryptInfo(String[] stringArray, String string) {
        this.mPassword = stringArray[0];
        this.mRandomNumber = stringArray[1];
        this.mEncryptAlgorithm = string;
    }

    private static native String[] gen(String var0, String var1);

    public static EncryptInfo create(String stringArray, String string, String string2) {
        try {
            stringArray = EncryptInfo.gen((String)stringArray, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String[] stringArray2 = new String[3];
            stringArray = stringArray2;
            stringArray2[0] = " ";
            stringArray2[1] = " ";
            stringArray2[2] = " ";
        }
        return new EncryptInfo(stringArray, string2);
    }

    public static native EncryptInfo createRandom(String var0);

    static {
        System.loadLibrary("util");
    }

    public boolean isEncryptAlgorithmUniversal() {
        String string = ((EncryptInfo)((Object)string)).mEncryptAlgorithm;
        return string != null && string.equals(ENCRYPT_UNIVERSAL);
    }

    public boolean isEncryptAlgorithmBeacon() {
        String string = ((EncryptInfo)((Object)string)).mEncryptAlgorithm;
        return string != null && string.equals(ENCRYPT_BEACON);
    }

    public String getEncryptAlgorithm() {
        return this.mEncryptAlgorithm;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getRandomNumber() {
        return this.mRandomNumber.toUpperCase();
    }
}

