/*
 * Decompiled with CFR 0.152.
 */
package com.feasycom.ble.controler;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import com.feasycom.ble.bean.BluetoothDeviceWrapper;
import com.feasycom.ble.controler.FscBleCentralApi;
import com.feasycom.ble.controler.FscBleCentralCallbacks;
import com.feasycom.ble.utils.FeasycomUtil;
import com.feasycom.common.bean.FscDevice;
import com.feasycom.common.bean.ScannerFilter;
import com.feasycom.common.utils.FileUtilsKt;
import com.feasycom.common.utils.MsgLogger;
import com.feasycom.network.utils.NetworkUtil;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FscBleCentralApiImp
implements FscBleCentralApi,
BluetoothDeviceWrapper.ConnectCallback {
    private static final String TAG = "FscBleCentralApiImp";
    private static Context sContext;
    private static FscBleCentralApi instance;
    public static boolean isDebug = true;
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private FscBleCentralCallbacks mFscBleCentralCallbacks;
    private final Handler mHandler;
    private ScanSettings mScanSettings;
    private Boolean SCAN_FINISH;
    private final Runnable mRunnable;
    private final int MAX_CONNECT_NUMBER;
    private final Map<String, BluetoothDeviceWrapper> deviceMap;
    private final ArrayList<String> addressList;
    private final BluetoothAdapter.LeScanCallback scanCallbacks;
    private final ScanCallback mScanCallback;

    private FscBleCentralApiImp() {
        FscBleCentralApiImp fscBleCentralApiImp = string;
        fscBleCentralApiImp.mHandler = new Handler(Looper.getMainLooper());
        fscBleCentralApiImp.SCAN_FINISH = Boolean.TRUE;
        fscBleCentralApiImp.mRunnable = () -> this.stopScan();
        fscBleCentralApiImp.MAX_CONNECT_NUMBER = 6;
        fscBleCentralApiImp.deviceMap = new HashMap<String, BluetoothDeviceWrapper>();
        fscBleCentralApiImp.addressList = new ArrayList();
        fscBleCentralApiImp.scanCallbacks = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice bluetoothDevice, int n, byte[] byArray) {
                FscDevice fscDevice;
                a a2 = fscDevice2;
                FscDevice fscDevice2 = fscDevice;
                BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                String string = bluetoothDevice2.getName();
                fscDevice2(string, bluetoothDevice2.getAddress(), bluetoothDevice, n, "BLE");
                fscDevice2.setScanRecord(byArray);
                FeasycomUtil.parseAdvData(fscDevice, byArray);
                a2.FscBleCentralApiImp.this.mFscBleCentralCallbacks.blePeripheralFound(fscDevice2, n, byArray);
            }
        };
        fscBleCentralApiImp.mScanCallback = new ScanCallback(){

            public void onScanResult(int n, ScanResult scanResult) {
                FscDevice fscDevice;
                b b2 = b3;
                ScanResult scanResult2 = scanResult;
                super.onScanResult(n, scanResult);
                b b3 = scanResult2.getDevice();
                String string = b3.getAddress();
                int n2 = scanResult2.getRssi();
                byte[] byArray = scanResult2.getScanRecord().getBytes();
                FscDevice fscDevice2 = fscDevice;
                fscDevice2(b3.getName(), string, (BluetoothDevice)b3, n2, "BLE");
                fscDevice2.setScanRecord(byArray);
                FeasycomUtil.parseAdvData(fscDevice, byArray);
                b2.FscBleCentralApiImp.this.mFscBleCentralCallbacks.blePeripheralFound(fscDevice2, n2, byArray);
            }

            public void onBatchScanResults(List<ScanResult> list) {
                super.onBatchScanResults(list);
            }

            public void onScanFailed(int n) {
                super.onScanFailed(n);
                MsgLogger.e("=======================onScanFailed \u9519\u8bef\u7801 => " + n + " =================");
            }
        };
        String string = FileUtilsKt.getAppName(sContext);
        String string2 = FileUtilsKt.getAppVersion(sContext);
        NetworkUtil.feedback(sContext, "FeasyBlue<BLE-SDK\u542f\u52a8\u8bb0\u5f55>" + "\n1.App Name = " + (String)string + "\n2.App Version = " + string2 + "\n3.Package Name = " + FileUtilsKt.getPackageName(sContext) + "\n4.SDK Version = " + "3.5.1.1", true);
    }

    @Keep
    public static FscBleCentralApi getInstance(Context context) {
        sContext = context;
        if (instance == null) {
            instance = new FscBleCentralApiImp();
        }
        return instance;
    }

    @Keep
    public static FscBleCentralApi getInstance() {
        if (instance == null) {
            instance = new FscBleCentralApiImp();
        }
        return instance;
    }

    @Override
    public void isShowLog(boolean bl) {
        isDebug = bl;
    }

    @Override
    public boolean initialize() {
        if (this.mBluetoothManager == null && (this.mBluetoothManager = (BluetoothManager)sContext.getSystemService("bluetooth")) == null) {
            return false;
        }
        if (this.mBluetoothAdapter == null && (this.mBluetoothAdapter = this.mBluetoothManager.getAdapter()) == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mScanSettings = new ScanSettings.Builder().setScanMode(2).setReportDelay(0L).build();
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        FscBleCentralApiImp fscBleCentralApiImp = fscBleCentralApiImp.mBluetoothAdapter;
        if (fscBleCentralApiImp == null) {
            return false;
        }
        return fscBleCentralApiImp.isEnabled();
    }

    @Override
    @Keep
    public void setCallbacks(FscBleCentralCallbacks fscBleCentralCallbacks) {
        ((FscBleCentralApiImp)((Object)iterator)).mFscBleCentralCallbacks = fscBleCentralCallbacks;
        Iterator<BluetoothDeviceWrapper> iterator = ((FscBleCentralApiImp)((Object)iterator)).deviceMap.values().iterator();
        while (iterator.hasNext()) {
            ((BluetoothDeviceWrapper)iterator.next()).setCharacteristic(fscBleCentralCallbacks);
        }
    }

    @Override
    public void connect(String string, Boolean bl) {
        BluetoothDevice bluetoothDevice;
        if (((FscBleCentralApiImp)((Object)fscBleCentralCallbacks)).deviceMap.size() < 6 && (bluetoothDevice = ((FscBleCentralApiImp)((Object)fscBleCentralCallbacks)).mBluetoothAdapter.getRemoteDevice(string)) != null) {
            BluetoothDeviceWrapper bluetoothDeviceWrapper;
            FscBleCentralApiImp fscBleCentralApiImp = fscBleCentralCallbacks;
            BluetoothDeviceWrapper bluetoothDeviceWrapper2 = bluetoothDeviceWrapper;
            bluetoothDeviceWrapper2(bluetoothDevice.getAddress(), bluetoothDevice, sContext, (BluetoothDeviceWrapper.ConnectCallback)((Object)fscBleCentralCallbacks));
            FscBleCentralCallbacks fscBleCentralCallbacks = ((FscBleCentralApiImp)((Object)fscBleCentralCallbacks)).mFscBleCentralCallbacks;
            bluetoothDeviceWrapper.connect(fscBleCentralCallbacks, bl);
            fscBleCentralApiImp.deviceMap.put(string, bluetoothDeviceWrapper2);
            fscBleCentralApiImp.addressList.add(string);
        }
    }

    @Override
    public void connectToModify(String string) {
        BluetoothDevice bluetoothDevice;
        if (this.deviceMap.size() < 6 && (bluetoothDevice = this.mBluetoothAdapter.getRemoteDevice(string)) != null) {
            BluetoothDeviceWrapper bluetoothDeviceWrapper;
            FscBleCentralApiImp fscBleCentralApiImp = this;
            BluetoothDeviceWrapper bluetoothDeviceWrapper2 = bluetoothDeviceWrapper;
            bluetoothDeviceWrapper2(bluetoothDevice.getAddress(), bluetoothDevice, sContext, this);
            bluetoothDeviceWrapper.connectToModify(this.mFscBleCentralCallbacks);
            fscBleCentralApiImp.deviceMap.put(string, bluetoothDeviceWrapper2);
            fscBleCentralApiImp.addressList.add(string);
        }
    }

    @Override
    public void connectToOTAWithFactory(@Nullable String string, @NotNull byte[] byArray, boolean bl) {
        if (this.deviceMap.size() < 6) {
            BluetoothDeviceWrapper bluetoothDeviceWrapper;
            FscBleCentralApiImp fscBleCentralApiImp = this;
            BluetoothDevice bluetoothDevice = fscBleCentralApiImp.mBluetoothAdapter.getRemoteDevice(string);
            BluetoothDeviceWrapper bluetoothDeviceWrapper2 = bluetoothDeviceWrapper;
            bluetoothDeviceWrapper2(bluetoothDevice.getAddress(), bluetoothDevice, sContext, this);
            bluetoothDeviceWrapper.connectToOTAWithFactory(this.mFscBleCentralCallbacks, byArray, bl, Integer.MAX_VALUE);
            fscBleCentralApiImp.deviceMap.put(string, bluetoothDeviceWrapper2);
            fscBleCentralApiImp.addressList.add(string);
        }
    }

    @Override
    public void connectToVerifyOTAWithFactory(String string, byte[] byArray, boolean bl, boolean bl2) {
    }

    @Override
    public void startOTA(String string, byte[] byArray, boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean clearDevice(String string) {
        Iterator iterator = ((FscBleCentralApiImp)((Object)iterator)).mBluetoothAdapter.getBondedDevices().iterator();
        while (iterator.hasNext()) {
            ReflectiveOperationException reflectiveOperationException2;
            BluetoothDevice bluetoothDevice = (BluetoothDevice)iterator.next();
            if (!bluetoothDevice.getAddress().equals(string)) continue;
            Method method = null;
            try {
                method = bluetoothDevice.getClass().getMethod("removeBond", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            try {
                try {
                    return (Boolean)method.invoke((Object)bluetoothDevice, null);
                }
                catch (InvocationTargetException reflectiveOperationException2) {
                }
            }
            catch (IllegalAccessException reflectiveOperationException2) {
                // empty catch block
            }
            reflectiveOperationException2.printStackTrace();
        }
        return false;
    }

    @Override
    public void disconnect() {
        if (this.addressList.isEmpty()) {
            return;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        fscBleCentralApiImp.disconnect(arrayList.get(arrayList.size() - 1));
    }

    @Override
    public void disconnect(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = this.deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            FscBleCentralApiImp fscBleCentralApiImp = this;
            bluetoothDeviceWrapper.disconnect();
            fscBleCentralApiImp.deviceMap.remove(string);
            fscBleCentralApiImp.addressList.remove(string);
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public List<FscDevice> getBondDevices() {
        ArrayList arrayList;
        FscBleCentralApiImp fscBleCentralApiImp = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator iterator = fscBleCentralApiImp.mBluetoothAdapter.getBondedDevices().iterator();
        while (iterator.hasNext()) {
            BluetoothDevice bluetoothDevice;
            BluetoothDevice bluetoothDevice2 = bluetoothDevice = (BluetoothDevice)iterator.next();
            String string = bluetoothDevice2.getName();
            arrayList2.add(new FscDevice(string, bluetoothDevice2.getAddress(), bluetoothDevice, 0, "BLE"));
        }
        return arrayList2;
    }

    @Override
    public void startScan() {
        this.startScan(null);
    }

    @Override
    @SuppressLint(value={"MissingPermission", "ObsoleteSdkInt"})
    public void startScan(ScannerFilter object) {
        if (!this.SCAN_FINISH.booleanValue()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            FscBleCentralApiImp fscBleCentralApiImp = this;
            object = fscBleCentralApiImp.mScanSettings;
            ScanCallback scanCallback = fscBleCentralApiImp.mScanCallback;
            this.mBluetoothAdapter.getBluetoothLeScanner().startScan(null, (ScanSettings)object, scanCallback);
        } else {
            this.mBluetoothAdapter.startLeScan(this.scanCallbacks);
        }
        object = this.mFscBleCentralCallbacks;
        if (object != null) {
            object.startScan();
        }
        this.SCAN_FINISH = Boolean.FALSE;
        this.mHandler.postDelayed(this.mRunnable, 10000L);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void stopScan() {
        this.mHandler.removeCallbacks(this.mRunnable);
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.mBluetoothAdapter.getBluetoothLeScanner() == null) {
                return;
            }
            this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.mScanCallback);
        } else {
            this.mBluetoothAdapter.stopLeScan(this.scanCallbacks);
        }
        this.SCAN_FINISH = Boolean.TRUE;
        this.mFscBleCentralCallbacks.stopScan();
    }

    @Override
    public boolean pauseSend(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.pauseSend();
        }
        return false;
    }

    @Override
    public boolean continueSend(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.continueSend();
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.addressList.isEmpty() ^ true;
    }

    @Override
    public boolean isConnected(String string) {
        return this.deviceMap.containsKey(string);
    }

    @Override
    public void setSendInterval(String string, Long l) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            bluetoothDeviceWrapper.setSendInterval(l);
        }
    }

    @Override
    public boolean send(String string) {
        if (this.addressList.isEmpty()) {
            return false;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.send(arrayList.get(arrayList.size() - 1), string);
    }

    @Override
    public boolean send(String string, String string2) {
        return this.send(string, string2.getBytes());
    }

    @Override
    public boolean send(byte[] byArray) {
        if (this.addressList.isEmpty()) {
            return false;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.send(arrayList.get(arrayList.size() - 1), byArray);
    }

    @Override
    public boolean send(String string, byte[] byArray) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper == null) {
            return false;
        }
        return bluetoothDeviceWrapper.send(byArray);
    }

    @Override
    public boolean sendFile(int n) {
        if (this.addressList.isEmpty()) {
            return false;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.sendFile(arrayList.get(arrayList.size() - 1), n);
    }

    @Override
    public boolean sendFile(String string, int n) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.sendFile(n);
        }
        return false;
    }

    @Override
    public void sendATCommand(Set<String> set) {
        if (this.addressList.isEmpty()) {
            return;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        fscBleCentralApiImp.sendATCommand(arrayList.get(arrayList.size() - 1), set);
    }

    @Override
    public void sendATCommand(String string, Set<String> set) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            bluetoothDeviceWrapper.sendATCommand(set);
        }
    }

    @Override
    public int getMtu() {
        if (this.addressList.isEmpty()) {
            return 0;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.getMtu(arrayList.get(arrayList.size() - 1));
    }

    @Override
    public int getMtu(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.getMRealMtu();
        }
        return 0;
    }

    @Override
    public int getMaximumPacketByte() {
        if (this.addressList.isEmpty()) {
            return 0;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.getMaximumPacketByte(arrayList.get(arrayList.size() - 1));
    }

    @Override
    public int getMaximumPacketByte(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.getMaximumPacketByte();
        }
        return 0;
    }

    @Override
    public void stopSend() {
        if (this.addressList.isEmpty()) {
            return;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        fscBleCentralApiImp.stopSend(arrayList.get(arrayList.size() - 1));
    }

    @Override
    public void stopSend(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            bluetoothDeviceWrapper.stopSend();
        }
    }

    @Override
    public boolean setCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
        if (this.addressList.isEmpty()) {
            return false;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.setCharacteristic(arrayList.get(arrayList.size() - 1), bluetoothGattCharacteristic, n);
    }

    @Override
    public boolean setCharacteristic(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.setCharacteristic(bluetoothGattCharacteristic, n);
        }
        return false;
    }

    @Override
    public boolean read(String string, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            bluetoothDeviceWrapper.read(bluetoothGattCharacteristic);
        }
        return false;
    }

    @Override
    public List<BluetoothGattService> getBluetoothGattServices(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.getBluetoothGattServices();
        }
        return null;
    }

    @Override
    public BluetoothGattCharacteristic getWriteCharacteristic(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.getWriteCharacteristic();
        }
        return null;
    }

    @Override
    public List<BluetoothGattCharacteristic> getNotifyCharacteristicList(String string) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.getNotifyCharacteristicList();
        }
        return null;
    }

    @Override
    @RequiresApi(api=21)
    public void requestMtu(int n) {
        if (this.addressList.isEmpty()) {
            return;
        }
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        fscBleCentralApiImp.requestMtu(arrayList.get(arrayList.size() - 1), n);
    }

    @Override
    @RequiresApi(api=21)
    public void requestMtu(String string, int n) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            bluetoothDeviceWrapper.requestMtu(n);
        }
    }

    @Override
    public void createBond() {
        Iterator<BluetoothDeviceWrapper> iterator = ((FscBleCentralApiImp)((Object)iterator)).deviceMap.values().iterator();
        while (iterator.hasNext()) {
            ((BluetoothDeviceWrapper)iterator.next()).createBond();
        }
    }

    @Override
    public void success(@NotNull BluetoothDeviceWrapper bluetoothDeviceWrapper) {
    }

    @Override
    public void failure(BluetoothDeviceWrapper bluetoothDeviceWrapper) {
        if (this.deviceMap.get(bluetoothDeviceWrapper.getMAddress()) != null) {
            FscBleCentralApiImp fscBleCentralApiImp = this;
            fscBleCentralApiImp.deviceMap.remove(bluetoothDeviceWrapper.getMAddress());
            fscBleCentralApiImp.addressList.remove(bluetoothDeviceWrapper.getMAddress());
        }
    }

    @Override
    public boolean sendFile(@NotNull InputStream inputStream) {
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.sendFile(arrayList.get(arrayList.size() - 1), inputStream);
    }

    @Override
    public boolean sendFile(@NotNull byte[] byArray) {
        FscBleCentralApiImp fscBleCentralApiImp = this;
        ArrayList<String> arrayList = fscBleCentralApiImp.addressList;
        return fscBleCentralApiImp.sendFile(arrayList.get(arrayList.size() - 1), byArray);
    }

    @Override
    public boolean sendFile(@Nullable String string, @NotNull InputStream inputStream) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.sendFile(inputStream);
        }
        return false;
    }

    @Override
    public boolean sendFile(@Nullable String string, @NotNull byte[] byArray) {
        BluetoothDeviceWrapper bluetoothDeviceWrapper = ((FscBleCentralApiImp)((Object)bluetoothDeviceWrapper)).deviceMap.get(string);
        if (bluetoothDeviceWrapper != null) {
            return bluetoothDeviceWrapper.sendFile(byArray);
        }
        return false;
    }
}

